/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.jet.sql.impl.aggregate.DistinctSqlAggregation;
import com.hazelcast.jet.sql.impl.aggregate.SqlAggregation;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DistinctSqlAggregationTest {
    @Mock
    private SqlAggregation delegate;
    @Mock
    private SqlAggregation otherDelegate;

    @Test
    public void test_accumulate() {
        DistinctSqlAggregation aggregation = new DistinctSqlAggregation(this.delegate);
        aggregation.accumulate((Object)"1");
        aggregation.accumulate((Object)"2");
        aggregation.accumulate((Object)"1");
        ((SqlAggregation)Mockito.verify((Object)this.delegate)).accumulate((Object)"1");
        ((SqlAggregation)Mockito.verify((Object)this.delegate)).accumulate((Object)"2");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.delegate});
    }

    @Test
    public void test_combine() {
        DistinctSqlAggregation left = new DistinctSqlAggregation(this.delegate);
        left.accumulate((Object)"1");
        left.accumulate((Object)"2");
        DistinctSqlAggregation right = new DistinctSqlAggregation(this.otherDelegate);
        right.accumulate((Object)"2");
        right.accumulate((Object)"3");
        left.combine((SqlAggregation)right);
        ((SqlAggregation)Mockito.verify((Object)this.delegate)).accumulate((Object)"1");
        ((SqlAggregation)Mockito.verify((Object)this.delegate)).accumulate((Object)"2");
        ((SqlAggregation)Mockito.verify((Object)this.delegate)).accumulate((Object)"3");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.delegate});
    }
}

