/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlService;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SelectWithoutFromStatementTest
extends SqlTestSupport {
    private final SqlService sqlService = SelectWithoutFromStatementTest.instance().getSql();

    @BeforeClass
    public static void beforeClass() {
        SelectWithoutFromStatementTest.initialize((int)1, null);
    }

    @Test
    public void when_fromStatementIsNotPresent_returnConstant() {
        this.checkWithType("SELECT 1", SqlColumnType.TINYINT, (byte)1);
        this.checkWithType("SELECT 10000", SqlColumnType.SMALLINT, (short)10000);
        this.checkWithType("SELECT 2000000000", SqlColumnType.INTEGER, 2000000000);
        this.checkWithType("SELECT 20000000000", SqlColumnType.BIGINT, 20000000000L);
        this.checkWithType("SELECT 1.0", SqlColumnType.DECIMAL, new BigDecimal("1.0"));
        this.checkWithType("SELECT 'ABCD'", SqlColumnType.VARCHAR, "ABCD");
    }

    @Test
    public void when_castIsApplied_returnCorrectType() {
        this.checkWithType("SELECT CAST(1 AS BIGINT)", SqlColumnType.BIGINT, 1L);
        this.checkWithType("SELECT CAST(1 AS DECIMAL)", SqlColumnType.DECIMAL, new BigDecimal("1"));
        this.checkWithType("SELECT CAST(1.0 AS DOUBLE)", SqlColumnType.DOUBLE, 1.0);
        this.checkWithType("SELECT CAST(1.0 AS REAL)", SqlColumnType.REAL, Float.valueOf(1.0f));
    }

    @Test
    public void when_functionCallIsPassed_returnFunctionResult() {
        this.checkWithType("SELECT TO_TIMESTAMP_TZ(0)", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, OffsetDateTime.ofInstant(Instant.EPOCH, ZoneId.systemDefault()));
        this.checkWithType("SELECT TO_TIMESTAMP_TZ(1)", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, OffsetDateTime.ofInstant(Instant.EPOCH.plusSeconds(1L), ZoneId.systemDefault()));
    }

    @Test
    public void when_illegalArgumentsAreProvided_fail() {
        SelectWithoutFromStatementTest.assertThrows(HazelcastSqlException.class, () -> this.execute("SELECT A"));
    }

    @Test
    public void when_multipleColumnsSelected_returnCorrectResult() {
        SqlRow row = this.execute("SELECT 1 as A, 'B' as B");
        Assert.assertEquals((Object)SqlColumnType.TINYINT, (Object)row.getMetadata().getColumn(0).getType());
        Assert.assertEquals((Object)SqlColumnType.VARCHAR, (Object)row.getMetadata().getColumn(1).getType());
        Assert.assertEquals((long)1L, (long)((Byte)row.getObject("A")).byteValue());
        Assert.assertEquals((Object)"B", (Object)row.getObject("B"));
    }

    private void checkWithType(String sql, SqlColumnType type, Object expected) {
        SqlRow row = this.execute(sql);
        Assert.assertEquals((long)1L, (long)row.getMetadata().getColumnCount());
        Assert.assertEquals((Object)type, (Object)row.getMetadata().getColumn(0).getType());
        Assert.assertEquals((Object)expected, (Object)row.getObject(0));
    }

    private SqlRow execute(String sql) {
        SqlResult result = this.sqlService.execute(sql, new Object[0]);
        return (SqlRow)result.iterator().next();
    }
}

