/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.config.IndexType;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.PartitioningAttributeConfig;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.map.model.Person;
import com.hazelcast.map.IMap;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class ExplainStatementTest
extends SqlTestSupport {
    @BeforeClass
    public static void setup() {
        ExplainStatementTest.initialize((int)1, null);
    }

    @Test
    public void test_explainStatementBase() {
        IMap map = ExplainStatementTest.instance().getMap("map");
        map.put((Object)1, (Object)10);
        String sql = "EXPLAIN SELECT * FROM map";
        ExplainStatementTest.createMapping("map", Integer.class, Integer.class);
        ExplainStatementTest.assertRowsOrdered(sql, Collections.singletonList(new SqlTestSupport.Row("FullScanPhysicalRel(table=[[hazelcast, public, map[projects=[$0, $1]]]], discriminator=[0])")));
        sql = "EXPLAIN PLAN FOR SELECT * FROM map";
        ExplainStatementTest.assertRowsOrdered(sql, Collections.singletonList(new SqlTestSupport.Row("FullScanPhysicalRel(table=[[hazelcast, public, map[projects=[$0, $1]]]], discriminator=[0])")));
    }

    @Test
    public void test_explainStatementDynamicParams() {
        IMap map = ExplainStatementTest.instance().getMap("map");
        map.put((Object)1, (Object)10);
        ExplainStatementTest.createMapping("map", Integer.class, Integer.class);
        String sql = "EXPLAIN SELECT * FROM map WHERE __key = ?";
        SqlStatement statement = new SqlStatement(sql).addParameter((Object)1);
        SqlResult result = ExplainStatementTest.instance().getSql().execute(statement);
        String expectedScanRes = "SelectByKeyMapPhysicalRel(table=[[hazelcast, public, map[projects=[$0, $1], filter==($0, ?0)]]], keyCondition=[?0], projections=[__key=[$0], this=[$1]])";
        Assert.assertEquals((Object)expectedScanRes, (Object)((SqlRow)result.iterator().next()).getObject(0));
    }

    @Test
    public void test_explainStatementIndexScan() {
        IMap map = ExplainStatementTest.instance().getMap("map");
        map.put((Object)1, (Object)10);
        map.put((Object)2, (Object)10);
        map.put((Object)3, (Object)10);
        map.put((Object)4, (Object)10);
        map.put((Object)5, (Object)10);
        map.addIndex(IndexType.HASH, new String[]{"this"});
        String sql = "EXPLAIN PLAN FOR SELECT * FROM map WHERE this = 10";
        ExplainStatementTest.createMapping("map", Integer.class, Integer.class);
        ExplainStatementTest.assertRowsOrdered(sql, Collections.singletonList(new SqlTestSupport.Row("IndexScanMapPhysicalRel(table=[[hazelcast, public, map[projects=[$0, $1]]]], index=[map_hash_this], indexExp=[=($1, 10)], remainderExp=[null])")));
    }

    @Test
    public void test_explainStatementSortedIndexScan() {
        IMap map = ExplainStatementTest.instance().getMap("map");
        map.put((Object)1, (Object)1);
        map.put((Object)2, (Object)2);
        map.put((Object)3, (Object)3);
        map.addIndex(IndexType.SORTED, new String[]{"this"});
        String sql = "EXPLAIN PLAN FOR SELECT * FROM map ORDER BY this";
        ExplainStatementTest.createMapping("map", Integer.class, Integer.class);
        ExplainStatementTest.assertRowsOrdered(sql, Collections.singletonList(new SqlTestSupport.Row("IndexScanMapPhysicalRel(table=[[hazelcast, public, map[projects=[$0, $1]]]], index=[map_sorted_this], indexExp=[null], remainderExp=[null], requiresSort=[true])")));
    }

    @Test
    public void test_explainStatementLimitOffsetWithIndexScan() {
        IMap map = ExplainStatementTest.instance().getMap("map");
        map.put((Object)1, (Object)1);
        map.put((Object)2, (Object)2);
        map.put((Object)3, (Object)3);
        map.put((Object)4, (Object)4);
        map.addIndex(IndexType.SORTED, new String[]{"this"});
        String sql = "EXPLAIN PLAN FOR SELECT * FROM map ORDER BY this LIMIT 1 OFFSET 1";
        ExplainStatementTest.createMapping("map", Integer.class, Integer.class);
        ExplainStatementTest.assertRowsOrdered(sql, Arrays.asList(new SqlTestSupport.Row("LimitPhysicalRel(offset=[1:TINYINT(1)], fetch=[1:TINYINT(1)])"), new SqlTestSupport.Row("  IndexScanMapPhysicalRel(table=[[hazelcast, public, map[projects=[$0, $1]]]], index=[map_sorted_this], indexExp=[null], remainderExp=[null], requiresSort=[true])")));
    }

    @Test
    public void test_explainStatementOrderedScanBelowUnion() {
        IMap map = ExplainStatementTest.instance().getMap("map");
        map.put((Object)1, (Object)1);
        map.put((Object)2, (Object)2);
        map.put((Object)3, (Object)3);
        String sql = "EXPLAIN PLAN FOR SELECT * FROM map UNION ALL SELECT * FROM map ORDER BY this DESC";
        ExplainStatementTest.createMapping("map", Integer.class, Integer.class);
        ExplainStatementTest.assertRowsOrdered(sql, Arrays.asList(new SqlTestSupport.Row("SortPhysicalRel(sort0=[$1], dir0=[DESC])"), new SqlTestSupport.Row("  UnionPhysicalRel(all=[true])"), new SqlTestSupport.Row("    FullScanPhysicalRel(table=[[hazelcast, public, map[projects=[$0, $1]]]], discriminator=[0])"), new SqlTestSupport.Row("    FullScanPhysicalRel(table=[[hazelcast, public, map[projects=[$0, $1]]]], discriminator=[0])")));
    }

    @Test
    public void test_explainStatementOrderedScanBelowUnionWithIndexScan() {
        IMap map = ExplainStatementTest.instance().getMap("map");
        map.put((Object)1, (Object)1);
        map.put((Object)2, (Object)2);
        map.put((Object)3, (Object)3);
        map.addIndex(IndexType.SORTED, new String[]{"this"});
        String sql = "EXPLAIN PLAN FOR SELECT * FROM map WHERE this > 2 UNION ALL SELECT * FROM map WHERE this < 2 ORDER BY this DESC";
        ExplainStatementTest.createMapping("map", Integer.class, Integer.class);
        ExplainStatementTest.assertRowsOrdered(sql, Arrays.asList(new SqlTestSupport.Row("SortPhysicalRel(sort0=[$1], dir0=[DESC])"), new SqlTestSupport.Row("  UnionPhysicalRel(all=[true])"), new SqlTestSupport.Row("    IndexScanMapPhysicalRel(table=[[hazelcast, public, map[projects=[$0, $1]]]], index=[map_sorted_this], indexExp=[>($1, 2)], remainderExp=[null])"), new SqlTestSupport.Row("    IndexScanMapPhysicalRel(table=[[hazelcast, public, map[projects=[$0, $1]]]], index=[map_sorted_this], indexExp=[<($1, 2)], remainderExp=[null])")));
    }

    @Test
    public void test_explainStatementSelectBelowUnion() {
        IMap map = ExplainStatementTest.instance().getMap("map");
        map.put((Object)1, (Object)10);
        String sql = "EXPLAIN PLAN FOR SELECT * FROM map UNION ALL SELECT * FROM map";
        ExplainStatementTest.createMapping("map", Integer.class, Integer.class);
        ExplainStatementTest.assertRowsOrdered(sql, Arrays.asList(new SqlTestSupport.Row("UnionPhysicalRel(all=[true])"), new SqlTestSupport.Row("  FullScanPhysicalRel(table=[[hazelcast, public, map[projects=[$0, $1]]]], discriminator=[0])"), new SqlTestSupport.Row("  FullScanPhysicalRel(table=[[hazelcast, public, map[projects=[$0, $1]]]], discriminator=[0])")));
    }

    @Test
    public void test_explainStatementJoin() {
        IMap map1 = ExplainStatementTest.instance().getMap("map1");
        map1.put((Object)10, (Object)1);
        IMap map2 = ExplainStatementTest.instance().getMap("map2");
        map2.put((Object)1, (Object)new Person(10, "A"));
        String sql = "EXPLAIN PLAN FOR SELECT map1.__key, map2.name FROM map1 INNER JOIN map2 ON map1.__key = map2.id";
        ExplainStatementTest.createMapping("map1", Integer.class, Integer.class);
        ExplainStatementTest.createMapping("map2", Integer.class, Person.class);
        ExplainStatementTest.assertRowsOrdered(sql, Arrays.asList(new SqlTestSupport.Row("CalcPhysicalRel(expr#0..5=[{inputs}], __key=[$t0], name=[$t4])"), new SqlTestSupport.Row("  JoinNestedLoopPhysicalRel(condition=[=($0, $3)], joinType=[inner], conditionType=[equiJoin])"), new SqlTestSupport.Row("    FullScanPhysicalRel(table=[[hazelcast, public, map1[projects=[$0, $1]]]], discriminator=[0])"), new SqlTestSupport.Row("    FullScanPhysicalRel(table=[[hazelcast, public, map2[projects=[$0, $1, $2, $3]]]], discriminator=[0])")));
    }

    @Test
    public void test_explainStatementInsert() {
        IMap map = ExplainStatementTest.instance().getMap("map");
        map.put((Object)1, (Object)1);
        String sql = "EXPLAIN PLAN FOR INSERT INTO map VALUES (2, 2)";
        ExplainStatementTest.createMapping("map", Integer.class, Integer.class);
        ExplainStatementTest.assertRowsOrdered(sql, Collections.singletonList(new SqlTestSupport.Row("InsertMapPhysicalRel(table=[[hazelcast, public, map[projects=[$0, $1]]]], values=[{expressions=[[ConstantExpression{type=INT, value=2}, ConstantExpression{type=INT, value=2}]]}])")));
        ExplainStatementTest.createMapping("map", Integer.class, Integer.class);
        sql = "EXPLAIN PLAN FOR INSERT INTO map VALUES (3, 3), (4, 4)";
        ExplainStatementTest.assertRowsOrdered(sql, Arrays.asList(new SqlTestSupport.Row("InsertPhysicalRel(table=[[hazelcast, public, map[projects=[$0, $1]]]], operation=[INSERT], flattened=[false])"), new SqlTestSupport.Row("  ValuesPhysicalRel(values=[{expressions=[[ConstantExpression{type=INT, value=3}, ConstantExpression{type=INT, value=3}], [ConstantExpression{type=INT, value=4}, ConstantExpression{type=INT, value=4}]]}])")));
    }

    @Test
    public void test_explainStatementSink() {
        IMap map = ExplainStatementTest.instance().getMap("map");
        map.put((Object)1, (Object)1);
        ExplainStatementTest.createMapping("map", Integer.class, Integer.class);
        String sql = "EXPLAIN PLAN FOR SINK INTO map(__key, this) VALUES (2, 2)";
        ExplainStatementTest.assertRowsOrdered(sql, Collections.singletonList(new SqlTestSupport.Row("SinkMapPhysicalRel(table=[[hazelcast, public, map[projects=[$0, $1]]]], values=[[{expressions=[[ConstantExpression{type=INT, value=2}, ConstantExpression{type=INT, value=2}]]}]])")));
    }

    @Test
    public void test_explainStatementUpdate() {
        IMap map = ExplainStatementTest.instance().getMap("map");
        map.put((Object)1, (Object)1);
        map.put((Object)2, (Object)10);
        ExplainStatementTest.createMapping("map", Integer.class, Integer.class);
        String sql = "EXPLAIN PLAN FOR UPDATE map SET this = 2 WHERE __key = 1";
        ExplainStatementTest.assertRowsOrdered(sql, Collections.singletonList(new SqlTestSupport.Row("UpdateByKeyMapPhysicalRel(table=[[hazelcast, public, map[projects=[$0, $1, 2], filter==($0, 1)]]], keyCondition=[1], updatedColumns=[[this]], sourceExpressions=[[2]])")));
        sql = "EXPLAIN PLAN FOR UPDATE map SET this = 2 WHERE __key = 1 AND __key = 2";
        ExplainStatementTest.assertRowsOrdered(sql, Arrays.asList(new SqlTestSupport.Row("UpdatePhysicalRel(table=[[hazelcast, public, map[projects=[$0, $1]]]], updateColumnList=[[this]], sourceExpressionList=[[2]], flattened=[false])"), new SqlTestSupport.Row("  ValuesPhysicalRel(values=[{expressions=[]}])")));
    }

    @Test
    public void test_explainStatementDelete() {
        IMap map = ExplainStatementTest.instance().getMap("map");
        map.put((Object)1, (Object)1);
        map.put((Object)2, (Object)2);
        map.put((Object)3, (Object)3);
        ExplainStatementTest.createMapping("map", Integer.class, Integer.class);
        String sql = "EXPLAIN PLAN FOR DELETE FROM map WHERE __key = 1";
        ExplainStatementTest.assertRowsOrdered(sql, Collections.singletonList(new SqlTestSupport.Row("DeleteByKeyMapPhysicalRel(table=[[hazelcast, public, map[projects=[$0], filter==($0, 1)]]], keyCondition=[1])")));
        sql = "EXPLAIN PLAN FOR DELETE FROM map";
        ExplainStatementTest.assertRowsOrdered(sql, Arrays.asList(new SqlTestSupport.Row("DeletePhysicalRel(table=[[hazelcast, public, map[projects=[$0, $1]]]], flattened=[false])"), new SqlTestSupport.Row("  FullScanPhysicalRel(table=[[hazelcast, public, map[projects=[$0]]]], discriminator=[0])")));
        sql = "EXPLAIN PLAN FOR DELETE FROM map WHERE __key > 1";
        ExplainStatementTest.assertRowsOrdered(sql, Arrays.asList(new SqlTestSupport.Row("DeletePhysicalRel(table=[[hazelcast, public, map[projects=[$0, $1]]]], flattened=[false])"), new SqlTestSupport.Row("  FullScanPhysicalRel(table=[[hazelcast, public, map[projects=[$0], filter=>($0, 1)]]], discriminator=[0])")));
    }

    @Test
    public void test_explainStatementShowShouldThrowParserEx() {
        IMap map = ExplainStatementTest.instance().getMap("map");
        map.put((Object)1, (Object)10);
        String sql = "EXPLAIN SHOW MAPPINGS";
        Assertions.assertThatThrownBy(() -> ExplainStatementTest.instance().getSql().execute(sql, new Object[0])).hasMessageContaining("Incorrect syntax near the keyword 'SHOW'");
    }

    @Test
    public void test_partitioningKeyInfoWithSimpleKey() {
        ExplainStatementTest.createMapping("test", Long.class, String.class);
        ExplainStatementTest.assertRowsOrdered("EXPLAIN PLAN FOR SELECT this FROM test WHERE this = '1'", ExplainStatementTest.rows(1, "FullScanPhysicalRel(table=[[hazelcast, public, test[projects=[$1], filter==($1, _UTF-16LE'1')]]], discriminator=[0])"));
        ExplainStatementTest.assertRowsOrdered("EXPLAIN PLAN FOR SELECT this FROM test WHERE __key = 1 AND this = '1'", ExplainStatementTest.rows(1, "FullScanPhysicalRel(table=[[hazelcast, public, test[projects=[$1], filter=AND(=($0, 1), =($1, _UTF-16LE'1'))]]], discriminator=[0], partitioningKey=[$0], partitioningKeyValues=[(1:BIGINT(63))])"));
    }

    @Test
    public void test_partitioningKeyInfoWithComplexKey() {
        ExplainStatementTest.instance().getConfig().addMapConfig(new MapConfig("testMap").setPartitioningAttributeConfigs(Arrays.asList(new PartitioningAttributeConfig("comp1"), new PartitioningAttributeConfig("comp2"))));
        ExplainStatementTest.instance().getSql().execute("CREATE MAPPING test EXTERNAL NAME \"testMap\" (c1 BIGINT EXTERNAL NAME \"__key.comp3\",c2 BIGINT EXTERNAL NAME \"__key.comp2\",c3 BIGINT EXTERNAL NAME \"__key.comp1\",this VARCHAR) TYPE IMap OPTIONS ('valueFormat'='varchar', 'keyFormat'='java', 'keyJavaClass'='" + KeyObj.class.getName() + "')", new Object[0]);
        ExplainStatementTest.assertRowsOrdered("EXPLAIN PLAN FOR SELECT this FROM test WHERE c1 = ? AND c2 = ?", ExplainStatementTest.rows(1, "FullScanPhysicalRel(table=[[hazelcast, public, test[projects=[$4], filter=AND(=($0, ?0), =($1, ?1))]]], discriminator=[0])"));
        ExplainStatementTest.assertRowsOrdered("EXPLAIN PLAN FOR SELECT this FROM test WHERE c3 = 1 AND c2 = ?", ExplainStatementTest.rows(1, "FullScanPhysicalRel(table=[[hazelcast, public, test[projects=[$4], filter=AND(=($2, 1), =($1, ?0))]]], discriminator=[0], partitioningKey=[$1, $2], partitioningKeyValues=[(?0, 1:BIGINT(63))])"));
    }

    @Test
    public void test_scanPruningWithoutMemberPruningSimpleQuery() {
        ExplainStatementTest.instance().getConfig().addMapConfig(new MapConfig("testMap").setPartitioningAttributeConfigs(Arrays.asList(new PartitioningAttributeConfig("comp1"), new PartitioningAttributeConfig("comp2"))));
        ExplainStatementTest.instance().getSql().execute("CREATE MAPPING test EXTERNAL NAME \"testMap\" (c1 BIGINT EXTERNAL NAME \"__key.comp3\",c2 BIGINT EXTERNAL NAME \"__key.comp2\",c3 BIGINT EXTERNAL NAME \"__key.comp1\",this VARCHAR) TYPE IMap OPTIONS ('valueFormat'='varchar', 'keyFormat'='java', 'keyJavaClass'='" + KeyObj.class.getName() + "')", new Object[0]);
        ExplainStatementTest.assertRowsAnyOrder("EXPLAIN PLAN FOR SELECT this FROM test WHERE c3 = 1 AND c2 = ? UNION ALL SELECT this FROM test", ExplainStatementTest.rows(1, "UnionPhysicalRel(all=[true])", "  FullScanPhysicalRel(table=[[hazelcast, public, test[projects=[$4], filter=AND(=($2, 1), =($1, ?0))]]], discriminator=[0], partitioningKey=[$1, $2], partitioningKeyValues=[(?0, 1:BIGINT(63))])", "  FullScanPhysicalRel(table=[[hazelcast, public, test[projects=[$4]]]], discriminator=[0])"));
    }

    @Test
    public void test_scanPruningWithoutMemberPruning() {
        ExplainStatementTest.instance().getConfig().addMapConfig(new MapConfig("testMap").setPartitioningAttributeConfigs(Arrays.asList(new PartitioningAttributeConfig("comp1"), new PartitioningAttributeConfig("comp2"))));
        ExplainStatementTest.instance().getSql().execute("CREATE MAPPING test EXTERNAL NAME \"testMap\" (c1 BIGINT EXTERNAL NAME \"__key.comp1\",c2 BIGINT EXTERNAL NAME \"__key.comp2\",c3 BIGINT EXTERNAL NAME \"__key.comp3\",this VARCHAR) TYPE IMap OPTIONS ('valueFormat'='varchar', 'keyFormat'='java', 'keyJavaClass'='" + KeyObj.class.getName() + "')", new Object[0]);
        List plan = ExplainStatementTest.allRows("EXPLAIN SELECT max(b.this), b.c2 FROM test a join test b on a.c1 = b.c2 WHERE a.c1 = 1 AND a.c2 = ? and b.c1 = 1 AND b.c2 = ? GROUP BY b.c2 ORDER BY b.c2", ExplainStatementTest.instance().getSql()).stream().map(row -> ((String)row.getValues()[0]).trim()).collect(Collectors.toUnmodifiableList());
        ((ListAssert)Assertions.assertThat(plan).as("At least one of the IMap scans should be pruned", new Object[0])).anySatisfy(row -> ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)row).startsWith((CharSequence)"FullScanPhysicalRel(table=[[hazelcast, public, test[")).contains(new CharSequence[]{"partitioningKey=[$0, $1]"})).contains(new CharSequence[]{"partitioningKeyValues=["}));
    }

    public static class KeyObj
    implements Serializable {
        public Long comp1;
        public Long comp2;
        public Long comp3;
    }
}

