/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.config.Config;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.core.JobAssertions;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.test.TestBatchSqlConnector;
import com.hazelcast.jet.sql.impl.connector.test.TestStreamSqlConnector;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlMemoryManagementTest
extends SqlTestSupport {
    private static final int MAX_PROCESSOR_ACCUMULATED_RECORDS = 2;
    private static SqlService sqlService;

    @BeforeClass
    public static void setUpClass() {
        Config config = SqlMemoryManagementTest.smallInstanceConfig();
        config.getJetConfig().setCooperativeThreadCount(1).setMaxProcessorAccumulatedRecords(2L);
        SqlMemoryManagementTest.initialize((int)2, (Config)config);
        sqlService = SqlMemoryManagementTest.instance().getSql();
    }

    /*
     * Exception decompiling
     */
    @Test
    public void test_changeJobConfig_singleStatement() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Test
    public void test_changeJobConfig_separateStatements() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void test_changeJobConfig(Function<String, String[]> statementsFn) {
        String mapName = SqlMemoryManagementTest.randomName();
        SqlMemoryManagementTest.createMapping(mapName, String.class, Integer.class);
        String jobName = SqlMemoryManagementTest.randomName();
        String sql = "CREATE JOB " + jobName + " OPTIONS ('suspendOnFailure'='true') AS SINK INTO " + mapName + " SELECT window_start || '-' || (v % 10) AS key, 42 FROM TABLE(TUMBLE((SELECT * FROM TABLE(IMPOSE_ORDER((SELECT v FROM TABLE(generate_stream(10))), DESCRIPTOR(v), 0))),DESCRIPTOR(v), 10))GROUP BY window_start, v % 10";
        System.out.println(sql);
        sqlService.execute(sql, new Object[0]);
        Job job = SqlMemoryManagementTest.instance().getJet().getJob(jobName);
        JobAssertions.assertThat((Job)job).eventuallySuspended();
        Assertions.assertThat((String)job.getSuspensionCause().errorCause()).contains(new CharSequence[]{"Exception thrown to prevent an OutOfMemoryError on this Hazelcast instance"});
        for (String statement : statementsFn.apply(jobName)) {
            sqlService.execute(statement, new Object[0]);
        }
        SqlMemoryManagementTest.assertTrueEventually(() -> Assert.assertTrue((SqlMemoryManagementTest.instance().getMap(mapName).size() >= 10 ? 1 : 0) != 0));
    }

    @Test
    public void when_maxAccumulatedRecordsCountIsExceededWhileInserting_then_throws() {
        String name = SqlMemoryManagementTest.randomName();
        SqlMemoryManagementTest.createMapping(name, Integer.class, String.class);
        Assertions.assertThatThrownBy(() -> sqlService.execute("INSERT INTO " + name + " VALUES (0, '0'), (1, '1'), (2, '2')", new Object[0])).hasMessageContaining("Exception thrown to prevent an OutOfMemoryError on this Hazelcast instance");
    }

    @Test
    public void when_maxAccumulatedRecordsCountIsExceededWhileGrouping_then_throws() {
        String name = SqlMemoryManagementTest.randomName();
        TestBatchSqlConnector.create(sqlService, name, Collections.singletonList("name"), Collections.singletonList(QueryDataTypeFamily.VARCHAR), Arrays.asList({"Alice"}, {"Bob"}, {"Joe"}));
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM " + name + " GROUP BY name", new Object[0]).iterator().next()).hasMessageContaining("Exception thrown to prevent an OutOfMemoryError on this Hazelcast instance");
    }

    @Test
    public void when_maxAccumulatedRecordsCountIsExceededWhileSorting_then_throws() {
        String name = SqlMemoryManagementTest.randomName();
        TestBatchSqlConnector.create(sqlService, name, Collections.singletonList("name"), Collections.singletonList(QueryDataTypeFamily.VARCHAR), Arrays.asList({"Alice"}, {"Bob"}, {"Joe"}));
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM " + name + " ORDER BY name", new Object[0]).iterator().next()).hasMessageContaining("Exception thrown to prevent an OutOfMemoryError on this Hazelcast instance");
    }

    @Test
    public void when_maxAccumulatedRecordsCountIsExceededWhileS2SJoin_throws() {
        this.when_maxAccumulatedRecordsCountIsExceededWhileS2SJoin_then_throws(SqlMemoryManagementTest.rows(new Object[][]{SqlMemoryManagementTest.row(1L)}), SqlMemoryManagementTest.rows(SqlMemoryManagementTest.row(1L), SqlMemoryManagementTest.row(1L)));
    }

    @Test
    public void when_maxAccumulatedRecordsCountIsExceededOnFirstEdgeWhileS2SJoin_throws() {
        this.when_maxAccumulatedRecordsCountIsExceededWhileS2SJoin_then_throws(SqlMemoryManagementTest.rows(SqlMemoryManagementTest.row(1L), SqlMemoryManagementTest.row(1L), SqlMemoryManagementTest.row(1L)), SqlMemoryManagementTest.rows(new Object[0][]));
    }

    @Test
    public void when_maxAccumulatedRecordsCountIsExceededOnSecondEdgeWhileS2SJoin_throws() {
        this.when_maxAccumulatedRecordsCountIsExceededWhileS2SJoin_then_throws(SqlMemoryManagementTest.rows(new Object[0][]), SqlMemoryManagementTest.rows(SqlMemoryManagementTest.row(1L), SqlMemoryManagementTest.row(1L), SqlMemoryManagementTest.row(1L)));
    }

    private void when_maxAccumulatedRecordsCountIsExceededWhileS2SJoin_then_throws(Object[][] rows1, Object[][] rows2) {
        String left = SqlMemoryManagementTest.randomName();
        String right = SqlMemoryManagementTest.randomName();
        TestStreamSqlConnector.create(sqlService, left, Collections.singletonList("ts"), Collections.singletonList(QueryDataTypeFamily.BIGINT), rows1);
        TestStreamSqlConnector.create(sqlService, right, Collections.singletonList("ts"), Collections.singletonList(QueryDataTypeFamily.BIGINT), rows2);
        sqlService.execute("CREATE VIEW s1 AS SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + left + " , DESCRIPTOR(ts), 10))", new Object[0]);
        sqlService.execute("CREATE VIEW s2 AS SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + right + ", DESCRIPTOR(ts), 10))", new Object[0]);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM s1 JOIN s2 ON s2.ts = s1.ts", new Object[0]).stream().limit(2L).collect(Collectors.toList())).hasMessageContaining("Exception thrown to prevent an OutOfMemoryError on this Hazelcast instance");
    }
}

