/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.RoutingMode;
import com.hazelcast.client.impl.connection.ClientConnection;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.SqlExecute_reservedCodec;
import com.hazelcast.client.util.ConfigRoutingUtil;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.sql.SqlErrorAbstractTest;
import com.hazelcast.map.IMap;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.sql.impl.client.SqlClientService;
import com.hazelcast.sql.impl.state.QueryClientStateRegistry;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Supplier;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlErrorClientTest
extends SqlErrorAbstractTest {
    @Parameterized.Parameter
    public RoutingMode routingMode;
    protected HazelcastInstance client;

    @Parameterized.Parameters(name="{index}: routingMode={0}")
    public static Iterable<?> parameters() {
        return Arrays.asList(RoutingMode.SINGLE_MEMBER, RoutingMode.ALL_MEMBERS);
    }

    @Override
    public void after() {
        this.client = null;
        super.after();
    }

    protected Supplier<HazelcastInstance> newClientSupplier() {
        return () -> this.factory.newHazelcastClient(this.newClientConfig());
    }

    protected ClientConfig newClientConfig() {
        ClientConfig clientConfig = ConfigRoutingUtil.newClientConfig((RoutingMode)this.routingMode);
        clientConfig.getConnectionStrategyConfig().getConnectionRetryConfig().setClusterConnectTimeoutMillis(Long.MAX_VALUE);
        return clientConfig;
    }

    @Test
    public void testTimeout_execute() {
        this.checkTimeout(this.newClientSupplier());
    }

    @Test
    public void testDataTypeMismatch() {
        this.checkDataTypeMismatch(this.newClientSupplier());
    }

    @Test
    public void testClientConnectedToLiteMember() {
        this.factory.newHazelcastInstance(this.getConfig().setLiteMember(true));
        this.client = this.factory.newHazelcastClient(null);
        HazelcastSqlException error = SqlErrorClientTest.assertSqlException(this.client, SqlErrorClientTest.query());
        SqlErrorClientTest.assertErrorCode(-1, error);
        Assert.assertEquals((Object)"SQL queries cannot be executed on lite members", (Object)error.getMessage());
    }

    @Test
    public void testParsingError() {
        this.checkParsingError(this.newClientSupplier());
    }

    @Test
    public void testUserCancel() {
        this.checkUserCancel(this.newClientSupplier());
    }

    @Test
    public void testMemberDisconnect_execute() {
        this.instance1 = this.newHazelcastInstance(true);
        this.client = this.newClientSupplier().get();
        SqlStatement streamingQuery = new SqlStatement("SELECT * FROM TABLE(GENERATE_STREAM(5000))");
        HazelcastSqlException error = SqlErrorClientTest.assertSqlExceptionWithShutdown(this.client, streamingQuery);
        SqlErrorClientTest.assertErrorCode(1001, error);
    }

    @Test
    public void testMemberDisconnect_fetch() {
        this.instance1 = this.newHazelcastInstance(true);
        this.client = this.newClientSupplier().get();
        SqlErrorClientTest.createMapping(this.instance1, "map", Long.TYPE, Long.TYPE);
        SqlErrorClientTest.populate(this.instance1, 4097);
        boolean shutdown = true;
        try {
            for (SqlRow ignore : this.client.getSql().execute(SqlErrorClientTest.query())) {
                if (!shutdown) continue;
                this.instance1.shutdown();
                shutdown = false;
            }
            Assert.fail((String)"Should fail");
        }
        catch (HazelcastSqlException e) {
            SqlErrorClientTest.assertErrorCode(1001, e);
        }
    }

    @Test
    public void testMemberDisconnect_close() {
        this.instance1 = this.newHazelcastInstance(true);
        this.client = this.newClientSupplier().get();
        SqlErrorClientTest.createMapping(this.instance1, "map", Long.TYPE, Long.TYPE);
        SqlErrorClientTest.populate(this.instance1, 4097);
        try {
            SqlResult result = this.client.getSql().execute(SqlErrorClientTest.query());
            this.instance1.shutdown();
            for (SqlRow sqlRow : result) {
            }
            result.close();
            Assert.fail((String)"Should fail");
        }
        catch (HazelcastSqlException e) {
            SqlErrorClientTest.assertErrorCode(1001, e);
        }
    }

    @Test
    public void testCursorCleanupOnClientLeave() {
        this.instance1 = this.newHazelcastInstance(true);
        this.client = this.newClientSupplier().get();
        HashMap<Integer, Integer> localMap = new HashMap<Integer, Integer>();
        IMap map = this.instance1.getMap("map");
        for (int i = 0; i < 4097; ++i) {
            localMap.put(i, i);
        }
        SqlErrorClientTest.createMapping(this.instance1, "map", Integer.TYPE, Integer.TYPE);
        map.putAll(localMap);
        QueryClientStateRegistry cursorRegistry = SqlErrorClientTest.sqlInternalService(this.instance1).getClientStateRegistry();
        this.client.getSql().execute("SELECT * FROM map", new Object[0]);
        SqlErrorClientTest.assertTrueEventually(() -> Assert.assertEquals((long)1L, (long)cursorRegistry.getCursorCount()));
        this.client.shutdown();
        SqlErrorClientTest.assertTrueEventually(() -> Assert.assertEquals((long)0L, (long)cursorRegistry.getCursorCount()));
    }

    @Test
    public void testParameterError_serialization() {
        this.instance1 = this.newHazelcastInstance(true);
        this.client = this.newClientSupplier().get();
        SqlStatement query = new SqlStatement("SELECT * FROM map").addParameter((Object)new BadParameter(true, false));
        HazelcastSqlException error = SqlErrorClientTest.assertSqlException(this.client, query);
        SqlErrorClientTest.assertErrorCode(-1, error);
        Assert.assertTrue((boolean)error.getMessage().contains("Failed to serialize query parameter"));
    }

    @Test
    public void testParameterError_deserialization() {
        this.instance1 = this.newHazelcastInstance(true);
        this.client = this.newClientSupplier().get();
        SqlStatement query = new SqlStatement("SELECT * FROM map").addParameter((Object)new BadParameter(false, true));
        HazelcastSqlException error = SqlErrorClientTest.assertSqlException(this.client, query);
        SqlErrorClientTest.assertErrorCode(-1, error);
        Assert.assertTrue((boolean)error.getMessage().contains("Read error"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowError_deserialization() {
        try {
            this.instance1 = this.newHazelcastInstance(true);
            this.client = this.newClientSupplier().get();
            HashMap<Integer, BadValue> localMap = new HashMap<Integer, BadValue>();
            IMap map = this.instance1.getMap("map");
            SqlErrorClientTest.createMapping(this.instance1, "map", Integer.TYPE, BadValue.class);
            for (int i = 0; i < 4097; ++i) {
                localMap.put(i, new BadValue());
            }
            map.putAll(localMap);
            try (SqlResult result = this.client.getSql().execute("SELECT __key, this FROM map", new Object[0]);){
                Iterator iterator = result.iterator();
                SqlRow firstRow = (SqlRow)iterator.next();
                firstRow.getObject("__key");
                firstRow.getObject("this");
                BadValue.READ_ERROR.set(true);
                SqlRow secondRow = (SqlRow)iterator.next();
                secondRow.getObject("__key");
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> secondRow.getObject("this")).isInstanceOf(HazelcastSerializationException.class)).hasMessageContaining("Failed to deserialize query result value");
            }
        }
        finally {
            BadValue.READ_ERROR.set(false);
        }
    }

    @Test
    public void testMissingHandler() {
        this.instance1 = this.newHazelcastInstance(true);
        this.client = this.newClientSupplier().get();
        try {
            ClientMessage message = SqlExecute_reservedCodec.encodeRequest((String)"SELECT * FROM table", Collections.emptyList(), (long)100L, (int)100);
            SqlClientService clientService = (SqlClientService)this.client.getSql();
            ClientConnection connection = clientService.getQueryConnection();
            clientService.invokeOnConnection(connection, message);
            Assert.fail((String)"Must fail");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Unrecognized client message received"));
        }
    }

    private static class BadParameter
    implements DataSerializable {
        private boolean writeError;
        private boolean readError;

        public BadParameter() {
        }

        private BadParameter(boolean writeError, boolean readError) {
            this.writeError = writeError;
            this.readError = readError;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            if (this.writeError) {
                throw new IOException("Write error");
            }
            out.writeBoolean(this.readError);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.readError = in.readBoolean();
            if (this.readError) {
                throw new IOException("Read error");
            }
        }
    }

    private static class BadValue
    implements DataSerializable {
        private static final ThreadLocal<Boolean> READ_ERROR = ThreadLocal.withInitial(() -> false);

        private BadValue() {
        }

        public void writeData(ObjectDataOutput out) {
        }

        public void readData(ObjectDataInput in) throws IOException {
            if (READ_ERROR.get().booleanValue()) {
                throw new IOException("Read error");
            }
        }
    }
}

