/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.twod.hull;

import java.util.Collection;

import com.hazelcast.shaded.org.apache.commons.math3.exception.ConvergenceException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NullArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.hull.ConvexHullGenerator;

/**
 * Interface for convex hull generators in the two-dimensional euclidean space.
 *
 * @since 3.3
 */
public interface ConvexHullGenerator2D extends ConvexHullGenerator<Euclidean2D, Vector2D> {

    /** {@inheritDoc} */
    ConvexHull2D generate(Collection<Vector2D> points) throws NullArgumentException, ConvergenceException;

}
