/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.hazelcast.shaded.org.apache.calcite.tools;

import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptSchema;
import com.hazelcast.shaded.org.apache.calcite.rel.core.RelFactories;

import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;

/** A partially-created RelBuilder.
 *
 * <p>Add a cluster, and optionally a schema,
 * when you want to create a builder.
 *
 * <p>A {@code ProtoRelBuilder} can be shared among queries, and thus can
 * be inside a {@link RelOptRule}. It is a nice way to encapsulate the policy
 * that this particular rule instance should create {@code DrillFilter}
 * and {@code DrillProject} versus {@code HiveFilter} and {@code HiveProject}.
 *
 * @see RelFactories#LOGICAL_BUILDER
 */
public interface RelBuilderFactory {
  /** Creates a RelBuilder. */
  RelBuilder create(RelOptCluster cluster, @Nullable RelOptSchema schema);
}
