/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.operators.math;

import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.operand.TypedOperandChecker;
import com.hazelcast.sql.impl.calcite.validate.operators.ReplaceUnknownOperandTypeInference;
import com.hazelcast.sql.impl.calcite.validate.operators.common.HazelcastFunction;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastIntegerType;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlTypeName;

public final class HazelcastAbsFunction
extends HazelcastFunction {
    public static final HazelcastAbsFunction INSTANCE = new HazelcastAbsFunction();

    private HazelcastAbsFunction() {
        super("ABS", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0, new ReplaceUnknownOperandTypeInference(SqlTypeName.BIGINT), SqlFunctionCategory.NUMERIC);
    }

    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of((int)1);
    }

    @Override
    public boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
        TypedOperandChecker checker;
        Object operandType = binding.getOperandType(0);
        if (HazelcastTypeUtils.isNumericIntegerType(operandType)) {
            int bitWidth = ((HazelcastIntegerType)((Object)operandType)).getBitWidth();
            operandType = HazelcastIntegerType.create(bitWidth + 1, operandType.isNullable());
        }
        if ((checker = TypedOperandChecker.forType(operandType)).isNumeric()) {
            return checker.check(binding, throwOnFailure, 0);
        }
        if (throwOnFailure) {
            throw binding.newValidationSignatureError();
        }
        return false;
    }
}

