/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.operators.common;

import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlValidator;
import java.util.Arrays;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;

interface HazelcastOperandTypeCheckerAware {
    default public HazelcastCallBinding prepareBinding(SqlCallBinding binding) {
        SqlOperator operator = binding.getOperator();
        if (!1.$assertionsDisabled && operator != this) {
            throw new AssertionError();
        }
        SqlOperandTypeInference operandTypeInference = operator.getOperandTypeInference();
        HazelcastSqlValidator validator = (HazelcastSqlValidator)binding.getValidator();
        boolean resolveOperands = false;
        for (int i = 0; i < binding.getOperandCount(); ++i) {
            RelDataType operandType = binding.getOperandType(i);
            if (operandType.getSqlTypeName() != SqlTypeName.NULL) continue;
            resolveOperands = true;
            break;
        }
        if (resolveOperands) {
            RelDataType unknownType = binding.getValidator().getUnknownType();
            Object[] operandTypes = new RelDataType[binding.getOperandCount()];
            Arrays.fill(operandTypes, unknownType);
            operandTypeInference.inferOperandTypes(binding, binding.getValidator().getUnknownType(), (RelDataType[])operandTypes);
            for (int i = 0; i < binding.getOperandCount(); ++i) {
                validator.setValidatedNodeType(binding.operand(i), (RelDataType)operandTypes[i]);
            }
        }
        return new HazelcastCallBinding(binding);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

