/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.opt.logical;

import com.hazelcast.sql.impl.calcite.opt.OptUtils;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;

public final class FilterIntoScanLogicalRule
extends RelOptRule {
    public static final FilterIntoScanLogicalRule INSTANCE = new FilterIntoScanLogicalRule();

    private FilterIntoScanLogicalRule() {
        super(FilterIntoScanLogicalRule.operand(LogicalFilter.class, (RelOptRuleOperand)FilterIntoScanLogicalRule.operandJ(LogicalTableScan.class, null, OptUtils::isHazelcastTable, (RelOptRuleOperandChildren)FilterIntoScanLogicalRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, FilterIntoScanLogicalRule.class.getSimpleName());
    }

    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        TableScan scan = (TableScan)call.rel(1);
        HazelcastTable originalTable = OptUtils.getHazelcastTable(scan);
        RexNode newCondition = FilterIntoScanLogicalRule.remapCondition(originalTable, filter.getCondition());
        RexNode originalCondition = originalTable.getFilter();
        if (originalCondition != null) {
            ArrayList<RexNode> nodes = new ArrayList<RexNode>(2);
            nodes.add(originalCondition);
            nodes.add(newCondition);
            newCondition = RexUtil.composeConjunction((RexBuilder)scan.getCluster().getRexBuilder(), nodes, (boolean)true);
        }
        LogicalTableScan newScan = OptUtils.createLogicalScanWithNewTable(scan, originalTable.withFilter(newCondition));
        call.transformTo((RelNode)newScan);
    }

    private static RexNode remapCondition(HazelcastTable originalHazelcastTable, RexNode originalFilterCondition) {
        List<Integer> projects = originalHazelcastTable.getProjects();
        Mapping mapping = Mappings.source(projects, (int)originalHazelcastTable.getOriginalFieldCount());
        return RexUtil.apply((Mappings.TargetMapping)mapping, (RexNode)originalFilterCondition);
    }
}

