/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.operators.string;

import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.operand.OperandCheckerProgram;
import com.hazelcast.sql.impl.calcite.validate.operand.TypedOperandChecker;
import com.hazelcast.sql.impl.calcite.validate.operators.ReplaceUnknownOperandTypeInference;
import com.hazelcast.sql.impl.calcite.validate.operators.common.HazelcastSpecialOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlLikeOperator;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlTypeName;

public final class HazelcastLikeOperator
extends HazelcastSpecialOperator {
    public static final HazelcastLikeOperator LIKE = new HazelcastLikeOperator("LIKE", false);
    public static final HazelcastLikeOperator NOT_LIKE = new HazelcastLikeOperator("NOT LIKE", true);
    private static final int PRECEDENCE = 32;
    private final boolean negated;

    private HazelcastLikeOperator(String name, boolean negated) {
        super(name, SqlKind.LIKE, 32, false, ReturnTypes.BOOLEAN_NULLABLE, new ReplaceUnknownOperandTypeInference(SqlTypeName.VARCHAR));
        this.negated = negated;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.between((int)2, (int)3);
    }

    @Override
    public boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
        if (binding.getOperandCount() == 2) {
            return new OperandCheckerProgram(TypedOperandChecker.VARCHAR, TypedOperandChecker.VARCHAR).check(binding, throwOnFailure);
        }
        assert (binding.getOperandCount() == 3);
        return new OperandCheckerProgram(TypedOperandChecker.VARCHAR, TypedOperandChecker.VARCHAR, TypedOperandChecker.VARCHAR).check(binding, throwOnFailure);
    }

    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList("", "");
        call.operand(0).unparse(writer, this.getLeftPrec(), this.getRightPrec());
        writer.sep(this.getName());
        call.operand(1).unparse(writer, this.getLeftPrec(), this.getRightPrec());
        if (call.operandCount() == 3) {
            writer.sep("ESCAPE");
            call.operand(2).unparse(writer, this.getLeftPrec(), this.getRightPrec());
        }
        writer.endList(frame);
    }

    public SqlSpecialOperator.ReduceResult reduceExpr(int opOrdinal, SqlSpecialOperator.TokenSequence list) {
        int end;
        SqlNode[] operands;
        SqlOperator op2;
        SqlNode exp0 = list.node(opOrdinal - 1);
        SqlOperator op = list.op(opOrdinal);
        assert (op instanceof SqlLikeOperator);
        SqlNode exp1 = SqlParserUtil.toTreeEx((SqlSpecialOperator.TokenSequence)list, (int)(opOrdinal + 1), (int)this.getRightPrec(), (SqlKind)SqlKind.ESCAPE);
        SqlNode exp2 = null;
        if (opOrdinal + 2 < list.size() && list.isOp(opOrdinal + 2) && (op2 = list.op(opOrdinal + 2)).getKind() == SqlKind.ESCAPE) {
            exp2 = SqlParserUtil.toTreeEx((SqlSpecialOperator.TokenSequence)list, (int)(opOrdinal + 3), (int)this.getRightPrec(), (SqlKind)SqlKind.ESCAPE);
        }
        if (exp2 != null) {
            operands = new SqlNode[]{exp0, exp1, exp2};
            end = opOrdinal + 4;
        } else {
            operands = new SqlNode[]{exp0, exp1};
            end = opOrdinal + 2;
        }
        SqlCall call = this.createCall(SqlParserPos.ZERO, operands);
        return new SqlSpecialOperator.ReduceResult((SqlSpecialOperator)this, opOrdinal - 1, end, (SqlNode)call);
    }
}

