/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spring.BeanExporter;
import com.hazelcast.spring.ExposeHazelcastObjects;
import com.hazelcast.spring.HazelcastExposeObjectRegistrar;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@AutoConfiguration
@AutoConfigureAfter(value={HazelcastAutoConfiguration.class, HazelcastExposeObjectRegistrar.class})
public class HazelcastObjectExtractionConfiguration {
    private static final ILogger LOGGER = Logger.getLogger(HazelcastObjectExtractionConfiguration.class);
    private static final Set<Class<?>> REGISTERED_CONFIG_CLASSES = ConcurrentHashMap.newKeySet();

    @Bean
    @Nonnull
    public static BeanDefinitionRegistryPostProcessor hzInternalBeanExposer(@Nonnull HazelcastInstance hazelcastInstance, ApplicationContext applicationContext) {
        ExposeHazelcastObjects.Configuration hzBeanExportConf = ExposeHazelcastObjects.Configuration.empty();
        if (applicationContext.containsBean("hzBeanExportConf")) {
            hzBeanExportConf = (ExposeHazelcastObjects.Configuration)applicationContext.getBean("hzBeanExportConf", ExposeHazelcastObjects.Configuration.class);
        }
        return new BeanExporter(hazelcastInstance, hzBeanExportConf);
    }

    @Nonnull
    public Set<Class<?>> registeredTypesOfBeans() {
        return Set.copyOf(REGISTERED_CONFIG_CLASSES);
    }

    record RegistrationChain(HazelcastInstance hazelcastInstance, BeanDefinitionRegistry registry, ExposeHazelcastObjects.Configuration configuration) {
        RegistrationChain register(Map<String, ?> conf, Class<?> clazz, BiFunction<HazelcastInstance, String, Object> supplierProvider) {
            for (Map.Entry<String, ?> entry : conf.entrySet()) {
                this.register(this.registry, entry.getKey(), clazz, supplierProvider);
            }
            REGISTERED_CONFIG_CLASSES.add(clazz);
            return this;
        }

        RegistrationChain register(BeanDefinitionRegistry registry, String name, Class<?> clazz, BiFunction<HazelcastInstance, String, Object> supplierProvider) {
            boolean containsBeanDefinition = registry.containsBeanDefinition(name);
            boolean canIncludeByName = this.configuration.canInclude(name);
            boolean canIncludeByType = this.configuration.canInclude(clazz);
            if (LOGGER.isFineEnabled()) {
                if (containsBeanDefinition) {
                    LOGGER.fine("Not registering bean %s of type %s, there is already bean with this name", (Object)name, (Object)clazz.getSimpleName());
                }
                if (!canIncludeByName) {
                    LOGGER.fine("Not registering bean %s of type %s, this name was excluded in the configuration", (Object)name, (Object)clazz.getSimpleName());
                }
                if (!canIncludeByType) {
                    LOGGER.fine("Not registering bean %s of type %s, this type of objects was excluded in the configuration", (Object)name, (Object)clazz.getSimpleName());
                }
            }
            if (!containsBeanDefinition && canIncludeByName && canIncludeByType) {
                Supplier<Object> supplier = () -> supplierProvider.apply(this.hazelcastInstance, name);
                RootBeanDefinition beanDefinition = new RootBeanDefinition();
                beanDefinition.setTargetType(clazz);
                beanDefinition.setInstanceSupplier(supplier);
                beanDefinition.setLazyInit(true);
                if (DistributedObject.class.isAssignableFrom(clazz)) {
                    beanDefinition.setDestroyMethodName("destroy");
                }
                registry.registerBeanDefinition(name, (BeanDefinition)beanDefinition);
            }
            REGISTERED_CONFIG_CLASSES.add(clazz);
            return this;
        }
    }
}

