/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.spring.HazelcastExposeObjectRegistrar;
import com.hazelcast.spring.HazelcastObjectExtractionConfiguration;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.type.AnnotationMetadata;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Import(value={HazelcastExposeObjectRegistrar.class, HazelcastObjectExtractionConfiguration.class})
public @interface ExposeHazelcastObjects {
    public String[] includeByName() default {};

    public String[] excludeByName() default {};

    public Class<?>[] includeByType() default {};

    public Class<?>[] excludeByType() default {};

    public record Configuration(Set<String> includeByName, Set<String> excludeByName, Set<Class<?>> includeByType, Set<Class<?>> excludeByType) {
        static Configuration toConfiguration(@Nonnull AnnotationMetadata importingClassMetadata) {
            MergedAnnotation metadata = importingClassMetadata.getAnnotations().get(ExposeHazelcastObjects.class);
            if (!metadata.isPresent()) {
                return Configuration.empty();
            }
            String[] includeByName = metadata.getValue("includeByName", String[].class).orElse(new String[0]);
            String[] excludeByName = metadata.getValue("excludeByName", String[].class).orElse(new String[0]);
            Class[] includeByType = metadata.getValue("includeByType", Class[].class).orElse(new Class[0]);
            Class[] excludeByType = metadata.getValue("excludeByType", Class[].class).orElse(new Class[0]);
            return new Configuration(Set.of(includeByName), Set.of(excludeByName), Set.of(includeByType), Set.of(excludeByType));
        }

        public static Configuration empty() {
            return new Configuration(new HashSet<String>(), new HashSet<String>(), new HashSet(), new HashSet());
        }

        boolean canInclude(String beanName) {
            return (this.includeByName.isEmpty() || this.includeByName.contains(beanName)) && !this.excludeByName.contains(beanName);
        }

        boolean canInclude(Class<?> beanClass) {
            boolean includedByType = this.includeByType.stream().anyMatch(beanClass::isAssignableFrom);
            boolean excludedByType = this.excludeByType.stream().anyMatch(beanClass::isAssignableFrom);
            return (this.includeByType.isEmpty() || includedByType) && !excludedByType;
        }

        void includeOther(Configuration other) {
            this.includeByName.addAll(other.includeByName());
            this.excludeByName.addAll(other.excludeByName());
            this.includeByType.addAll(other.includeByType());
            this.excludeByType.addAll(other.excludeByType());
        }
    }
}

