/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.string;

import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.VariExpression;
import com.hazelcast.sql.impl.expression.string.StringFunctionUtils;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.StringJoiner;

public class ConcatWSFunction
extends VariExpression<String>
implements IdentifiedDataSerializable {
    public ConcatWSFunction() {
    }

    private ConcatWSFunction(Expression<?> ... operands) {
        super(operands);
    }

    public static ConcatWSFunction create(Expression<?> ... operands) {
        return new ConcatWSFunction(operands);
    }

    @Override
    public String eval(Row row, ExpressionEvalContext context) {
        String separator = StringFunctionUtils.asVarchar(this.operands[0], row, context);
        if (separator == null) {
            return null;
        }
        StringJoiner joiner = new StringJoiner(separator);
        for (int i = 1; i < this.operands.length; ++i) {
            Object val = this.operands[i].eval(row, context);
            if (val == null) continue;
            joiner.add(this.operands[i].getType().getConverter().asVarchar(val));
        }
        return joiner.toString();
    }

    @Override
    public QueryDataType getType() {
        return QueryDataType.VARCHAR;
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 49;
    }
}

