/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.datetime;

import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.UniExpression;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.time.OffsetDateTime;

public final class ToEpochMillisFunction
extends UniExpression<Long>
implements IdentifiedDataSerializable {
    public ToEpochMillisFunction() {
    }

    private ToEpochMillisFunction(Expression<?> operand) {
        super(operand);
    }

    public static ToEpochMillisFunction create(Expression<?> operand) {
        return new ToEpochMillisFunction(operand);
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 56;
    }

    @Override
    public Long eval(Row row, ExpressionEvalContext context) {
        OffsetDateTime dateTime = (OffsetDateTime)this.operand.eval(row, context);
        if (dateTime == null) {
            return null;
        }
        return dateTime.toInstant().toEpochMilli();
    }

    @Override
    public QueryDataType getType() {
        return QueryDataType.BIGINT;
    }
}

