/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.locksupport.LockWaitNotifyKey;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.operation.EntryBackupOperation;
import com.hazelcast.map.impl.operation.EntryOffloadableLockMismatchException;
import com.hazelcast.map.impl.operation.EntryOperator;
import com.hazelcast.map.impl.operation.KeyBasedMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.spi.impl.operationservice.BackupAwareOperation;
import com.hazelcast.spi.impl.operationservice.Notifier;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.WaitNotifyKey;
import java.io.IOException;
import java.util.UUID;

public class EntryOffloadableSetUnlockOperation
extends KeyBasedMapOperation
implements BackupAwareOperation,
Notifier,
Versioned {
    protected boolean changeExpiryOnUpdate;
    protected long begin;
    protected long newTtl;
    protected UUID caller;
    protected Data newValue;
    protected Data oldValue;
    protected EntryEventType modificationType;
    protected EntryProcessor entryBackupProcessor;

    public EntryOffloadableSetUnlockOperation() {
    }

    public EntryOffloadableSetUnlockOperation(String name, EntryEventType modificationType, boolean changeExpiryOnUpdate, long newTtl, Data key, Data oldValue, Data newValue, UUID caller, long threadId, long begin, EntryProcessor entryBackupProcessor) {
        super(name, key, newValue);
        this.newValue = newValue;
        this.oldValue = oldValue;
        this.caller = caller;
        this.begin = begin;
        this.modificationType = modificationType;
        this.entryBackupProcessor = entryBackupProcessor;
        this.setThreadId(threadId);
        this.changeExpiryOnUpdate = changeExpiryOnUpdate;
        this.newTtl = newTtl;
    }

    @Override
    protected void runInternal() {
        this.recordStore.beforeOperation();
        try {
            this.verifyLock();
            try {
                EntryOperator.operator(this).init(this.dataKey, this.oldValue, this.newValue, null, this.modificationType, null, this.changeExpiryOnUpdate, this.newTtl).doPostOperateOps();
            }
            finally {
                this.unlockKey();
            }
        }
        finally {
            this.recordStore.afterOperation();
        }
    }

    private void verifyLock() {
        if (!this.recordStore.isLockedBy(this.dataKey, this.caller, this.threadId)) {
            throw new EntryOffloadableLockMismatchException(String.format("The key is not locked by the caller=%s and threadId=%d", this.caller, this.threadId));
        }
    }

    public void unlockKey() {
        boolean unlocked = this.recordStore.unlock(this.dataKey, this.caller, this.threadId, this.getCallId());
        if (!unlocked) {
            throw new IllegalStateException(String.format("Unexpected error! EntryOffloadableSetUnlockOperation finished but the unlock method returned false for caller=%s and threadId=%d", this.caller, this.threadId));
        }
    }

    @Override
    protected void innerBeforeRun() throws Exception {
    }

    @Override
    public void afterRunFinal() {
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Operation getBackupOperation() {
        return this.entryBackupProcessor != null ? new EntryBackupOperation(this.name, this.dataKey, this.entryBackupProcessor) : null;
    }

    @Override
    public boolean shouldBackup() {
        return this.mapContainer.getTotalBackupCount() > 0 && this.entryBackupProcessor != null;
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    @Override
    public boolean shouldNotify() {
        return true;
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        return new LockWaitNotifyKey(this.getServiceNamespace(), this.dataKey);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public int getClassId() {
        return 125;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeString(this.modificationType != null ? this.modificationType.name() : "");
        IOUtil.writeData(out, this.oldValue);
        IOUtil.writeData(out, this.newValue);
        UUIDSerializationUtil.writeUUID(out, this.caller);
        out.writeLong(this.begin);
        out.writeObject(this.entryBackupProcessor);
        out.writeLong(this.newTtl);
        if (out.getVersion().isGreaterOrEqual(Versions.V5_2)) {
            out.writeBoolean(this.changeExpiryOnUpdate);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        String modificationTypeName = in.readString();
        this.modificationType = modificationTypeName.equals("") ? null : EntryEventType.valueOf(modificationTypeName);
        this.oldValue = IOUtil.readData(in);
        this.newValue = IOUtil.readData(in);
        this.caller = UUIDSerializationUtil.readUUID(in);
        this.begin = in.readLong();
        this.entryBackupProcessor = (EntryProcessor)in.readObject();
        this.newTtl = in.readLong();
        if (in.getVersion().isGreaterOrEqual(Versions.V5_2)) {
            this.changeExpiryOnUpdate = in.readBoolean();
        }
    }
}

