/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jdbc;

import com.hazelcast.sql.SqlColumnType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

final class TypeUtil {
    private static final Map<SqlColumnType, String> SQL_TYPES_NAME_MAPPING = new HashMap<SqlColumnType, String>();
    private static final Map<SqlColumnType, Integer> SQL_TYPES_MAPPING = new HashMap<SqlColumnType, Integer>();
    private static final Map<SqlColumnType, SqlTypeInfo> SQL_TYPES_INFO = new HashMap<SqlColumnType, SqlTypeInfo>();
    private static final Map<String, SqlColumnType> QDT_NAMES_TO_SQL_TYPES_MAPPING = new HashMap<String, SqlColumnType>();
    private static final Set<SqlColumnType> NUMERIC_TYPES = new HashSet<SqlColumnType>();

    private TypeUtil() {
    }

    public static String getName(SqlColumnType columnType) {
        return SQL_TYPES_NAME_MAPPING.get((Object)columnType);
    }

    public static SqlColumnType getTypeByQDTName(String name) {
        return QDT_NAMES_TO_SQL_TYPES_MAPPING.getOrDefault(name, SqlColumnType.OBJECT);
    }

    public static SqlTypeInfo getTypeInfo(SqlColumnType columnType) {
        return SQL_TYPES_INFO.get((Object)columnType);
    }

    public static Integer getJdbcType(SqlColumnType columnType) {
        return SQL_TYPES_MAPPING.get((Object)columnType);
    }

    public static boolean isNumeric(SqlColumnType sqlColumnType) {
        return NUMERIC_TYPES.contains((Object)sqlColumnType);
    }

    static {
        SQL_TYPES_NAME_MAPPING.put(SqlColumnType.BIGINT, "BIGINT");
        SQL_TYPES_NAME_MAPPING.put(SqlColumnType.VARCHAR, "VARCHAR");
        SQL_TYPES_NAME_MAPPING.put(SqlColumnType.BOOLEAN, "BOOLEAN");
        SQL_TYPES_NAME_MAPPING.put(SqlColumnType.TINYINT, "TINYINT");
        SQL_TYPES_NAME_MAPPING.put(SqlColumnType.SMALLINT, "SMALLINT");
        SQL_TYPES_NAME_MAPPING.put(SqlColumnType.INTEGER, "INT");
        SQL_TYPES_NAME_MAPPING.put(SqlColumnType.DECIMAL, "DECIMAL");
        SQL_TYPES_NAME_MAPPING.put(SqlColumnType.REAL, "REAL");
        SQL_TYPES_NAME_MAPPING.put(SqlColumnType.DOUBLE, "DOUBLE");
        SQL_TYPES_NAME_MAPPING.put(SqlColumnType.TIME, "TIME");
        SQL_TYPES_NAME_MAPPING.put(SqlColumnType.DATE, "DATE");
        SQL_TYPES_NAME_MAPPING.put(SqlColumnType.TIMESTAMP, "TIMESTAMP");
        SQL_TYPES_NAME_MAPPING.put(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, "TIMESTAMP WITH TIME ZONE");
        SQL_TYPES_NAME_MAPPING.put(SqlColumnType.OBJECT, "OBJECT");
        SQL_TYPES_NAME_MAPPING.put(SqlColumnType.JSON, "JSON");
        SQL_TYPES_MAPPING.put(SqlColumnType.VARCHAR, 12);
        SQL_TYPES_MAPPING.put(SqlColumnType.BOOLEAN, 16);
        SQL_TYPES_MAPPING.put(SqlColumnType.TINYINT, -6);
        SQL_TYPES_MAPPING.put(SqlColumnType.SMALLINT, 5);
        SQL_TYPES_MAPPING.put(SqlColumnType.INTEGER, 4);
        SQL_TYPES_MAPPING.put(SqlColumnType.BIGINT, -5);
        SQL_TYPES_MAPPING.put(SqlColumnType.DECIMAL, 3);
        SQL_TYPES_MAPPING.put(SqlColumnType.REAL, 7);
        SQL_TYPES_MAPPING.put(SqlColumnType.DOUBLE, 8);
        SQL_TYPES_MAPPING.put(SqlColumnType.DATE, 91);
        SQL_TYPES_MAPPING.put(SqlColumnType.TIME, 92);
        SQL_TYPES_MAPPING.put(SqlColumnType.TIMESTAMP, 93);
        SQL_TYPES_MAPPING.put(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, 2014);
        SQL_TYPES_MAPPING.put(SqlColumnType.OBJECT, 2000);
        SQL_TYPES_MAPPING.put(SqlColumnType.NULL, 0);
        SQL_TYPES_MAPPING.put(SqlColumnType.JSON, 1111);
        SQL_TYPES_INFO.put(SqlColumnType.INTEGER, new SqlTypeInfo(11, 11, 0, true));
        SQL_TYPES_INFO.put(SqlColumnType.BIGINT, new SqlTypeInfo(20, 20, 0, true));
        SQL_TYPES_INFO.put(SqlColumnType.TINYINT, new SqlTypeInfo(4, 8, 0, true));
        SQL_TYPES_INFO.put(SqlColumnType.SMALLINT, new SqlTypeInfo(6, 16, 0, true));
        SQL_TYPES_INFO.put(SqlColumnType.REAL, new SqlTypeInfo(15, 24, 24, true));
        SQL_TYPES_INFO.put(SqlColumnType.DOUBLE, new SqlTypeInfo(24, 53, 53, true));
        SQL_TYPES_INFO.put(SqlColumnType.DECIMAL, new SqlTypeInfo(100000, 38, 38, true));
        SQL_TYPES_INFO.put(SqlColumnType.VARCHAR, new SqlTypeInfo(64, Integer.MAX_VALUE, 0, false));
        SQL_TYPES_INFO.put(SqlColumnType.BOOLEAN, new SqlTypeInfo(5, 1, 0, false));
        SQL_TYPES_INFO.put(SqlColumnType.NULL, new SqlTypeInfo(53, 1, 0, false));
        SQL_TYPES_INFO.put(SqlColumnType.OBJECT, new SqlTypeInfo(Integer.MAX_VALUE, Integer.MAX_VALUE, 0, false));
        SQL_TYPES_INFO.put(SqlColumnType.JSON, new SqlTypeInfo(Integer.MAX_VALUE, Integer.MAX_VALUE, 0, false));
        SQL_TYPES_INFO.put(SqlColumnType.DATE, new SqlTypeInfo(10, 10, 0, false));
        SQL_TYPES_INFO.put(SqlColumnType.TIME, new SqlTypeInfo(8, 8, 0, false));
        SQL_TYPES_INFO.put(SqlColumnType.TIMESTAMP, new SqlTypeInfo(25, 25, 0, false));
        SQL_TYPES_INFO.put(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, new SqlTypeInfo(25, 25, 0, false));
        QDT_NAMES_TO_SQL_TYPES_MAPPING.put("BIGINT", SqlColumnType.BIGINT);
        QDT_NAMES_TO_SQL_TYPES_MAPPING.put("VARCHAR", SqlColumnType.VARCHAR);
        QDT_NAMES_TO_SQL_TYPES_MAPPING.put("BOOLEAN", SqlColumnType.BOOLEAN);
        QDT_NAMES_TO_SQL_TYPES_MAPPING.put("TINYINT", SqlColumnType.TINYINT);
        QDT_NAMES_TO_SQL_TYPES_MAPPING.put("SMALLINT", SqlColumnType.SMALLINT);
        QDT_NAMES_TO_SQL_TYPES_MAPPING.put("INTEGER", SqlColumnType.INTEGER);
        QDT_NAMES_TO_SQL_TYPES_MAPPING.put("DECIMAL", SqlColumnType.DECIMAL);
        QDT_NAMES_TO_SQL_TYPES_MAPPING.put("REAL", SqlColumnType.REAL);
        QDT_NAMES_TO_SQL_TYPES_MAPPING.put("DOUBLE", SqlColumnType.DOUBLE);
        QDT_NAMES_TO_SQL_TYPES_MAPPING.put("TIME", SqlColumnType.TIME);
        QDT_NAMES_TO_SQL_TYPES_MAPPING.put("DATE", SqlColumnType.DATE);
        QDT_NAMES_TO_SQL_TYPES_MAPPING.put("TIMESTAMP", SqlColumnType.TIMESTAMP);
        QDT_NAMES_TO_SQL_TYPES_MAPPING.put("TIMESTAMP_WITH_TIME_ZONE", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE);
        QDT_NAMES_TO_SQL_TYPES_MAPPING.put("OBJECT", SqlColumnType.OBJECT);
        QDT_NAMES_TO_SQL_TYPES_MAPPING.put("JSON", SqlColumnType.JSON);
        NUMERIC_TYPES.add(SqlColumnType.TINYINT);
        NUMERIC_TYPES.add(SqlColumnType.SMALLINT);
        NUMERIC_TYPES.add(SqlColumnType.BIGINT);
        NUMERIC_TYPES.add(SqlColumnType.DECIMAL);
        NUMERIC_TYPES.add(SqlColumnType.REAL);
        NUMERIC_TYPES.add(SqlColumnType.DOUBLE);
    }

    public static final class SqlTypeInfo {
        private final Integer displaySize;
        private final Integer precision;
        private final Integer scale;
        private final Boolean signed;

        private SqlTypeInfo(Integer displaySize, Integer precision, Integer scale, Boolean signed) {
            this.displaySize = displaySize;
            this.precision = precision;
            this.scale = scale;
            this.signed = signed;
        }

        public Integer getDisplaySize() {
            return this.displaySize;
        }

        public Integer getPrecision() {
            return this.precision;
        }

        public Integer getScale() {
            return this.scale;
        }

        public Boolean isSigned() {
            return this.signed;
        }
    }
}

