/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jdbc;

import com.hazelcast.jdbc.JdbcUtils;
import com.hazelcast.jdbc.TypeUtil;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlRowMetadata;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class JdbcResultSetMetaData
implements ResultSetMetaData {
    private static final String NOT_APPLICABLE = "";
    private final SqlRowMetadata sqlRowMetadata;

    JdbcResultSetMetaData(SqlRowMetadata sqlRowMetadata) {
        this.sqlRowMetadata = sqlRowMetadata;
    }

    @Override
    public int getColumnCount() {
        return this.sqlRowMetadata.getColumnCount();
    }

    @Override
    public boolean isAutoIncrement(int column) {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) {
        return true;
    }

    @Override
    public boolean isSearchable(int column) {
        return true;
    }

    @Override
    public boolean isCurrency(int column) {
        return false;
    }

    @Override
    public int isNullable(int column) {
        return 1;
    }

    @Override
    public boolean isSigned(int column) {
        SqlColumnType type = this.getColumn(column).getType();
        return TypeUtil.getTypeInfo(type).isSigned();
    }

    @Override
    public int getColumnDisplaySize(int column) {
        return TypeUtil.getTypeInfo(this.getColumn(column).getType()).getDisplaySize();
    }

    @Override
    public String getColumnLabel(int column) {
        return this.getColumn(column).getName();
    }

    @Override
    public String getColumnName(int column) {
        return this.getColumn(column).getName();
    }

    @Override
    public String getSchemaName(int column) {
        return NOT_APPLICABLE;
    }

    @Override
    public int getPrecision(int column) {
        return TypeUtil.getTypeInfo(this.getColumn(column).getType()).getPrecision();
    }

    @Override
    public int getScale(int column) {
        return TypeUtil.getTypeInfo(this.getColumn(column).getType()).getScale();
    }

    @Override
    public String getTableName(int column) {
        return NOT_APPLICABLE;
    }

    @Override
    public String getCatalogName(int column) {
        return NOT_APPLICABLE;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        SqlColumnType hzType = this.getColumn(column).getType();
        Integer jdbcType = TypeUtil.getJdbcType(hzType);
        if (jdbcType == null) {
            throw new SQLException("Type mapping not found for type: " + (Object)((Object)hzType));
        }
        return jdbcType;
    }

    @Override
    public String getColumnTypeName(int column) {
        return this.getColumn(column).getType().name();
    }

    @Override
    public boolean isReadOnly(int column) {
        return true;
    }

    @Override
    public boolean isWritable(int column) {
        return !this.isReadOnly(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) {
        return false;
    }

    @Override
    public String getColumnClassName(int column) {
        return this.getColumn(column).getType().getValueClass().getName();
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return JdbcUtils.unwrap(this, iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return JdbcUtils.isWrapperFor(this, iface);
    }

    private SqlColumnMetadata getColumn(int column) {
        if (column <= 0 || column > this.getColumnCount()) {
            throw new IndexOutOfBoundsException("Column index is out of bounds: " + column);
        }
        return this.sqlRowMetadata.getColumn(column - 1);
    }
}

