/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jdbc;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jdbc.HazelcastConfigFactory;
import com.hazelcast.jdbc.JdbcUrl;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlStatement;

class HazelcastSqlClient {
    private final HazelcastInstance client;
    private final JdbcUrl jdbcUrl;

    HazelcastSqlClient(JdbcUrl url) {
        this.jdbcUrl = url;
        HazelcastConfigFactory configFactory = new HazelcastConfigFactory();
        ClientConfig clientConfig = configFactory.clientConfig(url);
        this.client = HazelcastClient.newHazelcastClient(clientConfig);
    }

    SqlResult execute(SqlStatement sqlStatement) {
        return this.client.getSql().execute(sqlStatement);
    }

    void shutdown() {
        this.client.shutdown();
    }

    boolean isRunning() {
        return this.client.getLifecycleService().isRunning();
    }

    HazelcastInstance getClient() {
        return this.client;
    }

    JdbcUrl getJdbcUrl() {
        return this.jdbcUrl;
    }
}

