/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.NamedConfig;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.annotation.Beta;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Beta
public class ExternalDataStoreConfig
implements IdentifiedDataSerializable,
NamedConfig {
    private String name;
    private String className;
    private boolean shared = true;
    private Properties properties = new Properties();

    public ExternalDataStoreConfig() {
    }

    public ExternalDataStoreConfig(ExternalDataStoreConfig config) {
        this.name = config.name;
        this.className = config.className;
        this.shared = config.shared;
        this.properties.putAll((Map<?, ?>)config.getProperties());
    }

    public ExternalDataStoreConfig(String name) {
        this.name = Preconditions.checkNotNull(name, "Name must not be null");
    }

    @Override
    public ExternalDataStoreConfig setName(String name) {
        this.name = Preconditions.checkNotNull(name, "Name must not be null");
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public ExternalDataStoreConfig setClassName(@Nonnull String className) {
        this.className = Preconditions.checkHasText(className, "Data store class name must contain text");
        return this;
    }

    public boolean isShared() {
        return this.shared;
    }

    public ExternalDataStoreConfig setShared(boolean shared) {
        this.shared = shared;
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Nullable
    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public ExternalDataStoreConfig setProperty(String key, String value) {
        this.properties.setProperty(key, value);
        return this;
    }

    public ExternalDataStoreConfig setProperties(Properties properties) {
        this.properties = Preconditions.checkNotNull(properties, "Data store properties cannot be null!");
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalDataStoreConfig that = (ExternalDataStoreConfig)o;
        return this.shared == that.shared && Objects.equals(this.name, that.name) && Objects.equals(this.className, that.className) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.className, this.shared, this.properties);
    }

    public String toString() {
        return "ExternalDataStoreConfig{name='" + this.name + '\'' + ", className='" + this.className + '\'' + ", shared=" + this.shared + ", properties=" + this.properties + '}';
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.className);
        out.writeBoolean(this.shared);
        out.writeInt(this.properties.size());
        for (String key : this.properties.stringPropertyNames()) {
            out.writeString(key);
            out.writeString(this.properties.getProperty(key));
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.className = in.readString();
        this.shared = in.readBoolean();
        int propertiesSize = in.readInt();
        for (int i = 0; i < propertiesSize; ++i) {
            String key = in.readString();
            String value = in.readString();
            this.properties.setProperty(key, value);
        }
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 68;
    }
}

