/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jclouds;

import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.io.Files;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.properties.PropertyDefinition;
import com.hazelcast.jclouds.IAMRoleCredentialSupplierBuilder;
import com.hazelcast.jclouds.JCloudsProperties;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.util.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import org.jclouds.ContextBuilder;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.googlecloud.GoogleCredentialsFromJson;

public class ComputeServiceBuilder {
    private static final String GOOGLE_COMPUTE_ENGINE = "google-compute-engine";
    private static final String AWS_EC2 = "aws-ec2";
    private static final String JCLOUD_CONNECTION_TIMEOUT = "10000";
    private static final ILogger LOGGER = Logger.getLogger(ComputeServiceBuilder.class);
    private final Map<String, Comparable> properties;
    private Set<String> regionsSet = new LinkedHashSet<String>();
    private Set<String> zonesSet = new LinkedHashSet<String>();
    private List<AbstractMap.SimpleImmutableEntry> tagPairs = new ArrayList<AbstractMap.SimpleImmutableEntry>();
    private Predicate<ComputeMetadata> nodesFilter;
    private ComputeService computeService;

    ComputeServiceBuilder(Map<String, Comparable> properties) {
        Preconditions.checkNotNull(properties, (String)"Props cannot be null");
        this.properties = properties;
    }

    public Map<String, Comparable> getProperties() {
        return this.properties;
    }

    public Set<String> getRegionsSet() {
        return this.regionsSet;
    }

    public Set<String> getZonesSet() {
        return this.zonesSet;
    }

    public List<AbstractMap.SimpleImmutableEntry> getTagPairs() {
        return this.tagPairs;
    }

    public void setComputeService(ComputeService computeService) {
        this.computeService = computeService;
    }

    public Iterable<? extends NodeMetadata> getFilteredNodes() {
        String group = (String)this.getOrNull(JCloudsProperties.GROUP);
        Set result = this.computeService.listNodesDetailsMatching(this.nodesFilter);
        HashSet<NodeMetadata> filteredResult = new HashSet<NodeMetadata>();
        for (NodeMetadata metadata : result) {
            if (group != null && !group.equals(metadata.getGroup()) || !this.isNodeInsideZones(metadata) || !this.isNodeInsideRegions(metadata)) continue;
            filteredResult.add(metadata);
        }
        return filteredResult;
    }

    public int getServicePort() {
        return this.getOrDefault(JCloudsProperties.HZ_PORT, 5701);
    }

    public boolean isNodeInsideZones(NodeMetadata metadata) {
        for (Location location = metadata.getLocation(); location != null; location = location.getParent()) {
            String id = location.getId();
            if (!location.getScope().equals((Object)LocationScope.ZONE) || id == null || this.zonesSet.isEmpty() || this.zonesSet.contains(id)) continue;
            return false;
        }
        return true;
    }

    public boolean isNodeInsideRegions(NodeMetadata metadata) {
        for (Location location = metadata.getLocation(); location != null; location = location.getParent()) {
            String id = location.getId();
            if (!location.getScope().equals((Object)LocationScope.REGION) || id == null || this.regionsSet.isEmpty() || this.regionsSet.contains(id)) continue;
            return false;
        }
        return true;
    }

    public void destroy() {
        if (this.computeService != null) {
            this.computeService.getContext().close();
        }
    }

    ComputeService build() {
        String cloudProvider = (String)this.getOrNull(JCloudsProperties.PROVIDER);
        String identity = (String)this.getOrNull(JCloudsProperties.IDENTITY);
        String credential = (String)this.getOrNull(JCloudsProperties.CREDENTIAL);
        String credentialPath = (String)this.getOrNull(JCloudsProperties.CREDENTIAL_PATH);
        Preconditions.isNotNull((Object)cloudProvider, (String)"Cloud Provider");
        if (credential != null && credentialPath != null) {
            throw new UnsupportedOperationException("Both credential and credentialPath are set. Use only one method.");
        }
        if (credentialPath != null) {
            credential = this.getCredentialFromFile(credential, credentialPath);
        }
        if (LOGGER.isFinestEnabled()) {
            LOGGER.finest("Using CLOUD_PROVIDER: " + cloudProvider);
        }
        String roleName = (String)this.getOrNull(JCloudsProperties.ROLE_NAME);
        ContextBuilder contextBuilder = this.newContextBuilder(cloudProvider, identity, credential, roleName);
        Properties jcloudsProperties = this.buildRegionZonesConfig();
        this.buildTagConfig();
        this.buildNodeFilter();
        this.computeService = ((ComputeServiceContext)contextBuilder.overrides(jcloudsProperties).buildView(ComputeServiceContext.class)).getComputeService();
        return this.computeService;
    }

    public Properties buildRegionZonesConfig() {
        String regions = (String)this.getOrNull(JCloudsProperties.REGIONS);
        String zones = (String)this.getOrNull(JCloudsProperties.ZONES);
        Properties jcloudsProperties = this.newOverrideProperties();
        if (regions != null) {
            List<String> regionList = Arrays.asList(regions.split(","));
            for (String region : regionList) {
                this.regionsSet.add(region);
            }
            jcloudsProperties.setProperty("jclouds.regions", regions);
        }
        if (zones != null) {
            List<String> zoneList = Arrays.asList(zones.split(","));
            for (String zone : zoneList) {
                this.zonesSet.add(zone);
            }
            jcloudsProperties.setProperty("jclouds.zones", zones);
        }
        return jcloudsProperties;
    }

    public void buildTagConfig() {
        String tagKeys = (String)this.getOrNull(JCloudsProperties.TAG_KEYS);
        String tagValues = (String)this.getOrNull(JCloudsProperties.TAG_VALUES);
        if (tagKeys != null && tagValues != null) {
            List<String> keysList = Arrays.asList(tagKeys.split(","));
            List<String> valueList = Arrays.asList(tagValues.split(","));
            if (keysList.size() != valueList.size()) {
                throw new InvalidConfigurationException("Tags keys and value count does not match.");
            }
            for (int i = 0; i < keysList.size(); ++i) {
                this.tagPairs.add(new AbstractMap.SimpleImmutableEntry<String, String>(keysList.get(i), valueList.get(i)));
            }
        }
    }

    public Predicate<ComputeMetadata> buildNodeFilter() {
        this.nodesFilter = new Predicate<ComputeMetadata>(){

            public boolean apply(ComputeMetadata nodeMetadata) {
                if (nodeMetadata == null) {
                    return false;
                }
                if (ComputeServiceBuilder.this.tagPairs.size() > nodeMetadata.getUserMetadata().size()) {
                    return false;
                }
                for (AbstractMap.SimpleImmutableEntry entry : ComputeServiceBuilder.this.tagPairs) {
                    String value = (String)nodeMetadata.getUserMetadata().get(entry.getKey());
                    if (value != null && value.equals(entry.getValue())) continue;
                    return false;
                }
                return true;
            }
        };
        return this.nodesFilter;
    }

    public String getCredentialFromFile(String provider, String credentialPath) throws IllegalArgumentException {
        try {
            String fileContents = Files.toString((File)new File(credentialPath), (Charset)Charsets.UTF_8);
            if (provider.equals(GOOGLE_COMPUTE_ENGINE)) {
                GoogleCredentialsFromJson credentialSupplier = new GoogleCredentialsFromJson(fileContents);
                return ((Credentials)credentialSupplier.get()).credential;
            }
            return fileContents;
        }
        catch (IOException e) {
            throw new InvalidConfigurationException("Failed to retrieve the private key from the file: " + credentialPath, (Throwable)e);
        }
    }

    public ContextBuilder newContextBuilder(String cloudProvider, String identity, String credential, final String roleName) {
        try {
            if (roleName != null && (identity != null || credential != null)) {
                throw new InvalidConfigurationException("IAM role is configured, identity or credential propery is not allowed.");
            }
            if (roleName != null && !cloudProvider.equals(AWS_EC2)) {
                throw new InvalidConfigurationException("IAM role is only supported with aws-ec2, your cloud provider is " + cloudProvider);
            }
            if (cloudProvider.equals(AWS_EC2) && roleName != null) {
                Supplier<Credentials> credentialsSupplier = new Supplier<Credentials>(){

                    public Credentials get() {
                        return new IAMRoleCredentialSupplierBuilder().withRoleName(roleName).build();
                    }
                };
                return ContextBuilder.newBuilder((String)cloudProvider).credentialsSupplier((Supplier)credentialsSupplier);
            }
            Preconditions.checkNotNull((Object)identity, (String)"Cloud provider identity is not set");
            Preconditions.checkNotNull((Object)credential, (String)"Cloud provider credential is not set");
            return ContextBuilder.newBuilder((String)cloudProvider).credentials(identity, credential);
        }
        catch (NoSuchElementException e) {
            throw new InvalidConfigurationException("Unrecognized cloud-provider [" + cloudProvider + "]");
        }
    }

    private Properties newOverrideProperties() {
        Properties properties = new Properties();
        properties.setProperty("jclouds.so-timeout", JCLOUD_CONNECTION_TIMEOUT);
        properties.setProperty("jclouds.connection-timeout", JCLOUD_CONNECTION_TIMEOUT);
        return properties;
    }

    private <T extends Comparable> T getOrNull(PropertyDefinition property) {
        return this.getOrDefault(property, null);
    }

    private <T extends Comparable> T getOrDefault(PropertyDefinition property, T defaultValue) {
        if (this.properties == null || property == null) {
            return defaultValue;
        }
        Comparable value = this.properties.get(property.key());
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }
}

