/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.protocol.generator;

import com.hazelcast.annotation.EventResponse;
import com.hazelcast.annotation.GenerateCodec;
import com.hazelcast.annotation.Nullable;
import com.hazelcast.annotation.Request;
import com.hazelcast.client.protocol.generator.CodeGenerationUtils;
import com.hazelcast.client.protocol.generator.Lang;
import com.hazelcast.client.protocol.generator.Model;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;

public class CodecModel
implements Model {
    static final Map<String, TypeElement> CUSTOM_CODEC_MAP = new HashMap<String, TypeElement>();
    private final Lang lang;
    private short requestId;
    private String id;
    private String name;
    private String className;
    private String parentName;
    private String packageName;
    private String comment = "";
    private int retryable;
    private int response;
    private Elements elementUtil;
    private final List<ParameterModel> requestParams = new LinkedList<ParameterModel>();
    private final List<ParameterModel> responseParams = new LinkedList<ParameterModel>();
    private final List<EventModel> events = new LinkedList<EventModel>();

    public CodecModel(boolean mockup) {
        this.retryable = 1;
        this.lang = Lang.JAVA;
        this.name = "put";
        this.parentName = "Map";
        this.className = CodeGenerationUtils.capitalizeFirstLetter(this.parentName) + CodeGenerationUtils.capitalizeFirstLetter(this.name) + "Codec";
        this.packageName = "com.hazelcast.client.impl.protocol.codec";
        this.response = 104;
        ParameterModel pm = new ParameterModel();
        pm.name = "name";
        pm.type = "java.lang.String";
        pm.lang = Lang.JAVA;
        pm.nullable = true;
        this.requestParams.add(pm);
        pm = new ParameterModel();
        pm.name = "val";
        pm.type = "int";
        pm.lang = Lang.JAVA;
        pm.nullable = false;
        this.requestParams.add(pm);
        pm = new ParameterModel();
        pm.name = "address";
        pm.type = "com.hazelcast.nio.Address";
        pm.lang = Lang.JAVA;
        pm.nullable = false;
        this.requestParams.add(pm);
        pm = new ParameterModel();
        pm.name = "arr";
        pm.type = "int[]";
        pm.lang = Lang.JAVA;
        pm.nullable = false;
        this.requestParams.add(pm);
        pm = new ParameterModel();
        pm.name = "setD";
        pm.type = "java.util.Set<com.hazelcast.nio.serialization.Data>";
        pm.lang = Lang.JAVA;
        pm.nullable = false;
        this.requestParams.add(pm);
        pm = new ParameterModel();
        pm.name = "mapIS";
        pm.type = "java.util.Map<java.lang.Integer, java.lang.String>";
        pm.lang = Lang.JAVA;
        pm.nullable = false;
        this.requestParams.add(pm);
        pm = new ParameterModel();
        pm.name = "mapDD";
        pm.type = "java.util.Map<com.hazelcast.nio.serialization.Data, com.hazelcast.nio.serialization.Data>";
        pm.lang = Lang.JAVA;
        pm.nullable = false;
        this.requestParams.add(pm);
        pm = new ParameterModel();
        pm.name = "entryView";
        pm.type = "com.hazelcast.map.impl.SimpleEntryView<com.hazelcast.nio.serialization.Data, com.hazelcast.nio.serialization.Data>";
        pm.lang = Lang.JAVA;
        pm.nullable = true;
        this.requestParams.add(pm);
        pm = new ParameterModel();
        pm.name = "name";
        pm.type = "long";
        pm.lang = Lang.JAVA;
        pm.nullable = false;
        this.responseParams.add(pm);
        EventModel eventModel = new EventModel();
        eventModel.type = 104;
        eventModel.name = "";
        ArrayList<ParameterModel> eventParam = new ArrayList<ParameterModel>();
        pm = new ParameterModel();
        pm.name = "name";
        pm.type = "java.lang.String";
        pm.lang = Lang.JAVA;
        pm.nullable = true;
        eventParam.add(pm);
        eventModel.eventParams = eventParam;
        this.events.add(eventModel);
    }

    public CodecModel(TypeElement parent, ExecutableElement methodElement, ExecutableElement responseElement, List<ExecutableElement> eventElementList, boolean retryable, Lang lang, Elements docCommentUtil) {
        this.retryable = retryable ? 1 : 0;
        this.lang = lang;
        this.name = methodElement.getSimpleName().toString();
        this.requestId = methodElement.getAnnotation(Request.class).id();
        short masterId = parent.getAnnotation(GenerateCodec.class).id();
        this.id = CodeGenerationUtils.addHexPrefix(CodeGenerationUtils.mergeIds(masterId, this.requestId));
        this.parentName = parent.getAnnotation(GenerateCodec.class).name();
        this.className = CodeGenerationUtils.capitalizeFirstLetter(this.parentName) + CodeGenerationUtils.capitalizeFirstLetter(this.name) + "Codec";
        this.packageName = "com.hazelcast.client.impl.protocol.codec";
        if (lang != Lang.JAVA) {
            this.packageName = parent.getAnnotation(GenerateCodec.class).ns();
        }
        this.response = methodElement.getAnnotation(Request.class).response();
        this.elementUtil = docCommentUtil;
        this.initParameters(methodElement, responseElement, eventElementList, lang);
    }

    private void initParameters(ExecutableElement methodElement, ExecutableElement responseElement, List<ExecutableElement> eventElementList, Lang lang) {
        ParameterModel pm;
        Nullable nullable;
        for (VariableElement variableElement : methodElement.getParameters()) {
            nullable = variableElement.getAnnotation(Nullable.class);
            pm = new ParameterModel();
            pm.name = variableElement.getSimpleName().toString();
            pm.type = variableElement.asType().toString();
            pm.lang = lang;
            pm.nullable = nullable != null;
            this.requestParams.add(pm);
        }
        for (VariableElement variableElement : responseElement.getParameters()) {
            nullable = variableElement.getAnnotation(Nullable.class);
            pm = new ParameterModel();
            pm.name = variableElement.getSimpleName().toString();
            pm.type = variableElement.asType().toString();
            pm.lang = lang;
            pm.nullable = nullable != null;
            this.responseParams.add(pm);
        }
        for (ExecutableElement executableElement : eventElementList) {
            EventModel eventModel = new EventModel();
            eventModel.comment = this.elementUtil.getDocComment(executableElement);
            ArrayList<ParameterModel> eventParam = new ArrayList<ParameterModel>();
            for (VariableElement variableElement : executableElement.getParameters()) {
                Nullable nullable2 = variableElement.getAnnotation(Nullable.class);
                ParameterModel pm2 = new ParameterModel();
                pm2.name = variableElement.getSimpleName().toString();
                pm2.type = variableElement.asType().toString();
                pm2.lang = lang;
                pm2.nullable = nullable2 != null;
                pm2.description = CodeGenerationUtils.getDescription(pm2.name, eventModel.comment);
                eventParam.add(pm2);
            }
            eventModel.type = executableElement.getAnnotation(EventResponse.class).value();
            eventModel.name = executableElement.getSimpleName().toString();
            eventModel.eventParams = eventParam;
            this.events.add(eventModel);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Lang getLang() {
        return this.lang;
    }

    public short getRequestId() {
        return this.requestId;
    }

    public String getId() {
        return this.id;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public String getParentName() {
        return this.parentName;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public boolean isEmpty() {
        return this.requestParams.isEmpty();
    }

    public int getResponse() {
        return this.response;
    }

    public List<ParameterModel> getRequestParams() {
        return this.requestParams;
    }

    public List<ParameterModel> getResponseParams() {
        return this.responseParams;
    }

    public List<EventModel> getEvents() {
        return this.events;
    }

    public int getRetryable() {
        return this.retryable;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public static class ParameterModel {
        private String name;
        private String type;
        private Lang lang;
        private boolean nullable;
        private String description = "";

        public String getName() {
            return this.name;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public String getType() {
            return this.type;
        }

        public Lang getLang() {
            return this.lang;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class EventModel {
        private String name;
        private List<ParameterModel> eventParams;
        private int type;
        String comment = "";

        public int getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public List<ParameterModel> getEventParams() {
            return this.eventParams;
        }

        public String getComment() {
            return this.comment;
        }
    }
}

