/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.protocol.generator;

import com.hazelcast.annotation.GenerateCodec;
import com.hazelcast.annotation.Request;
import com.hazelcast.client.protocol.generator.CodeGenerationUtils;
import com.hazelcast.client.protocol.generator.Lang;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public class MessageTypeEnumModel {
    private String name;
    private String className;
    private String packageName;
    private final List<ParameterModel> params = new LinkedList<ParameterModel>();

    public MessageTypeEnumModel(TypeElement classElement, Lang lang) {
        try {
            this.name = classElement.getAnnotation(GenerateCodec.class).name();
            this.className = CodeGenerationUtils.capitalizeFirstLetter(this.name) + "MessageType";
            this.packageName = "com.hazelcast.client.impl.protocol.codec";
            if (lang != Lang.JAVA) {
                this.packageName = classElement.getAnnotation(GenerateCodec.class).ns();
            }
            short masterId = classElement.getAnnotation(GenerateCodec.class).id();
            for (Element element : classElement.getEnclosedElements()) {
                if (!element.getKind().equals((Object)ElementKind.METHOD)) continue;
                ExecutableElement methodElement = (ExecutableElement)element;
                Request annotation1 = methodElement.getAnnotation(Request.class);
                ParameterModel pm = new ParameterModel();
                pm.name = methodElement.getSimpleName().toString();
                if (annotation1 == null) continue;
                pm.id = CodeGenerationUtils.mergeIds(masterId, annotation1.id());
                this.params.add(pm);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isEmpty() {
        return this.params.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public List<ParameterModel> getParams() {
        return this.params;
    }

    public static class ParameterModel {
        private String name;
        private String id;

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }
    }
}

