/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.protocol.generator;

import com.hazelcast.annotation.EncodeMethod;
import com.hazelcast.annotation.GenerateParameters;
import com.hazelcast.client.protocol.generator.CodeGenerationUtils;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public class MessageTypeEnumModel {
    private static final int BYTE_BIT_COUNT = 8;
    private String name;
    private String className;
    private String packageName;
    private final List<ParameterModel> params = new LinkedList<ParameterModel>();

    public MessageTypeEnumModel(TypeElement classElement) {
        this.name = classElement.getAnnotation(GenerateParameters.class).name();
        this.className = CodeGenerationUtils.capitalizeFirstLetter(this.name) + "MessageType";
        this.packageName = CodeGenerationUtils.getPackageNameFromQualifiedName(classElement.getQualifiedName().toString());
        short masterId = classElement.getAnnotation(GenerateParameters.class).id();
        for (Element element : classElement.getEnclosedElements()) {
            if (!element.getKind().equals((Object)ElementKind.METHOD)) continue;
            ExecutableElement methodElement = (ExecutableElement)element;
            ParameterModel pm = new ParameterModel();
            pm.name = methodElement.getSimpleName().toString();
            String s = Integer.toHexString((masterId << 8) + methodElement.getAnnotation(EncodeMethod.class).id());
            pm.id = s.length() == 3 ? "0x0" + s : "0x" + s;
            this.params.add(pm);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public List<ParameterModel> getParams() {
        return this.params;
    }

    public static class ParameterModel {
        private String name;
        private String id;

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }
    }
}

