/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.protocol.generator;

import com.hazelcast.annotation.ContainsNullable;
import com.hazelcast.annotation.EventResponse;
import com.hazelcast.annotation.GenerateCodec;
import com.hazelcast.annotation.Nullable;
import com.hazelcast.annotation.Request;
import com.hazelcast.annotation.Since;
import com.hazelcast.client.protocol.generator.CodeGenerationUtils;
import com.hazelcast.client.protocol.generator.Lang;
import com.hazelcast.client.protocol.generator.Model;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;

public class CodecModel
implements Model {
    static final Map<String, TypeElement> CUSTOM_CODEC_MAP = new HashMap<String, TypeElement>();
    private static final String DEFAULT_PACKAGE_NAME = "com.hazelcast.client.impl.protocol.codec";
    private static final String DEFAULT_SINCE_VERSION = "1.0";
    private static final int EVENT_MODEL_TYPE = 104;
    private final List<ParameterModel> requestParams = new LinkedList<ParameterModel>();
    private final Map<String, List<ParameterModel>> versionedRequestParams = new HashMap<String, List<ParameterModel>>();
    private final List<ParameterModel> responseParams = new LinkedList<ParameterModel>();
    private final Map<String, List<ParameterModel>> versionedResponseParams = new HashMap<String, List<ParameterModel>>();
    private final List<EventModel> events = new LinkedList<EventModel>();
    private final Lang lang;
    private final String name;
    private final String parentName;
    private final String className;
    private final String packageName;
    private final int retryable;
    private final int acquiresResource;
    private final int response;
    private String messageSince = "1.0";
    private int messageSinceInt;
    private int highestParameterVersion = -1;
    private short requestId;
    private String id;
    private String partitionIdentifier;
    private String comment = "";
    private Elements elementUtil;

    CodecModel(TypeElement parent, ExecutableElement methodElement, ExecutableElement responseElement, List<ExecutableElement> eventElementList, boolean retryable, boolean acquiresResourse, Lang lang, Elements docCommentUtil) {
        GenerateCodec generateCodecAnnotation = parent.getAnnotation(GenerateCodec.class);
        Since codecSinceVersion = parent.getAnnotation(Since.class);
        Since methodSince = methodElement.getAnnotation(Since.class);
        this.messageSince = null != codecSinceVersion ? codecSinceVersion.value() : this.messageSince;
        this.messageSince = null != methodSince ? methodSince.value() : this.messageSince;
        Request requestAnnotation = methodElement.getAnnotation(Request.class);
        this.lang = lang;
        this.name = methodElement.getSimpleName().toString();
        this.parentName = generateCodecAnnotation.name();
        this.className = CodeGenerationUtils.capitalizeFirstLetter(this.parentName) + CodeGenerationUtils.capitalizeFirstLetter(this.name) + "Codec";
        this.packageName = lang != Lang.JAVA ? generateCodecAnnotation.ns() : DEFAULT_PACKAGE_NAME;
        this.retryable = retryable ? 1 : 0;
        this.acquiresResource = acquiresResourse ? 1 : 0;
        this.response = requestAnnotation.response();
        this.requestId = requestAnnotation.id();
        this.id = CodeGenerationUtils.addHexPrefix(CodeGenerationUtils.mergeIds(generateCodecAnnotation.id(), this.requestId));
        this.partitionIdentifier = requestAnnotation.partitionIdentifier();
        this.elementUtil = docCommentUtil;
        this.highestParameterVersion = this.messageSinceInt = CodeGenerationUtils.versionAsInt(this.messageSince);
        this.initParameters(methodElement, responseElement, eventElementList, lang);
    }

    public CodecModel(boolean mockup) {
        this.lang = Lang.JAVA;
        this.name = "put";
        this.parentName = "Map";
        this.className = CodeGenerationUtils.capitalizeFirstLetter(this.parentName) + CodeGenerationUtils.capitalizeFirstLetter(this.name) + "Codec";
        this.packageName = DEFAULT_PACKAGE_NAME;
        this.retryable = 1;
        this.acquiresResource = 0;
        this.response = 104;
        this.initRequestParameters();
        this.initResponseParameters();
        this.initEventModel();
    }

    private void initParameters(ExecutableElement methodElement, ExecutableElement responseElement, List<ExecutableElement> eventElementList, Lang lang) {
        this.initRequestParameters(methodElement, lang);
        this.initResponseParameters(responseElement, lang);
        this.initEventParameters(eventElementList, lang);
    }

    private void initEventParameters(List<ExecutableElement> eventElementList, Lang lang) {
        for (ExecutableElement element : eventElementList) {
            EventModel eventModel = new EventModel();
            eventModel.comment = this.elementUtil.getDocComment(element);
            Since eventSinceVersion = element.getAnnotation(Since.class);
            eventModel.sinceVersion = eventSinceVersion != null ? eventSinceVersion.value() : DEFAULT_SINCE_VERSION;
            eventModel.sinceVersionInt = CodeGenerationUtils.versionAsInt(eventModel.sinceVersion);
            eventModel.type = element.getAnnotation(EventResponse.class).value();
            eventModel.name = element.getSimpleName().toString();
            ArrayList<ParameterModel> eventParam = new ArrayList<ParameterModel>();
            int previousParamVersionInt = eventModel.sinceVersionInt;
            String previousParamVersion = eventModel.sinceVersion;
            for (VariableElement variableElement : element.getParameters()) {
                String parameterName;
                ParameterModel pm;
                int paramVersionInt;
                Nullable nullable = variableElement.getAnnotation(Nullable.class);
                Since sinceVersion = variableElement.getAnnotation(Since.class);
                ContainsNullable containsNullable = variableElement.getAnnotation(ContainsNullable.class);
                String paramVersion = eventModel.sinceVersion;
                if (null != sinceVersion) {
                    paramVersion = sinceVersion.value();
                }
                if ((paramVersionInt = (pm = CodecModel.createParameterModel(parameterName = variableElement.getSimpleName().toString(), variableElement.asType().toString(), nullable != null, containsNullable != null, paramVersion, lang)).sinceVersionInt) > this.highestParameterVersion) {
                    this.highestParameterVersion = paramVersionInt;
                }
                if (paramVersionInt != previousParamVersionInt) {
                    pm.versionChanged = true;
                    eventModel.versionedEventParams.put(previousParamVersion, new LinkedList(eventParam));
                }
                previousParamVersionInt = paramVersionInt;
                previousParamVersion = paramVersion;
                eventParam.add(pm);
            }
            eventModel.versionedEventParams.put(previousParamVersion, new LinkedList(eventParam));
            eventModel.eventParams = eventParam;
            this.events.add(eventModel);
        }
    }

    private void initResponseParameters(ExecutableElement responseElement, Lang lang) {
        Since responseSinceAnnotation = responseElement.getAnnotation(Since.class);
        String previousParamVersion = responseSinceAnnotation != null ? responseSinceAnnotation.value() : this.messageSince;
        int previousParamVersionInt = CodeGenerationUtils.versionAsInt(previousParamVersion);
        for (VariableElement variableElement : responseElement.getParameters()) {
            String parameterName;
            ParameterModel pm;
            int paramVersionInt;
            Nullable nullable = variableElement.getAnnotation(Nullable.class);
            Since sinceVersion = variableElement.getAnnotation(Since.class);
            ContainsNullable containsNullable = variableElement.getAnnotation(ContainsNullable.class);
            String paramVersion = previousParamVersion;
            if (null != sinceVersion) {
                paramVersion = sinceVersion.value();
            }
            if ((paramVersionInt = (pm = CodecModel.createParameterModel(parameterName = variableElement.getSimpleName().toString(), variableElement.asType().toString(), nullable != null, containsNullable != null, paramVersion, lang)).sinceVersionInt) > this.highestParameterVersion) {
                this.highestParameterVersion = paramVersionInt;
            }
            if (paramVersionInt != previousParamVersionInt) {
                pm.versionChanged = true;
                this.versionedResponseParams.put(previousParamVersion, new LinkedList<ParameterModel>(this.responseParams));
            }
            previousParamVersionInt = paramVersionInt;
            previousParamVersion = paramVersion;
            this.responseParams.add(pm);
        }
        this.versionedResponseParams.put(previousParamVersion, new LinkedList<ParameterModel>(this.responseParams));
    }

    private void initRequestParameters(ExecutableElement methodElement, Lang lang) {
        int previousParamVersionInt = 1000;
        String previousParamVersion = this.messageSince;
        for (VariableElement variableElement : methodElement.getParameters()) {
            String parameterName;
            ParameterModel pm;
            int paramVersionInt;
            Nullable nullable = variableElement.getAnnotation(Nullable.class);
            Since sinceVersion = variableElement.getAnnotation(Since.class);
            ContainsNullable containsNullable = variableElement.getAnnotation(ContainsNullable.class);
            String paramVersion = this.messageSince;
            if (null != sinceVersion) {
                paramVersion = sinceVersion.value();
            }
            if ((paramVersionInt = (pm = CodecModel.createParameterModel(parameterName = CodeGenerationUtils.escape(variableElement.getSimpleName().toString(), lang), variableElement.asType().toString(), nullable != null, containsNullable != null, paramVersion, lang)).sinceVersionInt) > this.highestParameterVersion) {
                this.highestParameterVersion = paramVersionInt;
            }
            if (paramVersionInt != previousParamVersionInt) {
                pm.versionChanged = true;
                this.versionedRequestParams.put(previousParamVersion, new LinkedList<ParameterModel>(this.requestParams));
            }
            previousParamVersionInt = paramVersionInt;
            previousParamVersion = paramVersion;
            this.requestParams.add(pm);
        }
        this.versionedRequestParams.put(previousParamVersion, new LinkedList<ParameterModel>(this.requestParams));
    }

    private void initRequestParameters() {
        this.requestParams.add(CodecModel.createParameterModel("name", "java.lang.String", true, DEFAULT_SINCE_VERSION));
        this.requestParams.add(CodecModel.createParameterModel("val", "int", false, DEFAULT_SINCE_VERSION));
        this.requestParams.add(CodecModel.createParameterModel("address", "com.hazelcast.nio.Address", false, DEFAULT_SINCE_VERSION));
        this.requestParams.add(CodecModel.createParameterModel("arr", "int[]", false, DEFAULT_SINCE_VERSION));
        this.requestParams.add(CodecModel.createParameterModel("setD", "java.util.Set<com.hazelcast.nio.serialization.Data>", false, DEFAULT_SINCE_VERSION));
        this.requestParams.add(CodecModel.createParameterModel("mapIS", "java.util.Map<java.lang.Integer, java.lang.String>", false, DEFAULT_SINCE_VERSION));
        this.requestParams.add(CodecModel.createParameterModel("mapDD", "java.util.Map<com.hazelcast.nio.serialization.Data, com.hazelcast.nio.serialization.Data>", false, DEFAULT_SINCE_VERSION));
        this.requestParams.add(CodecModel.createParameterModel("entryView", "com.hazelcast.map.impl.SimpleEntryView<com.hazelcast.nio.serialization.Data, com.hazelcast.nio.serialization.Data>", true, DEFAULT_SINCE_VERSION));
    }

    private void initResponseParameters() {
        this.responseParams.add(CodecModel.createParameterModel("name", "long", false, DEFAULT_SINCE_VERSION));
    }

    private void initEventModel() {
        ParameterModel pm = new ParameterModel();
        pm.name = "name";
        pm.type = "java.lang.String";
        pm.lang = Lang.JAVA;
        pm.nullable = true;
        ArrayList<ParameterModel> eventParam = new ArrayList<ParameterModel>();
        eventParam.add(pm);
        EventModel eventModel = new EventModel();
        eventModel.type = 104;
        eventModel.name = "";
        eventModel.eventParams = eventParam;
        this.events.add(eventModel);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Lang getLang() {
        return this.lang;
    }

    public short getRequestId() {
        return this.requestId;
    }

    public String getId() {
        return this.id;
    }

    public String getPartitionIdentifier() {
        return this.partitionIdentifier;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public String getParentName() {
        return this.parentName;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public boolean isEmpty() {
        return this.requestParams.isEmpty();
    }

    public int getResponse() {
        return this.response;
    }

    public String getHexadecimalResponseId() {
        return CodeGenerationUtils.addHexPrefix(Integer.toHexString(this.response));
    }

    public List<ParameterModel> getRequestParams() {
        return this.requestParams;
    }

    public Map<String, List<ParameterModel>> getVersionedRequestParams() {
        return this.versionedRequestParams;
    }

    public List<ParameterModel> getResponseParams() {
        return this.responseParams;
    }

    public Map<String, List<ParameterModel>> getVersionedResponseParams() {
        return this.versionedResponseParams;
    }

    public List<EventModel> getEvents() {
        return this.events;
    }

    public int getRetryable() {
        return this.retryable;
    }

    public int getAcquiresResource() {
        return this.acquiresResource;
    }

    public String getMessageSince() {
        return this.messageSince;
    }

    public int getMessageSinceInt() {
        return this.messageSinceInt;
    }

    public int getHighestParameterVersion() {
        return this.highestParameterVersion;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    private static ParameterModel createParameterModel(String name, String type, boolean nullAble, String since) {
        return CodecModel.createParameterModel(name, type, nullAble, false, since, Lang.JAVA);
    }

    private static ParameterModel createParameterModel(String name, String type, boolean nullAble, boolean containsNullable, String since, Lang lang) {
        ParameterModel pm = new ParameterModel();
        pm.name = name;
        pm.type = type;
        pm.lang = lang;
        pm.nullable = nullAble;
        pm.containsNullable = containsNullable;
        pm.sinceVersion = since;
        pm.sinceVersionInt = CodeGenerationUtils.versionAsInt(pm.sinceVersion);
        return pm;
    }

    public static class ParameterModel {
        private String name;
        private String type;
        private Lang lang;
        private boolean nullable;
        private String description = "";
        private String sinceVersion = "1.0";
        private int sinceVersionInt;
        private boolean versionChanged;
        private boolean containsNullable;

        public String getName() {
            return this.name;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public String getType() {
            return this.type;
        }

        public Lang getLang() {
            return this.lang;
        }

        public String getDescription() {
            return this.description;
        }

        public String getSinceVersion() {
            return this.sinceVersion;
        }

        public int getSinceVersionInt() {
            return this.sinceVersionInt;
        }

        public boolean isVersionChanged() {
            return this.versionChanged;
        }

        public boolean getContainsNullable() {
            return this.containsNullable;
        }
    }

    public static class EventModel {
        private String name;
        private List<ParameterModel> eventParams;
        private final Map<String, List<ParameterModel>> versionedEventParams = new HashMap<String, List<ParameterModel>>();
        private int type;
        private String comment = "";
        private String sinceVersion = "1.0";
        private int sinceVersionInt;

        public int getType() {
            return this.type;
        }

        public String getHexadecimalTypeId() {
            return CodeGenerationUtils.addHexPrefix(Integer.toHexString(this.type));
        }

        public String getName() {
            return this.name;
        }

        public List<ParameterModel> getEventParams() {
            return this.eventParams;
        }

        public Map<String, List<ParameterModel>> getVersionedEventParams() {
            return this.versionedEventParams;
        }

        public String getComment() {
            return this.comment;
        }

        public String getSinceVersion() {
            return this.sinceVersion;
        }

        public int getSinceVersionInt() {
            return this.sinceVersionInt;
        }
    }
}

