/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws.impl;

import com.hazelcast.aws.security.EC2RequestSigner;
import com.hazelcast.aws.utility.CloudyUtility;
import com.hazelcast.config.AwsConfig;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class DescribeInstances {
    private final EC2RequestSigner rs;
    private final AwsConfig awsConfig;
    private Map<String, String> attributes = new HashMap<String, String>();

    public DescribeInstances(AwsConfig awsConfig) {
        if (awsConfig == null) {
            throw new IllegalArgumentException("AwsConfig is required!");
        }
        if (awsConfig.getAccessKey() == null) {
            throw new IllegalArgumentException("AWS access key is required!");
        }
        this.rs = new EC2RequestSigner(awsConfig.getSecretKey());
        this.attributes.put("Action", this.getClass().getSimpleName());
        this.attributes.put("Version", "2011-05-15");
        this.attributes.put("SignatureVersion", "2");
        this.attributes.put("SignatureMethod", "HmacSHA256");
        this.attributes.put("AWSAccessKeyId", awsConfig.getAccessKey());
        this.attributes.put("Timestamp", this.getFormattedTimestamp());
        this.awsConfig = awsConfig;
    }

    private String getFormattedTimestamp() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(new Date());
    }

    public String getQueryString() {
        return CloudyUtility.getQueryString(this.attributes);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void putSignature(String value) {
        this.attributes.put("Signature", value);
    }

    public Map<String, String> execute(String endpoint) throws Exception {
        this.rs.sign(this, endpoint);
        InputStream stream = this.callService(endpoint);
        return CloudyUtility.unmarshalTheResponse(stream, this.awsConfig);
    }

    private InputStream callService(String endpoint) throws Exception {
        String query = this.getQueryString();
        URL url = new URL("https", endpoint, -1, "/" + query);
        HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
        httpConnection.setRequestMethod("GET");
        httpConnection.setDoOutput(true);
        httpConnection.connect();
        return httpConnection.getInputStream();
    }
}

