/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi;

import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientDestroyProxyCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.ExceptionUtil;
import java.util.Collection;
import java.util.Iterator;

public abstract class ClientProxy
implements DistributedObject {
    protected final String name;
    private final String serviceName;
    private final ClientContext context;
    private final SerializationService serializationService;
    private volatile ClientContext lazyContext;
    private volatile SerializationService lazySerializationService;

    @Deprecated
    protected ClientProxy(String serviceName, String name) {
        this(serviceName, name, null);
    }

    protected ClientProxy(String serviceName, String name, ClientContext context) {
        this.serviceName = serviceName;
        this.name = name;
        this.context = context;
        this.serializationService = context == null ? null : context.getSerializationService();
    }

    protected final String registerListener(ListenerMessageCodec codec, EventHandler handler) {
        return this.getContext().getListenerService().registerListener(codec, handler);
    }

    protected final boolean deregisterListener(String registrationId) {
        return this.getContext().getListenerService().deregisterListener(registrationId);
    }

    public final ClientContext getContext() {
        return this.context != null ? this.context : this.lazyContext;
    }

    protected final ClientProxy setContext(ClientContext context) {
        if (this.context != null) {
            throw new IllegalStateException("The context has already been initialized!");
        }
        this.lazyContext = context;
        this.lazySerializationService = context.getSerializationService();
        return this;
    }

    protected SerializationService getSerializationService() {
        return this.serializationService != null ? this.serializationService : this.lazySerializationService;
    }

    protected Data toData(Object o) {
        return this.getSerializationService().toData(o);
    }

    protected <T> T toObject(Object data) {
        return (T)this.getSerializationService().toObject(data);
    }

    protected final HazelcastClientInstanceImpl getClient() {
        return (HazelcastClientInstanceImpl)this.getContext().getHazelcastInstance();
    }

    protected final int getConnectedServerVersion() {
        HazelcastClientInstanceImpl client = this.getClient();
        ClientConnectionManager connectionManager = client.getConnectionManager();
        Collection<ClientConnection> activeConnections = connectionManager.getActiveConnections();
        Iterator<ClientConnection> iterator = activeConnections.iterator();
        if (iterator.hasNext()) {
            ClientConnection connection = iterator.next();
            return connection.getConnectedServerVersion();
        }
        return -1;
    }

    @Deprecated
    public final Object getId() {
        return this.name;
    }

    public final String getName() {
        return this.name;
    }

    public String getPartitionKey() {
        return StringPartitioningStrategy.getPartitionKey((String)this.getDistributedObjectName());
    }

    public final String getServiceName() {
        return this.serviceName;
    }

    protected String getDistributedObjectName() {
        return this.name;
    }

    public final void destroy() {
        if (this.preDestroy()) {
            this.onDestroy();
            ClientMessage clientMessage = ClientDestroyProxyCodec.encodeRequest((String)this.getDistributedObjectName(), (String)this.getServiceName());
            this.getContext().getProxyManager().removeProxy(this.getServiceName(), this.getDistributedObjectName());
            try {
                new ClientInvocation(this.getClient(), clientMessage, this.getName()).invoke().get();
                this.postDestroy();
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
    }

    protected void onInitialize() {
    }

    protected void onDestroy() {
    }

    protected boolean preDestroy() {
        return true;
    }

    protected void postDestroy() {
    }

    protected void onShutdown() {
    }

    protected <T> T invoke(ClientMessage clientMessage, Object key) {
        int partitionId = this.getContext().getPartitionService().getPartitionId(key);
        return this.invokeOnPartition(clientMessage, partitionId);
    }

    protected <T> T invokeOnPartition(ClientMessage clientMessage, int partitionId) {
        try {
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), clientMessage, this.getName(), partitionId).invoke();
            return (T)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected <T> T invokeOnAddress(ClientMessage clientMessage, Address address) {
        try {
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), clientMessage, this.getName(), address).invoke();
            return (T)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected <T> T invokeOnPartitionInterruptibly(ClientMessage clientMessage, int partitionId) throws InterruptedException {
        try {
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), clientMessage, this.getName(), partitionId).invoke();
            return (T)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrowAllowInterrupted((Throwable)e);
        }
    }

    protected <T> T invoke(ClientMessage clientMessage) {
        try {
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), clientMessage, this.getName()).invoke();
            return (T)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientProxy that = (ClientProxy)o;
        if (!this.getInstanceName().equals(that.getInstanceName())) {
            return false;
        }
        if (!this.getDistributedObjectName().equals(that.getDistributedObjectName())) {
            return false;
        }
        return this.serviceName.equals(that.serviceName);
    }

    public int hashCode() {
        int result = this.getInstanceName().hashCode();
        result = 31 * result + this.serviceName.hashCode();
        result = 31 * result + this.getDistributedObjectName().hashCode();
        return result;
    }

    private String getInstanceName() {
        ClientContext context = this.getContext();
        return context != null ? context.getHazelcastInstance().getName() : "";
    }
}

