/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.RingbufferAddAllCodec;
import com.hazelcast.client.impl.protocol.codec.RingbufferAddCodec;
import com.hazelcast.client.impl.protocol.codec.RingbufferCapacityCodec;
import com.hazelcast.client.impl.protocol.codec.RingbufferHeadSequenceCodec;
import com.hazelcast.client.impl.protocol.codec.RingbufferReadManyCodec;
import com.hazelcast.client.impl.protocol.codec.RingbufferReadOneCodec;
import com.hazelcast.client.impl.protocol.codec.RingbufferRemainingCapacityCodec;
import com.hazelcast.client.impl.protocol.codec.RingbufferSizeCodec;
import com.hazelcast.client.impl.protocol.codec.RingbufferTailSequenceCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IFunction;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.ringbuffer.OverflowPolicy;
import com.hazelcast.ringbuffer.ReadResultSet;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.ringbuffer.StaleSequenceException;
import com.hazelcast.ringbuffer.impl.client.PortableReadResultSet;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;
import java.util.Collection;
import java.util.concurrent.ExecutionException;

public class ClientRingbufferProxy<E>
extends ClientProxy
implements Ringbuffer<E> {
    private static final ClientMessageDecoder ADD_ASYNC_ASYNC_RESPONSE_DECODER = new ClientMessageDecoder(){

        public Long decodeClientMessage(ClientMessage clientMessage) {
            return RingbufferAddCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder ADD_ALL_ASYNC_RESPONSE_DECODER = new ClientMessageDecoder(){

        public Long decodeClientMessage(ClientMessage clientMessage) {
            return RingbufferAddAllCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private ClientMessageDecoder readManyAsyncResponseDecoder;
    private int partitionId;
    private volatile long capacity = -1L;

    public ClientRingbufferProxy(String serviceName, String objectName, ClientContext context) {
        super(serviceName, objectName, context);
    }

    @Override
    protected void onInitialize() {
        String partitionKey = StringPartitioningStrategy.getPartitionKey((String)this.name);
        this.partitionId = this.getContext().getPartitionService().getPartitionId(partitionKey);
        this.readManyAsyncResponseDecoder = new ClientMessageDecoder(){

            public PortableReadResultSet decodeClientMessage(ClientMessage clientMessage) {
                RingbufferReadManyCodec.ResponseParameters params = RingbufferReadManyCodec.decodeResponse((ClientMessage)clientMessage);
                PortableReadResultSet readResultSet = new PortableReadResultSet(params.readCount, params.items, params.itemSeqs);
                readResultSet.setSerializationService(ClientRingbufferProxy.this.getSerializationService());
                return readResultSet;
            }
        };
    }

    public long capacity() {
        if (this.capacity == -1L) {
            ClientMessage request = RingbufferCapacityCodec.encodeRequest((String)this.name);
            ClientMessage response = (ClientMessage)this.invoke(request, this.partitionId);
            RingbufferCapacityCodec.ResponseParameters resultParameters = RingbufferCapacityCodec.decodeResponse((ClientMessage)response);
            this.capacity = resultParameters.response;
        }
        return this.capacity;
    }

    public long size() {
        ClientMessage request = RingbufferSizeCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request, this.partitionId);
        RingbufferSizeCodec.ResponseParameters resultParameters = RingbufferSizeCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public long tailSequence() {
        ClientMessage request = RingbufferTailSequenceCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request, this.partitionId);
        RingbufferTailSequenceCodec.ResponseParameters resultParameters = RingbufferTailSequenceCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public long headSequence() {
        ClientMessage request = RingbufferHeadSequenceCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request, this.partitionId);
        RingbufferHeadSequenceCodec.ResponseParameters resultParameters = RingbufferHeadSequenceCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public long remainingCapacity() {
        ClientMessage request = RingbufferRemainingCapacityCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request, this.partitionId);
        RingbufferRemainingCapacityCodec.ResponseParameters resultParameters = RingbufferRemainingCapacityCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public long add(E item) {
        Preconditions.checkNotNull(item, (String)"item can't be null");
        Data element = this.toData(item);
        ClientMessage request = RingbufferAddCodec.encodeRequest((String)this.name, (int)OverflowPolicy.OVERWRITE.getId(), (Data)element);
        ClientMessage response = (ClientMessage)this.invoke(request, this.partitionId);
        RingbufferAddCodec.ResponseParameters resultParameters = RingbufferAddCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public ICompletableFuture<Long> addAsync(E item, OverflowPolicy overflowPolicy) {
        Preconditions.checkNotNull(item, (String)"item can't be null");
        Preconditions.checkNotNull((Object)overflowPolicy, (String)"overflowPolicy can't be null");
        Data element = this.toData(item);
        ClientMessage request = RingbufferAddCodec.encodeRequest((String)this.name, (int)overflowPolicy.getId(), (Data)element);
        try {
            ClientInvocationFuture invocationFuture = new ClientInvocation(this.getClient(), request, this.partitionId).invoke();
            return new ClientDelegatingFuture(invocationFuture, this.getSerializationService(), ADD_ASYNC_ASYNC_RESPONSE_DECODER);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public E readOne(long sequence) throws InterruptedException {
        ClientRingbufferProxy.checkSequence(sequence);
        ClientMessage request = RingbufferReadOneCodec.encodeRequest((String)this.name, (long)sequence);
        ClientMessage response = (ClientMessage)this.invoke(request, this.partitionId);
        RingbufferReadOneCodec.ResponseParameters resultParameters = RingbufferReadOneCodec.decodeResponse((ClientMessage)response);
        return (E)this.toObject(resultParameters.response);
    }

    public ICompletableFuture<Long> addAllAsync(Collection<? extends E> collection, OverflowPolicy overflowPolicy) {
        Preconditions.checkNotNull(collection, (String)"collection can't be null");
        Preconditions.checkNotNull((Object)overflowPolicy, (String)"overflowPolicy can't be null");
        Preconditions.checkFalse((boolean)collection.isEmpty(), (String)"collection can't be empty");
        Preconditions.checkTrue((collection.size() <= 1000 ? 1 : 0) != 0, (String)"collection can't be larger than 1000");
        Collection dataCollection = CollectionUtil.objectToDataCollection(collection, (SerializationService)this.getSerializationService());
        ClientMessage request = RingbufferAddAllCodec.encodeRequest((String)this.name, (Collection)dataCollection, (int)overflowPolicy.getId());
        try {
            ClientInvocationFuture invocationFuture = new ClientInvocation(this.getClient(), request, this.partitionId).invoke();
            return new ClientDelegatingFuture(invocationFuture, this.getSerializationService(), ADD_ALL_ASYNC_RESPONSE_DECODER);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public ICompletableFuture<ReadResultSet<E>> readManyAsync(long startSequence, int minCount, int maxCount, IFunction<E, Boolean> filter) {
        ClientRingbufferProxy.checkSequence(startSequence);
        Preconditions.checkNotNegative((int)minCount, (String)"minCount can't be smaller than 0");
        Preconditions.checkTrue((maxCount >= minCount ? 1 : 0) != 0, (String)"maxCount should be equal or larger than minCount");
        Preconditions.checkTrue(((long)minCount <= this.capacity() ? 1 : 0) != 0, (String)"the minCount should be smaller than or equal to the capacity");
        Preconditions.checkTrue((maxCount <= 1000 ? 1 : 0) != 0, (String)"maxCount can't be larger than 1000");
        ClientMessage request = RingbufferReadManyCodec.encodeRequest((String)this.name, (long)startSequence, (int)minCount, (int)maxCount, (Data)this.toData(filter));
        try {
            ClientInvocationFuture invocationFuture = new ClientInvocation(this.getClient(), request, this.partitionId).invoke();
            return new ClientDelegatingFuture(invocationFuture, this.getSerializationService(), this.readManyAsyncResponseDecoder);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private static void checkSequence(long sequence) {
        if (sequence < 0L) {
            throw new IllegalArgumentException("sequence can't be smaller than 0, but was: " + sequence);
        }
    }

    protected <T> T invoke(ClientMessage clientMessage, int partitionId) {
        try {
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), clientMessage, partitionId).invoke();
            return (T)future.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof StaleSequenceException) {
                StaleSequenceException se = (StaleSequenceException)e.getCause();
                long l = this.headSequence();
                throw new StaleSequenceException(se.getMessage(), l);
            }
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public String toString() {
        return String.format("Ringbuffer{name='%s'}", this.name);
    }
}

