/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.LifecycleServiceImpl;
import com.hazelcast.client.impl.client.ClientPrincipal;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.impl.ClientMembershipListener;
import com.hazelcast.client.spi.impl.ConnectionHeartbeatListener;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.Member;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.util.Clock;
import com.hazelcast.util.executor.SingleExecutorThreadFactory;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public abstract class ClusterListenerSupport
implements ConnectionListener,
ConnectionHeartbeatListener,
ClientClusterService {
    public static final long TERMINATE_TIMEOUT_SECONDS = 30L;
    protected final HazelcastClientInstanceImpl client;
    private final Collection<AddressProvider> addressProviders;
    private final ExecutorService clusterExecutor;
    private final boolean shuffleMemberList;
    private final ILogger logger;
    private ClientConnectionManager connectionManager;
    private ClientMembershipListener clientMembershipListener;
    private volatile Address ownerConnectionAddress;
    private volatile ClientPrincipal principal;

    public ClusterListenerSupport(HazelcastClientInstanceImpl client, Collection<AddressProvider> addressProviders) {
        this.client = client;
        this.logger = client.getLoggingService().getLogger(ClusterListenerSupport.class);
        this.addressProviders = addressProviders;
        this.shuffleMemberList = client.getProperties().getBoolean(ClientProperty.SHUFFLE_MEMBER_LIST);
        this.clusterExecutor = this.createSingleThreadExecutorService(client);
    }

    private ExecutorService createSingleThreadExecutorService(HazelcastClientInstanceImpl client) {
        ThreadGroup threadGroup = client.getThreadGroup();
        ClassLoader classLoader = client.getClientConfig().getClassLoader();
        SingleExecutorThreadFactory threadFactory = new SingleExecutorThreadFactory(threadGroup, classLoader, client.getName() + ".cluster-");
        return Executors.newSingleThreadExecutor((ThreadFactory)threadFactory);
    }

    protected void init() {
        this.connectionManager = this.client.getConnectionManager();
        this.clientMembershipListener = new ClientMembershipListener(this.client);
        this.connectionManager.addConnectionListener(this);
        this.connectionManager.addConnectionHeartbeatListener(this);
    }

    @Override
    public Address getOwnerConnectionAddress() {
        return this.ownerConnectionAddress;
    }

    public void setOwnerConnectionAddress(Address ownerConnectionAddress) {
        this.ownerConnectionAddress = ownerConnectionAddress;
    }

    public void shutdown() {
        this.clusterExecutor.shutdown();
        try {
            boolean success = this.clusterExecutor.awaitTermination(30L, TimeUnit.SECONDS);
            if (!success) {
                this.logger.warning("cluster executor awaitTermination could not completed in 30 seconds");
            }
        }
        catch (InterruptedException e) {
            this.logger.warning("cluster executor await termination is interrupted", (Throwable)e);
        }
    }

    private Collection<InetSocketAddress> getSocketAddresses() {
        LinkedList<InetSocketAddress> socketAddresses = new LinkedList<InetSocketAddress>();
        Collection memberList = this.getMemberList();
        for (Member member : memberList) {
            socketAddresses.add(member.getSocketAddress());
        }
        for (AddressProvider addressProvider : this.addressProviders) {
            socketAddresses.addAll(addressProvider.loadAddresses());
        }
        if (this.shuffleMemberList) {
            Collections.shuffle(socketAddresses);
        }
        return socketAddresses;
    }

    public ClientPrincipal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(ClientPrincipal principal) {
        this.principal = principal;
    }

    public void connectToCluster() throws Exception {
        this.ownerConnectionAddress = null;
        ClientNetworkConfig networkConfig = this.client.getClientConfig().getNetworkConfig();
        int connAttemptLimit = networkConfig.getConnectionAttemptLimit();
        int connectionAttemptPeriod = networkConfig.getConnectionAttemptPeriod();
        int connectionAttemptLimit = connAttemptLimit == 0 ? Integer.MAX_VALUE : connAttemptLimit;
        HashSet<InetSocketAddress> triedAddresses = new HashSet<InetSocketAddress>();
        for (int attempt = 0; attempt < connectionAttemptLimit; ++attempt) {
            if (!this.client.getLifecycleService().isRunning()) {
                if (!this.logger.isFinestEnabled()) break;
                this.logger.finest("Giving up on retrying to connect to cluster since client is shutdown");
                break;
            }
            long nextTry = Clock.currentTimeMillis() + (long)connectionAttemptPeriod;
            boolean isConnected = this.connect(triedAddresses);
            if (isConnected) {
                return;
            }
            long remainingTime = nextTry - Clock.currentTimeMillis();
            this.logger.warning(String.format("Unable to get alive cluster connection, try in %d ms later, attempt %d of %d.", Math.max(0L, remainingTime), attempt, connectionAttemptLimit));
            if (remainingTime <= 0L) continue;
            try {
                Thread.sleep(remainingTime);
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        throw new IllegalStateException("Unable to connect to any address in the config! The following addresses were tried: " + triedAddresses);
    }

    private boolean connect(Set<InetSocketAddress> triedAddresses) throws Exception {
        Collection<InetSocketAddress> socketAddresses = this.getSocketAddresses();
        for (InetSocketAddress inetSocketAddress : socketAddresses) {
            if (!this.client.getLifecycleService().isRunning()) {
                if (!this.logger.isFinestEnabled()) break;
                this.logger.finest("Giving up on retrying to connect to cluster since client is shutdown");
                break;
            }
            Connection connection = null;
            try {
                triedAddresses.add(inetSocketAddress);
                Address address = new Address(inetSocketAddress);
                this.logger.info("Trying to connect to " + address + " as owner member");
                connection = this.connectionManager.getOrConnect(address, true);
                this.clientMembershipListener.listenMembershipEvents(this.ownerConnectionAddress);
                this.fireConnectionEvent(LifecycleEvent.LifecycleState.CLIENT_CONNECTED);
                return true;
            }
            catch (Exception e) {
                Level level = e instanceof AuthenticationException ? Level.WARNING : Level.FINEST;
                this.logger.log(level, "Exception during initial connection to " + inetSocketAddress, (Throwable)e);
                if (null == connection) continue;
                connection.close("Could not connect to " + inetSocketAddress + " as owner", (Throwable)e);
            }
        }
        return false;
    }

    private void fireConnectionEvent(LifecycleEvent.LifecycleState state) {
        LifecycleServiceImpl lifecycleService = (LifecycleServiceImpl)this.client.getLifecycleService();
        lifecycleService.fireLifecycleEvent(state);
    }

    public void connectionAdded(Connection connection) {
    }

    public void connectionRemoved(Connection connection) {
        if (connection.getEndPoint().equals((Object)this.ownerConnectionAddress) && this.client.getLifecycleService().isRunning()) {
            this.fireConnectionEvent(LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED);
            this.clusterExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ClusterListenerSupport.this.connectToCluster();
                    }
                    catch (Exception e) {
                        ClusterListenerSupport.this.logger.warning("Could not re-connect to cluster shutting down the client" + e.getMessage());
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    ClusterListenerSupport.this.client.getLifecycleService().shutdown();
                                }
                                catch (Exception exception) {
                                    ClusterListenerSupport.this.logger.severe("Exception during client shutdown ", (Throwable)exception);
                                }
                            }
                        }, ClusterListenerSupport.this.client.getName() + ".clientShutdown-").start();
                    }
                }
            });
        }
    }

    @Override
    public void heartbeatResumed(Connection connection) {
    }

    @Override
    public void heartbeatStopped(Connection connection) {
        if (connection.getEndPoint().equals((Object)this.ownerConnectionAddress)) {
            connection.close(null, (Throwable)new TargetDisconnectedException("Heartbeat timed out to owner connection " + connection));
        }
    }
}

