/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ListAddListenerCodec;
import com.hazelcast.client.impl.protocol.codec.SetAddAllCodec;
import com.hazelcast.client.impl.protocol.codec.SetAddCodec;
import com.hazelcast.client.impl.protocol.codec.SetAddListenerCodec;
import com.hazelcast.client.impl.protocol.codec.SetClearCodec;
import com.hazelcast.client.impl.protocol.codec.SetCompareAndRemoveAllCodec;
import com.hazelcast.client.impl.protocol.codec.SetCompareAndRetainAllCodec;
import com.hazelcast.client.impl.protocol.codec.SetContainsAllCodec;
import com.hazelcast.client.impl.protocol.codec.SetContainsCodec;
import com.hazelcast.client.impl.protocol.codec.SetGetAllCodec;
import com.hazelcast.client.impl.protocol.codec.SetIsEmptyCodec;
import com.hazelcast.client.impl.protocol.codec.SetRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.SetRemoveListenerCodec;
import com.hazelcast.client.impl.protocol.codec.SetSizeCodec;
import com.hazelcast.client.proxy.PartitionSpecificClientProxy;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.collection.impl.common.DataAwareItemEvent;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.Member;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.UnmodifiableLazyList;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.Preconditions;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ClientSetProxy<E>
extends PartitionSpecificClientProxy
implements ISet<E> {
    public ClientSetProxy(String serviceName, String name) {
        super(serviceName, name);
    }

    public int size() {
        ClientMessage request = SetSizeCodec.encodeRequest((String)this.name);
        ClientMessage response = this.invokeOnPartition(request);
        SetSizeCodec.ResponseParameters resultParameters = SetSizeCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean isEmpty() {
        ClientMessage request = SetIsEmptyCodec.encodeRequest((String)this.name);
        ClientMessage response = this.invokeOnPartition(request);
        SetIsEmptyCodec.ResponseParameters resultParameters = SetIsEmptyCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean contains(Object o) {
        Preconditions.checkNotNull((Object)o);
        Data value = this.toData(o);
        ClientMessage request = SetContainsCodec.encodeRequest((String)this.name, (Data)value);
        ClientMessage response = this.invokeOnPartition(request);
        SetContainsCodec.ResponseParameters resultParameters = SetContainsCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public Iterator<E> iterator() {
        return this.getAll().iterator();
    }

    public Object[] toArray() {
        return this.getAll().toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.getAll().toArray(a);
    }

    public boolean add(E e) {
        Preconditions.checkNotNull(e);
        Data element = this.toData(e);
        ClientMessage request = SetAddCodec.encodeRequest((String)this.name, (Data)element);
        ClientMessage response = this.invokeOnPartition(request);
        SetAddCodec.ResponseParameters resultParameters = SetAddCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean remove(Object o) {
        Preconditions.checkNotNull((Object)o);
        Data value = this.toData(o);
        ClientMessage request = SetRemoveCodec.encodeRequest((String)this.name, (Data)value);
        ClientMessage response = this.invokeOnPartition(request);
        SetRemoveCodec.ResponseParameters resultParameters = SetRemoveCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean containsAll(Collection<?> c) {
        Preconditions.checkNotNull(c);
        Collection dataCollection = CollectionUtil.objectToDataCollection(c, (SerializationService)this.getSerializationService());
        ClientMessage request = SetContainsAllCodec.encodeRequest((String)this.name, (Collection)dataCollection);
        ClientMessage response = this.invokeOnPartition(request);
        SetContainsAllCodec.ResponseParameters resultParameters = SetContainsAllCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean addAll(Collection<? extends E> c) {
        Preconditions.checkNotNull(c);
        Collection dataCollection = CollectionUtil.objectToDataCollection(c, (SerializationService)this.getSerializationService());
        ClientMessage request = SetAddAllCodec.encodeRequest((String)this.name, (Collection)dataCollection);
        ClientMessage response = this.invokeOnPartition(request);
        SetAddAllCodec.ResponseParameters resultParameters = SetAddAllCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean removeAll(Collection<?> c) {
        Preconditions.checkNotNull(c);
        Collection dataCollection = CollectionUtil.objectToDataCollection(c, (SerializationService)this.getSerializationService());
        ClientMessage request = SetCompareAndRemoveAllCodec.encodeRequest((String)this.name, (Collection)dataCollection);
        ClientMessage response = this.invokeOnPartition(request);
        SetCompareAndRemoveAllCodec.ResponseParameters resultParameters = SetCompareAndRemoveAllCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean retainAll(Collection<?> c) {
        Preconditions.checkNotNull(c);
        Collection dataCollection = CollectionUtil.objectToDataCollection(c, (SerializationService)this.getSerializationService());
        ClientMessage request = SetCompareAndRetainAllCodec.encodeRequest((String)this.name, (Collection)dataCollection);
        ClientMessage response = this.invokeOnPartition(request);
        SetCompareAndRetainAllCodec.ResponseParameters resultParameters = SetCompareAndRetainAllCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public void clear() {
        ClientMessage request = SetClearCodec.encodeRequest((String)this.name);
        this.invokeOnPartition(request);
    }

    public String addItemListener(ItemListener<E> listener, boolean includeValue) {
        ItemEventHandler eventHandler = new ItemEventHandler(listener);
        return this.registerListener(this.createItemListenerCodec(includeValue), eventHandler);
    }

    private ListenerMessageCodec createItemListenerCodec(final boolean includeValue) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return SetAddListenerCodec.encodeRequest((String)ClientSetProxy.this.name, (boolean)includeValue, (boolean)localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return SetAddListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return SetRemoveListenerCodec.encodeRequest((String)ClientSetProxy.this.name, (String)realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return SetRemoveListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    public boolean removeItemListener(String registrationId) {
        return this.deregisterListener(registrationId);
    }

    private Collection<E> getAll() {
        ClientMessage request = SetGetAllCodec.encodeRequest((String)this.name);
        ClientMessage response = this.invokeOnPartition(request);
        SetGetAllCodec.ResponseParameters resultParameters = SetGetAllCodec.decodeResponse((ClientMessage)response);
        List resultCollection = resultParameters.response;
        SerializationService serializationService = this.getContext().getSerializationService();
        return new UnmodifiableLazyList(resultCollection, serializationService);
    }

    public String toString() {
        return "ISet{name='" + this.name + '\'' + '}';
    }

    private class ItemEventHandler
    extends ListAddListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final ItemListener<E> listener;

        public ItemEventHandler(ItemListener<E> listener) {
            this.listener = listener;
        }

        public void handle(Data dataItem, String uuid, int eventType) {
            SerializationService serializationService = ClientSetProxy.this.getContext().getSerializationService();
            ClientClusterService clusterService = ClientSetProxy.this.getContext().getClusterService();
            Member member = clusterService.getMember(uuid);
            DataAwareItemEvent itemEvent = new DataAwareItemEvent(ClientSetProxy.this.name, ItemEventType.getByType((int)eventType), dataItem, member, serializationService);
            if (eventType == ItemEventType.ADDED.getType()) {
                this.listener.itemAdded((ItemEvent)itemEvent);
            } else {
                this.listener.itemRemoved((ItemEvent)itemEvent);
            }
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

