/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.querycache.subscriber;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ContinuousQueryMadePublishableCodec;
import com.hazelcast.client.impl.protocol.codec.ContinuousQueryPublisherCreateCodec;
import com.hazelcast.client.impl.protocol.codec.ContinuousQueryPublisherCreateWithValueCodec;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.map.impl.querycache.InvokerWrapper;
import com.hazelcast.map.impl.querycache.accumulator.AccumulatorInfo;
import com.hazelcast.map.impl.querycache.subscriber.AbstractQueryCacheEndToEndConstructor;
import com.hazelcast.map.impl.querycache.subscriber.InternalQueryCache;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheRequest;
import com.hazelcast.nio.serialization.Data;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ClientQueryCacheEndToEndConstructor
extends AbstractQueryCacheEndToEndConstructor {
    public ClientQueryCacheEndToEndConstructor(QueryCacheRequest request) {
        super(request);
    }

    public void createPublisherAccumulator(AccumulatorInfo info) throws Exception {
        if (info.isIncludeValue()) {
            this.createPublishAccumulatorWithIncludeValue(info);
        } else {
            this.createPublishAccumulatorWithoutIncludeValue(info);
        }
        if (info.isPopulate()) {
            this.madePublishable(info.getMapName(), info.getCacheName());
            info.setPublishable(true);
        }
    }

    private void createPublishAccumulatorWithIncludeValue(AccumulatorInfo info) {
        Data data = this.context.getSerializationService().toData((Object)info.getPredicate());
        ClientMessage request = ContinuousQueryPublisherCreateWithValueCodec.encodeRequest((String)info.getMapName(), (String)info.getCacheName(), (Data)data, (int)info.getBatchSize(), (int)info.getBufferSize(), (long)info.getDelaySeconds(), (boolean)info.isPopulate(), (boolean)info.isCoalesce());
        InvokerWrapper invokerWrapper = this.context.getInvokerWrapper();
        ClientMessage response = (ClientMessage)invokerWrapper.invoke((Object)request);
        List result = ContinuousQueryPublisherCreateWithValueCodec.decodeResponse((ClientMessage)response).response;
        this.populateWithValues(this.queryCache, result);
    }

    private void createPublishAccumulatorWithoutIncludeValue(AccumulatorInfo info) {
        Data data = this.context.getSerializationService().toData((Object)info.getPredicate());
        ClientMessage request = ContinuousQueryPublisherCreateCodec.encodeRequest((String)info.getMapName(), (String)info.getCacheName(), (Data)data, (int)info.getBatchSize(), (int)info.getBufferSize(), (long)info.getDelaySeconds(), (boolean)info.isPopulate(), (boolean)info.isCoalesce());
        InvokerWrapper invokerWrapper = this.context.getInvokerWrapper();
        ClientMessage response = (ClientMessage)invokerWrapper.invoke((Object)request);
        List result = ContinuousQueryPublisherCreateCodec.decodeResponse((ClientMessage)response).response;
        this.populateWithoutValues(this.queryCache, result);
    }

    private void madePublishable(String mapName, String cacheName) throws Exception {
        ClientMessage request = ContinuousQueryMadePublishableCodec.encodeRequest((String)mapName, (String)cacheName);
        this.context.getInvokerWrapper().invokeOnAllPartitions((Object)request);
    }

    private void populateWithValues(InternalQueryCache queryCache, Collection<Map.Entry<Data, Data>> result) {
        for (Map.Entry<Data, Data> entry : result) {
            queryCache.setInternal((Object)entry.getKey(), (Object)entry.getValue(), false, EntryEventType.ADDED);
        }
    }

    private void populateWithoutValues(InternalQueryCache queryCache, Collection<Data> result) {
        for (Data data : result) {
            queryCache.setInternal((Object)data, null, false, EntryEventType.ADDED);
        }
    }
}

