/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.impl.CallIdSequence;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.AbstractInvocationFuture;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ClientInvocationFuture
extends AbstractInvocationFuture<ClientMessage> {
    private final ClientMessage request;
    private final ClientInvocation invocation;
    private final CallIdSequence callIdSequence;

    public ClientInvocationFuture(ClientInvocation invocation, Executor internalExecutor, ClientMessage request, ILogger logger, CallIdSequence callIdSequence) {
        super(internalExecutor, logger);
        this.request = request;
        this.invocation = invocation;
        this.callIdSequence = callIdSequence;
    }

    protected String invocationToString() {
        return this.request.toString();
    }

    protected void onInterruptDetected() {
        this.complete(new InterruptedException());
    }

    protected TimeoutException newTimeoutException(long timeout, TimeUnit unit) {
        return new TimeoutException();
    }

    protected Throwable unwrap(Throwable throwable) {
        return throwable;
    }

    protected Object resolve(Object value) {
        if (value instanceof Throwable) {
            return new ExecutionException((Throwable)value);
        }
        return value;
    }

    public void andThen(ExecutionCallback<ClientMessage> callback) {
        Preconditions.isNotNull(callback, (String)"callback");
        super.andThen((ExecutionCallback)new InternalDelegatingExecutionCallback(callback));
    }

    protected void onComplete() {
        this.callIdSequence.complete();
    }

    public ClientMessage resolveAndThrowIfException(Object response) throws ExecutionException, InterruptedException {
        if (response instanceof Throwable) {
            ExceptionUtil.fixAsyncStackTrace((Throwable)((Throwable)response), (StackTraceElement[])Thread.currentThread().getStackTrace());
            if (response instanceof ExecutionException) {
                throw (ExecutionException)response;
            }
            if (response instanceof Error) {
                throw (Error)response;
            }
            if (response instanceof InterruptedException) {
                throw (InterruptedException)response;
            }
            if (response instanceof CancellationException) {
                throw (CancellationException)response;
            }
            throw new ExecutionException((Throwable)response);
        }
        return (ClientMessage)response;
    }

    public ClientInvocation getInvocation() {
        return this.invocation;
    }

    class InternalDelegatingExecutionCallback
    implements ExecutionCallback<ClientMessage> {
        private final ExecutionCallback<ClientMessage> callback;

        InternalDelegatingExecutionCallback(ExecutionCallback<ClientMessage> callback) {
            this.callback = callback;
            ClientInvocationFuture.this.callIdSequence.forceNext();
        }

        public void onResponse(ClientMessage message) {
            try {
                this.callback.onResponse((Object)message);
            }
            finally {
                ClientInvocationFuture.this.callIdSequence.complete();
            }
        }

        public void onFailure(Throwable t) {
            try {
                this.callback.onFailure(t);
            }
            finally {
                ClientInvocationFuture.this.callIdSequence.complete();
            }
        }
    }
}

