/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ClientInvocationServiceSupport;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.HazelcastOverloadException;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import java.io.IOException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public class ClientInvocation
implements Runnable {
    public static final long RETRY_WAIT_TIME_IN_SECONDS = 1L;
    private static final int UNASSIGNED_PARTITION = -1;
    private final ClientInvocationFuture clientInvocationFuture;
    private final ILogger logger;
    private final LifecycleService lifecycleService;
    private final ClientInvocationServiceSupport invocationService;
    private final ClientExecutionService executionService;
    private final ClientMessage clientMessage;
    private final Address address;
    private final int partitionId;
    private final Connection connection;
    private volatile ClientConnection sendConnection;
    private boolean bypassHeartbeatCheck;
    private boolean urgent;
    private long retryTimeoutPointInMillis;
    private EventHandler handler;

    protected ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, int partitionId, Address address, Connection connection) {
        this.lifecycleService = client.getLifecycleService();
        this.invocationService = (ClientInvocationServiceSupport)client.getInvocationService();
        this.executionService = client.getClientExecutionService();
        this.clientMessage = clientMessage;
        this.partitionId = partitionId;
        this.address = address;
        this.connection = connection;
        this.retryTimeoutPointInMillis = System.currentTimeMillis() + this.invocationService.getInvocationTimeoutMillis();
        this.logger = this.invocationService.invocationLogger;
        this.clientInvocationFuture = new ClientInvocationFuture(this, client, clientMessage, this.logger);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage) {
        this(client, clientMessage, -1, null, null);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, int partitionId) {
        this(client, clientMessage, partitionId, null, null);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, Address address) {
        this(client, clientMessage, -1, address, null);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, Connection connection) {
        this(client, clientMessage, -1, null, connection);
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public ClientMessage getClientMessage() {
        return this.clientMessage;
    }

    public ClientInvocationFuture invoke() {
        assert (this.clientMessage != null);
        try {
            this.invokeOnSelection();
        }
        catch (Exception e) {
            if (e instanceof HazelcastOverloadException) {
                throw (HazelcastOverloadException)e;
            }
            this.notifyException(e);
        }
        return this.clientInvocationFuture;
    }

    public ClientInvocationFuture invokeUrgent() {
        this.urgent = true;
        return this.invoke();
    }

    private void invokeOnSelection() throws IOException {
        if (this.isBindToSingleConnection()) {
            this.invocationService.invokeOnConnection(this, (ClientConnection)this.connection);
        } else if (this.partitionId != -1) {
            this.invocationService.invokeOnPartitionOwner(this, this.partitionId);
        } else if (this.address != null) {
            this.invocationService.invokeOnTarget(this, this.address);
        } else {
            this.invocationService.invokeOnRandomTarget(this);
        }
    }

    @Override
    public void run() {
        try {
            this.invoke();
        }
        catch (Throwable e) {
            this.clientInvocationFuture.complete(e);
        }
    }

    public void notify(ClientMessage clientMessage) {
        if (clientMessage == null) {
            throw new IllegalArgumentException("response can't be null");
        }
        this.clientInvocationFuture.complete(clientMessage);
    }

    public void notifyException(Throwable exception) {
        if (!this.lifecycleService.isRunning()) {
            this.clientInvocationFuture.complete(new HazelcastClientNotActiveException(exception.getMessage(), exception));
            return;
        }
        if (ClientInvocation.isRetryable(exception) && this.handleRetry()) {
            return;
        }
        if (exception instanceof RetryableHazelcastException && (this.clientMessage.isRetryable() || this.invocationService.isRedoOperation()) && this.handleRetry()) {
            return;
        }
        this.clientInvocationFuture.complete(exception);
    }

    private boolean handleRetry() {
        if (this.isBindToSingleConnection()) {
            return false;
        }
        if (!this.shouldRetry()) {
            return false;
        }
        try {
            this.rescheduleInvocation();
        }
        catch (RejectedExecutionException e) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Retry could not be scheduled ", (Throwable)e);
            }
            this.notifyException(e);
        }
        return true;
    }

    private void rescheduleInvocation() {
        ClientExecutionServiceImpl executionServiceImpl = (ClientExecutionServiceImpl)this.executionService;
        executionServiceImpl.schedule(this, 1L, TimeUnit.SECONDS);
    }

    private boolean shouldRetry() {
        return System.currentTimeMillis() < this.retryTimeoutPointInMillis;
    }

    private boolean isBindToSingleConnection() {
        return this.connection != null;
    }

    public EventHandler getEventHandler() {
        return this.handler;
    }

    public void setEventHandler(EventHandler handler) {
        this.handler = handler;
    }

    public boolean shouldBypassHeartbeatCheck() {
        return this.bypassHeartbeatCheck;
    }

    public boolean isUrgent() {
        return this.urgent;
    }

    public void setBypassHeartbeatCheck(boolean bypassHeartbeatCheck) {
        this.bypassHeartbeatCheck = bypassHeartbeatCheck;
    }

    public void setSendConnection(ClientConnection connection) {
        this.sendConnection = connection;
    }

    public ClientConnection getSendConnectionOrWait() throws InterruptedException {
        while (this.sendConnection == null && !this.clientInvocationFuture.isDone()) {
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
        return this.sendConnection;
    }

    public ClientConnection getSendConnection() {
        return this.sendConnection;
    }

    public static boolean isRetryable(Throwable t) {
        return t instanceof IOException || t instanceof HazelcastInstanceNotActiveException;
    }
}

