/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.ClientLockReferenceIdGenerator;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MultiMapAddEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapAddEntryListenerToKeyCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapClearCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapContainsEntryCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapContainsKeyCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapContainsValueCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapEntrySetCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapForceUnlockCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapGetCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapIsLockedCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapKeySetCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapLockCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapPutCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapRemoveEntryCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapRemoveEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapSizeCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapTryLockCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapUnlockCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapValueCountCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapValuesCodec;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMapEvent;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import com.hazelcast.core.MultiMap;
import com.hazelcast.map.impl.DataAwareEntryEvent;
import com.hazelcast.map.impl.ListenerAdapter;
import com.hazelcast.map.impl.ListenerAdapters;
import com.hazelcast.mapreduce.Collator;
import com.hazelcast.mapreduce.CombinerFactory;
import com.hazelcast.mapreduce.Job;
import com.hazelcast.mapreduce.JobCompletableFuture;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.KeyValueSource;
import com.hazelcast.mapreduce.Mapper;
import com.hazelcast.mapreduce.MappingJob;
import com.hazelcast.mapreduce.ReducerFactory;
import com.hazelcast.mapreduce.ReducingSubmittableJob;
import com.hazelcast.mapreduce.aggregation.Aggregation;
import com.hazelcast.mapreduce.aggregation.Supplier;
import com.hazelcast.monitor.LocalMultiMapStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.UnmodifiableLazyList;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.ThreadUtil;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ClientMultiMapProxy<K, V>
extends ClientProxy
implements MultiMap<K, V> {
    protected static final String NULL_KEY_IS_NOT_ALLOWED = "Null key is not allowed!";
    protected static final String NULL_VALUE_IS_NOT_ALLOWED = "Null value is not allowed!";
    private ClientLockReferenceIdGenerator lockReferenceIdGenerator;

    public ClientMultiMapProxy(String serviceName, String name) {
        super(serviceName, name);
    }

    public boolean put(K key, V value) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        ClientMessage request = MultiMapPutCodec.encodeRequest((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapPutCodec.ResponseParameters resultParameters = MultiMapPutCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public Collection<V> get(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapGetCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapGetCodec.ResponseParameters resultParameters = MultiMapGetCodec.decodeResponse((ClientMessage)response);
        return new UnmodifiableLazyList(resultParameters.response, this.getSerializationService());
    }

    public boolean remove(Object key, Object value) {
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull((Object)value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        ClientMessage request = MultiMapRemoveEntryCodec.encodeRequest((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapRemoveEntryCodec.ResponseParameters resultParameters = MultiMapRemoveEntryCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public Collection<V> remove(Object key) {
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapRemoveCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapRemoveCodec.ResponseParameters resultParameters = MultiMapRemoveCodec.decodeResponse((ClientMessage)response);
        return new UnmodifiableLazyList(resultParameters.response, this.getSerializationService());
    }

    public Set<K> localKeySet() {
        throw new UnsupportedOperationException("Locality for client is ambiguous");
    }

    public Set<K> keySet() {
        ClientMessage request = MultiMapKeySetCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MultiMapKeySetCodec.ResponseParameters resultParameters = MultiMapKeySetCodec.decodeResponse((ClientMessage)response);
        List result = resultParameters.response;
        HashSet keySet = new HashSet(result.size());
        for (Data data : result) {
            Object key = this.toObject(data);
            keySet.add(key);
        }
        return keySet;
    }

    public Collection<V> values() {
        ClientMessage request = MultiMapValuesCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MultiMapValuesCodec.ResponseParameters resultParameters = MultiMapValuesCodec.decodeResponse((ClientMessage)response);
        return new UnmodifiableLazyList(resultParameters.response, this.getSerializationService());
    }

    public Set<Map.Entry<K, V>> entrySet() {
        ClientMessage request = MultiMapEntrySetCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MultiMapEntrySetCodec.ResponseParameters resultParameters = MultiMapEntrySetCodec.decodeResponse((ClientMessage)response);
        HashSet<Map.Entry<K, V>> entrySet = new HashSet<Map.Entry<K, V>>(resultParameters.response.size());
        for (Map.Entry entry : resultParameters.response) {
            Object key = this.toObject(entry.getKey());
            Object value = this.toObject(entry.getValue());
            entrySet.add(new AbstractMap.SimpleEntry(key, value));
        }
        return entrySet;
    }

    public boolean containsKey(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapContainsKeyCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapContainsKeyCodec.ResponseParameters resultParameters = MultiMapContainsKeyCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean containsValue(Object value) {
        Preconditions.checkNotNull((Object)value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyValue = this.toData(value);
        ClientMessage request = MultiMapContainsValueCodec.encodeRequest((String)this.name, (Data)keyValue);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MultiMapContainsValueCodec.ResponseParameters resultParameters = MultiMapContainsValueCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean containsEntry(K key, V value) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        ClientMessage request = MultiMapContainsEntryCodec.encodeRequest((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapContainsEntryCodec.ResponseParameters resultParameters = MultiMapContainsEntryCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public int size() {
        ClientMessage request = MultiMapSizeCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MultiMapSizeCodec.ResponseParameters resultParameters = MultiMapSizeCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public void clear() {
        ClientMessage request = MultiMapClearCodec.encodeRequest((String)this.name);
        this.invoke(request);
    }

    public int valueCount(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapValueCountCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapValueCountCodec.ResponseParameters resultParameters = MultiMapValueCountCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public String addLocalEntryListener(EntryListener<K, V> listener) {
        throw new UnsupportedOperationException("Locality for client is ambiguous");
    }

    public String addEntryListener(EntryListener<K, V> listener, boolean includeValue) {
        Preconditions.isNotNull(listener, (String)"listener");
        EventHandler<ClientMessage> handler = this.createHandler(listener);
        return this.registerListener(this.createEntryListenerCodec(includeValue), handler);
    }

    private ListenerMessageCodec createEntryListenerCodec(final boolean includeValue) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return MultiMapAddEntryListenerCodec.encodeRequest((String)ClientMultiMapProxy.this.name, (boolean)includeValue, (boolean)localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return MultiMapAddEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return MultiMapRemoveEntryListenerCodec.encodeRequest((String)ClientMultiMapProxy.this.name, (String)realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MultiMapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    public boolean removeEntryListener(String registrationId) {
        return this.deregisterListener(registrationId);
    }

    public String addEntryListener(EntryListener<K, V> listener, K key, boolean includeValue) {
        Data keyData = this.toData(key);
        EventHandler<ClientMessage> handler = this.createHandler(listener);
        return this.registerListener(this.createEntryListenerToKeyCodec(includeValue, keyData), handler);
    }

    private ListenerMessageCodec createEntryListenerToKeyCodec(final boolean includeValue, final Data keyData) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return MultiMapAddEntryListenerToKeyCodec.encodeRequest((String)ClientMultiMapProxy.this.name, (Data)keyData, (boolean)includeValue, (boolean)localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return MultiMapAddEntryListenerToKeyCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return MultiMapRemoveEntryListenerCodec.encodeRequest((String)ClientMultiMapProxy.this.name, (String)realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MultiMapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    public void lock(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapLockCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId(), (long)-1L, (long)this.lockReferenceIdGenerator.getNextReferenceId());
        this.invoke(request, keyData);
    }

    public void lock(K key, long leaseTime, TimeUnit timeUnit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkPositive((long)leaseTime, (String)"leaseTime should be positive");
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapLockCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId(), (long)this.getTimeInMillis(leaseTime, timeUnit), (long)this.lockReferenceIdGenerator.getNextReferenceId());
        this.invoke(request, keyData);
    }

    public boolean isLocked(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapIsLockedCodec.encodeRequest((String)this.name, (Data)keyData);
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapIsLockedCodec.ResponseParameters resultParameters = MultiMapIsLockedCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean tryLock(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        try {
            return this.tryLock(key, 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public boolean tryLock(K key, long time, TimeUnit timeunit) throws InterruptedException {
        return this.tryLock(key, time, timeunit, Long.MAX_VALUE, null);
    }

    public boolean tryLock(K key, long time, TimeUnit timeunit, long leaseTime, TimeUnit leaseUnit) throws InterruptedException {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        long timeoutInMillis = this.getTimeInMillis(time, timeunit);
        long leaseTimeInMillis = this.getTimeInMillis(leaseTime, leaseUnit);
        long threadId = ThreadUtil.getThreadId();
        ClientMessage request = MultiMapTryLockCodec.encodeRequest((String)this.name, (Data)keyData, (long)threadId, (long)leaseTimeInMillis, (long)timeoutInMillis, (long)this.lockReferenceIdGenerator.getNextReferenceId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapTryLockCodec.ResponseParameters resultParameters = MultiMapTryLockCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public void unlock(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapUnlockCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId(), (long)this.lockReferenceIdGenerator.getNextReferenceId());
        this.invoke(request, keyData);
    }

    public void forceUnlock(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapForceUnlockCodec.encodeRequest((String)this.name, (Data)keyData, (long)this.lockReferenceIdGenerator.getNextReferenceId());
        this.invoke(request, keyData);
    }

    public LocalMultiMapStats getLocalMultiMapStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation) {
        HazelcastInstance hazelcastInstance = this.getContext().getHazelcastInstance();
        JobTracker jobTracker = hazelcastInstance.getJobTracker("hz::aggregation-multimap-" + this.name);
        return this.aggregate(supplier, aggregation, jobTracker);
    }

    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation, JobTracker jobTracker) {
        try {
            Preconditions.isNotNull((Object)jobTracker, (String)"jobTracker");
            KeyValueSource keyValueSource = KeyValueSource.fromMultiMap((MultiMap)this);
            Job job = jobTracker.newJob(keyValueSource);
            Mapper mapper = aggregation.getMapper(supplier);
            CombinerFactory combinerFactory = aggregation.getCombinerFactory();
            ReducerFactory reducerFactory = aggregation.getReducerFactory();
            Collator collator = aggregation.getCollator();
            MappingJob mappingJob = job.mapper(mapper);
            ReducingSubmittableJob reducingJob = combinerFactory != null ? mappingJob.combiner(combinerFactory).reducer(reducerFactory) : mappingJob.reducer(reducerFactory);
            JobCompletableFuture future = reducingJob.submit(collator);
            return (Result)future.get();
        }
        catch (Exception e) {
            throw new HazelcastException((Throwable)e);
        }
    }

    public String toString() {
        return "MultiMap{name='" + this.name + '\'' + '}';
    }

    @Override
    protected void onDestroy() {
    }

    protected long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.lockReferenceIdGenerator = this.getClient().getLockReferenceIdGenerator();
    }

    private EventHandler<ClientMessage> createHandler(Object listener) {
        ListenerAdapter listenerAdaptor = ListenerAdapters.createListenerAdapter((Object)listener);
        return new ClientMultiMapEventHandler(listenerAdaptor);
    }

    private class ClientMultiMapEventHandler
    extends MultiMapAddEntryListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final ListenerAdapter listenerAdapter;

        public ClientMultiMapEventHandler(ListenerAdapter listenerAdapter) {
            this.listenerAdapter = listenerAdapter;
        }

        public void handle(Data key, Data value, Data oldValue, Data mergingValue, int eventType, String uuid, int numberOfAffectedEntries) {
            Member member = ClientMultiMapProxy.this.getContext().getClusterService().getMember(uuid);
            IMapEvent iMapEvent = this.createIMapEvent(key, value, oldValue, mergingValue, eventType, numberOfAffectedEntries, member);
            this.listenerAdapter.onEvent((Object)iMapEvent);
        }

        private IMapEvent createIMapEvent(Data key, Data value, Data oldValue, Data mergingValue, int eventType, int numberOfAffectedEntries, Member member) {
            EntryEvent iMapEvent;
            EntryEventType entryEventType = EntryEventType.getByType((int)eventType);
            switch (entryEventType) {
                case ADDED: 
                case REMOVED: 
                case UPDATED: 
                case EVICTED: 
                case MERGED: {
                    iMapEvent = this.createEntryEvent(key, value, oldValue, mergingValue, eventType, member);
                    break;
                }
                case EVICT_ALL: 
                case CLEAR_ALL: {
                    iMapEvent = this.createMapEvent(eventType, numberOfAffectedEntries, member);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a known event type " + entryEventType);
                }
            }
            return iMapEvent;
        }

        private MapEvent createMapEvent(int eventType, int numberOfAffectedEntries, Member member) {
            return new MapEvent((Object)ClientMultiMapProxy.this.name, member, eventType, numberOfAffectedEntries);
        }

        private EntryEvent<K, V> createEntryEvent(Data keyData, Data valueData, Data oldValueData, Data mergingValueData, int eventType, Member member) {
            return new DataAwareEntryEvent(member, eventType, ClientMultiMapProxy.this.name, keyData, valueData, oldValueData, mergingValueData, ClientMultiMapProxy.this.getContext().getSerializationService());
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

