/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.CacheStatistics;
import com.hazelcast.cache.impl.CacheProxyUtil;
import com.hazelcast.cache.impl.ICacheInternal;
import com.hazelcast.cache.impl.nearcache.NearCache;
import com.hazelcast.client.cache.impl.AbstractClientInternalCacheProxy;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheGetAllCodec;
import com.hazelcast.client.impl.protocol.codec.CacheGetCodec;
import com.hazelcast.client.impl.protocol.codec.CachePutAllCodec;
import com.hazelcast.client.impl.protocol.codec.CacheSizeCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ExceptionUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.cache.CacheException;
import javax.cache.expiry.ExpiryPolicy;

abstract class AbstractClientCacheProxy<K, V>
extends AbstractClientInternalCacheProxy<K, V>
implements ICacheInternal<K, V> {
    private static ClientMessageDecoder cacheGetResponseDecoder = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)CacheGetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };

    protected AbstractClientCacheProxy(CacheConfig cacheConfig, ClientContext clientContext, HazelcastClientCacheManager cacheManager) {
        super(cacheConfig, clientContext, cacheManager);
    }

    protected Object getFromNearCache(Data keyData, boolean async) {
        Object cached;
        Object object = cached = this.nearCache != null ? this.nearCache.get((Object)keyData) : null;
        if (cached != null && NearCache.NULL_OBJECT != cached) {
            return !async ? cached : this.createCompletedFuture(cached);
        }
        return null;
    }

    protected Object getInternal(K key, ExpiryPolicy expiryPolicy, boolean async) {
        ClientInvocationFuture future;
        final long start = System.nanoTime();
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        final Data keyData = this.toData(key);
        Object cached = this.getFromNearCache(keyData, async);
        if (cached != null) {
            return cached;
        }
        Data expiryPolicyData = this.toData(expiryPolicy);
        ClientMessage request = CacheGetCodec.encodeRequest((String)this.nameWithPrefix, (Data)keyData, (Data)expiryPolicyData);
        try {
            int partitionId = this.clientContext.getPartitionService().getPartitionId(key);
            HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance();
            ClientInvocation clientInvocation = new ClientInvocation(client, request, partitionId);
            future = clientInvocation.invoke();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        SerializationService serializationService = this.clientContext.getSerializationService();
        ClientDelegatingFuture delegatingFuture = new ClientDelegatingFuture(future, serializationService, cacheGetResponseDecoder);
        if (async) {
            if (this.nearCache != null) {
                delegatingFuture.andThenInternal(new ExecutionCallback<Data>(){

                    public void onResponse(Data valueData) {
                        AbstractClientCacheProxy.this.storeInNearCache(keyData, valueData, null);
                        if (AbstractClientCacheProxy.this.statisticsEnabled) {
                            AbstractClientCacheProxy.this.handleStatisticsOnGet(start, valueData);
                        }
                    }

                    public void onFailure(Throwable t) {
                    }
                });
            }
            return delegatingFuture;
        }
        try {
            Object value = this.toObject(delegatingFuture.get());
            if (this.nearCache != null) {
                this.storeInNearCache(keyData, (Data)delegatingFuture.getResponse(), value);
            }
            if (this.statisticsEnabled) {
                this.handleStatisticsOnGet(start, value);
            }
            return value;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
    }

    protected void handleStatisticsOnGet(long start, Object response) {
        if (response == null) {
            this.statistics.increaseCacheMisses();
        } else {
            this.statistics.increaseCacheHits();
        }
        this.statistics.addGetTimeNanos(System.nanoTime() - start);
    }

    public ICompletableFuture<V> getAsync(K key) {
        return this.getAsync(key, null);
    }

    public ICompletableFuture<V> getAsync(K key, ExpiryPolicy expiryPolicy) {
        return (ICompletableFuture)this.getInternal(key, expiryPolicy, true);
    }

    public ICompletableFuture<Void> putAsync(K key, V value) {
        return this.putAsync(key, value, null);
    }

    public ICompletableFuture<Void> putAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return (ICompletableFuture)this.putInternal(key, value, expiryPolicy, false, true, true);
    }

    public ICompletableFuture<Boolean> putIfAbsentAsync(K key, V value) {
        return this.putIfAbsentAsyncInternal(key, value, null, false, true);
    }

    public ICompletableFuture<Boolean> putIfAbsentAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.putIfAbsentAsyncInternal(key, value, expiryPolicy, false, true);
    }

    public ICompletableFuture<V> getAndPutAsync(K key, V value) {
        return this.getAndPutAsync(key, value, null);
    }

    public ICompletableFuture<V> getAndPutAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return (ICompletableFuture)this.putInternal(key, value, expiryPolicy, true, false, true);
    }

    public ICompletableFuture<Boolean> removeAsync(K key) {
        return this.removeAsyncInternal(key, null, false, false, true);
    }

    public ICompletableFuture<Boolean> removeAsync(K key, V oldValue) {
        return this.removeAsyncInternal(key, oldValue, true, false, true);
    }

    public ICompletableFuture<V> getAndRemoveAsync(K key) {
        return this.getAndRemoveAsyncInternal(key, false, true);
    }

    public ICompletableFuture<Boolean> replaceAsync(K key, V value) {
        return this.replaceAsyncInternal(key, null, value, null, false, false, true);
    }

    public ICompletableFuture<Boolean> replaceAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.replaceAsyncInternal(key, null, value, expiryPolicy, false, false, true);
    }

    public ICompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.replaceAsyncInternal(key, oldValue, newValue, null, true, false, true);
    }

    public ICompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy) {
        return this.replaceAsyncInternal(key, oldValue, newValue, expiryPolicy, true, false, true);
    }

    public ICompletableFuture<V> getAndReplaceAsync(K key, V value) {
        return this.replaceAndGetAsyncInternal(key, null, value, null, false, false, true);
    }

    public ICompletableFuture<V> getAndReplaceAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.replaceAndGetAsyncInternal(key, null, value, expiryPolicy, false, false, true);
    }

    public V get(K key, ExpiryPolicy expiryPolicy) {
        return (V)this.getInternal(key, expiryPolicy, false);
    }

    public Map<K, V> getAll(Set<? extends K> keys, ExpiryPolicy expiryPolicy) {
        long start = System.nanoTime();
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys);
        if (keys.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashSet<Data> keySet = new HashSet<Data>(keys.size());
        for (K key : keys) {
            Data k = this.toData(key);
            keySet.add(k);
        }
        Map result = this.getAllFromNearCache(keySet);
        if (keySet.isEmpty()) {
            return result;
        }
        Data expiryPolicyData = this.toData(expiryPolicy);
        ClientMessage request = CacheGetAllCodec.encodeRequest((String)this.nameWithPrefix, keySet, (Data)expiryPolicyData);
        ClientMessage responseMessage = this.invoke(request);
        Set entrySet = CacheGetAllCodec.decodeResponse((ClientMessage)responseMessage).entrySet;
        for (Map.Entry dataEntry : entrySet) {
            Data keyData = (Data)dataEntry.getKey();
            Data valueData = (Data)dataEntry.getValue();
            Object key = this.toObject(keyData);
            Object value = this.toObject(valueData);
            result.put(key, value);
            this.storeInNearCache(keyData, valueData, value);
        }
        if (this.statisticsEnabled) {
            this.statistics.increaseCacheHits(entrySet.size());
            this.statistics.addGetTimeNanos(System.nanoTime() - start);
        }
        return result;
    }

    private Map<K, V> getAllFromNearCache(Set<Data> keySet) {
        HashMap result = new HashMap();
        if (this.nearCache != null) {
            Iterator<Data> iterator = keySet.iterator();
            while (iterator.hasNext()) {
                Data key = iterator.next();
                Object cached = this.nearCache.get((Object)key);
                if (cached == null || NearCache.NULL_OBJECT.equals(cached)) continue;
                result.put(this.toObject(key), cached);
                iterator.remove();
            }
        }
        return result;
    }

    public void put(K key, V value, ExpiryPolicy expiryPolicy) {
        this.putInternal(key, value, expiryPolicy, false, true, false);
    }

    public V getAndPut(K key, V value, ExpiryPolicy expiryPolicy) {
        return (V)this.putInternal(key, value, expiryPolicy, true, true, false);
    }

    public void putAll(Map<? extends K, ? extends V> map, ExpiryPolicy expiryPolicy) {
        long start = System.nanoTime();
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(map);
        ClientPartitionService partitionService = this.clientContext.getPartitionService();
        int partitionCount = partitionService.getPartitionCount();
        try {
            List<Map.Entry<Data, Data>>[] entriesPerPartition = this.groupDataToPartitions(map, partitionService, partitionCount);
            this.putToAllPartitionsAndWaitForCompletion(entriesPerPartition, expiryPolicy, start);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private List<Map.Entry<Data, Data>>[] groupDataToPartitions(Map<? extends K, ? extends V> map, ClientPartitionService partitionService, int partitionCount) {
        List[] entriesPerPartition = new List[partitionCount];
        SerializationService serializationService = this.clientContext.getSerializationService();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            CacheProxyUtil.validateNotNull(key, value);
            Data keyData = serializationService.toData(key);
            Data valueData = serializationService.toData(value);
            int partitionId = partitionService.getPartitionId(keyData);
            ArrayList<AbstractMap.SimpleImmutableEntry<Data, Data>> entries = entriesPerPartition[partitionId];
            if (entries == null) {
                entriesPerPartition[partitionId] = entries = new ArrayList<AbstractMap.SimpleImmutableEntry<Data, Data>>();
            }
            entries.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(keyData, valueData));
        }
        return entriesPerPartition;
    }

    private void putToAllPartitionsAndWaitForCompletion(List<Map.Entry<Data, Data>>[] entriesPerPartition, ExpiryPolicy expiryPolicy, long start) throws ExecutionException, InterruptedException {
        Data expiryPolicyData = this.toData(expiryPolicy);
        ArrayList<FutureEntriesTuple> futureEntriesTuples = new ArrayList<FutureEntriesTuple>(entriesPerPartition.length);
        for (int partitionId = 0; partitionId < entriesPerPartition.length; ++partitionId) {
            List<Map.Entry<Data, Data>> entries = entriesPerPartition[partitionId];
            if (entries == null) continue;
            int completionId = this.nextCompletionId();
            ClientMessage request = CachePutAllCodec.encodeRequest((String)this.nameWithPrefix, entries, (Data)expiryPolicyData, (int)completionId);
            ClientInvocationFuture f = this.invoke(request, partitionId, completionId);
            futureEntriesTuples.add(new FutureEntriesTuple((Future)((Object)f), entries));
            if (this.nearCache == null) continue;
            if (this.cacheOnUpdate) {
                for (Map.Entry<Data, Data> entry : entries) {
                    this.storeInNearCache(entry.getKey(), entry.getValue(), null);
                }
                continue;
            }
            for (Map.Entry<Data, Data> entry : entries) {
                this.invalidateNearCache(entry.getKey());
            }
        }
        this.waitResponseFromAllPartitionsForPutAll(futureEntriesTuples, start);
    }

    private void waitResponseFromAllPartitionsForPutAll(List<FutureEntriesTuple> futureEntriesTuples, long start) {
        Throwable error = null;
        for (FutureEntriesTuple tuple : futureEntriesTuples) {
            Future future = tuple.future;
            List entries = tuple.entries;
            try {
                future.get();
                if (this.nearCache != null) {
                    this.handleNearCacheOnPutAll(entries, !this.cacheOnUpdate);
                }
                if (!this.statisticsEnabled) continue;
                this.statistics.increaseCachePuts(entries.size());
            }
            catch (Throwable t) {
                if (this.nearCache != null) {
                    this.handleNearCacheOnPutAll(entries, true);
                }
                this.logger.finest("Error occurred while putting entries as batch!", t);
                if (error != null) continue;
                error = t;
            }
        }
        if (this.statisticsEnabled) {
            this.statistics.addPutTimeNanos(System.nanoTime() - start);
        }
        if (error != null) {
            ExceptionUtil.rethrow(error);
        }
    }

    private void handleNearCacheOnPutAll(List<Map.Entry<Data, Data>> entries, boolean invalidate) {
    }

    public boolean putIfAbsent(K key, V value, ExpiryPolicy expiryPolicy) {
        long start = System.nanoTime();
        ICompletableFuture<Boolean> f = this.putIfAbsentAsyncInternal(key, value, expiryPolicy, true, false);
        try {
            boolean saved = (Boolean)f.get();
            if (this.statisticsEnabled) {
                this.handleStatisticsOnPutIfAbsent(start, saved);
            }
            return saved;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
    }

    public boolean replace(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy) {
        long start = System.nanoTime();
        ICompletableFuture f = this.replaceAsyncInternal(key, oldValue, newValue, expiryPolicy, true, true, false);
        try {
            boolean replaced = (Boolean)f.get();
            if (this.statisticsEnabled) {
                this.handleStatisticsOnReplace(false, start, replaced);
            }
            return replaced;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
    }

    public boolean replace(K key, V value, ExpiryPolicy expiryPolicy) {
        long start = System.nanoTime();
        ICompletableFuture f = this.replaceAsyncInternal(key, null, value, expiryPolicy, false, true, false);
        try {
            boolean replaced = (Boolean)f.get();
            if (this.statisticsEnabled) {
                this.handleStatisticsOnReplace(false, start, replaced);
            }
            return replaced;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
    }

    public V getAndReplace(K key, V value, ExpiryPolicy expiryPolicy) {
        long start = System.nanoTime();
        ICompletableFuture f = this.replaceAndGetAsyncInternal(key, null, value, expiryPolicy, false, true, false);
        try {
            Object oldValue = f.get();
            if (this.statisticsEnabled) {
                this.handleStatisticsOnReplace(true, start, oldValue);
            }
            return oldValue;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
    }

    public int size() {
        this.ensureOpen();
        try {
            ClientMessage request = CacheSizeCodec.encodeRequest((String)this.nameWithPrefix);
            ClientMessage resultMessage = this.invoke(request);
            return CacheSizeCodec.decodeResponse((ClientMessage)resultMessage).response;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)t, CacheException.class);
        }
    }

    public CacheStatistics getLocalCacheStatistics() {
        return this.statistics;
    }

    private static final class FutureEntriesTuple {
        private Future future;
        private List<Map.Entry<Data, Data>> entries;

        private FutureEntriesTuple(Future future, List<Map.Entry<Data, Data>> entries) {
            this.future = future;
            this.entries = entries;
        }
    }
}

