/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.ClientImpl;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.impl.ClusterListenerSupport;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.core.Client;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.InitialMembershipEvent;
import com.hazelcast.core.InitialMembershipListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.instance.AbstractMember;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.UuidUtil;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public class ClientClusterServiceImpl
extends ClusterListenerSupport {
    private static final ILogger LOGGER = Logger.getLogger(ClientClusterService.class);
    private final AtomicReference<Map<Address, Member>> membersRef = new AtomicReference();
    private final ConcurrentMap<String, MembershipListener> listeners = new ConcurrentHashMap<String, MembershipListener>();

    public ClientClusterServiceImpl(HazelcastClientInstanceImpl client, Collection<AddressProvider> addressProviders) {
        super(client, addressProviders);
        ClientConfig clientConfig = this.getClientConfig();
        List<ListenerConfig> listenerConfigs = client.getClientConfig().getListenerConfigs();
        for (ListenerConfig listenerConfig : listenerConfigs) {
            EventListener listener = listenerConfig.getImplementation();
            if (listener == null) {
                try {
                    listener = (EventListener)ClassLoaderUtil.newInstance((ClassLoader)clientConfig.getClassLoader(), (String)listenerConfig.getClassName());
                }
                catch (Exception e) {
                    LOGGER.severe((Throwable)e);
                }
            }
            if (!(listener instanceof MembershipListener)) continue;
            this.addMembershipListenerWithoutInit((MembershipListener)listener);
        }
    }

    @Override
    public Member getMember(Address address) {
        Map<Address, Member> members = this.membersRef.get();
        return members != null ? members.get(address) : null;
    }

    @Override
    public Member getMember(String uuid) {
        Collection<Member> memberList = this.getMemberList();
        for (Member member : memberList) {
            if (!uuid.equals(member.getUuid())) continue;
            return member;
        }
        return null;
    }

    @Override
    public Collection<Member> getMemberList() {
        Map<Address, Member> members = this.membersRef.get();
        return members != null ? members.values() : Collections.emptySet();
    }

    @Override
    public Address getMasterAddress() {
        Collection<Member> memberList = this.getMemberList();
        Member member = memberList.iterator().next();
        return !memberList.isEmpty() ? ((AbstractMember)member).getAddress() : null;
    }

    @Override
    public int getSize() {
        return this.getMemberList().size();
    }

    @Override
    public long getClusterTime() {
        return Clock.currentTimeMillis();
    }

    @Override
    public Client getLocalClient() {
        Address address = this.getOwnerConnectionAddress();
        ClientConnectionManager cm = this.client.getConnectionManager();
        ClientConnection connection = (ClientConnection)cm.getConnection(address);
        InetSocketAddress inetSocketAddress = connection != null ? connection.getLocalSocketAddress() : null;
        String uuid = this.getPrincipal().getUuid();
        return new ClientImpl(uuid, inetSocketAddress);
    }

    SerializationService getSerializationService() {
        return this.client.getSerializationService();
    }

    @Override
    public String addMembershipListener(MembershipListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener can't be null");
        }
        String id = UuidUtil.buildRandomUuidString();
        this.listeners.put(id, listener);
        if (listener instanceof InitialMembershipListener) {
            Cluster cluster = this.client.getCluster();
            ((InitialMembershipListener)listener).init(new InitialMembershipEvent(cluster, cluster.getMembers()));
        }
        return id;
    }

    private String addMembershipListenerWithoutInit(MembershipListener listener) {
        String id = UUID.randomUUID().toString();
        this.listeners.put(id, listener);
        return id;
    }

    private void initMembershipListener() {
        for (MembershipListener membershipListener : this.listeners.values()) {
            if (!(membershipListener instanceof InitialMembershipListener)) continue;
            Cluster cluster = this.client.getCluster();
            InitialMembershipEvent event = new InitialMembershipEvent(cluster, cluster.getMembers());
            ((InitialMembershipListener)membershipListener).init(event);
        }
    }

    @Override
    public boolean removeMembershipListener(String registrationId) {
        if (registrationId == null) {
            throw new NullPointerException("registrationId can't be null");
        }
        return this.listeners.remove(registrationId) != null;
    }

    public void start() throws Exception {
        this.init();
        this.connectToCluster();
        this.initMembershipListener();
    }

    private ClientConfig getClientConfig() {
        return this.client.getClientConfig();
    }

    String membersString() {
        StringBuilder sb = new StringBuilder("\n\nMembers [");
        Collection<Member> members = this.getMemberList();
        sb.append(members != null ? members.size() : 0);
        sb.append("] {");
        if (members != null) {
            for (Member member : members) {
                sb.append("\n\t").append(member);
            }
        }
        sb.append("\n}\n");
        return sb.toString();
    }

    void fireMembershipEvent(final MembershipEvent event) {
        ClientExecutionService clientExecutionService = this.client.getClientExecutionService();
        clientExecutionService.execute(new Runnable(){

            @Override
            public void run() {
                for (MembershipListener listener : ClientClusterServiceImpl.this.listeners.values()) {
                    if (event.getEventType() == 1) {
                        listener.memberAdded(event);
                        continue;
                    }
                    listener.memberRemoved(event);
                }
            }
        });
    }

    void fireMemberAttributeEvent(final MemberAttributeEvent event) {
        ClientExecutionService clientExecutionService = this.client.getClientExecutionService();
        clientExecutionService.execute(new Runnable(){

            @Override
            public void run() {
                for (MembershipListener listener : ClientClusterServiceImpl.this.listeners.values()) {
                    listener.memberAttributeChanged(event);
                }
            }
        });
    }

    Map<Address, Member> getMembersRef() {
        return this.membersRef.get();
    }

    void setMembersRef(Map<Address, Member> map) {
        this.membersRef.set(map);
    }
}

