/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.BaseClientRemoveListenerRequest;
import com.hazelcast.client.impl.client.ClientDestroyRequest;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.util.ExceptionUtil;

public abstract class ClientProxy
implements DistributedObject {
    private final String serviceName;
    private final String objectName;
    private volatile ClientContext context;

    protected ClientProxy(String serviceName, String objectName) {
        this.serviceName = serviceName;
        this.objectName = objectName;
    }

    protected final String listen(ClientRequest registrationRequest, Object partitionKey, EventHandler handler) {
        return this.context.getListenerService().startListening(registrationRequest, partitionKey, handler);
    }

    protected final String listen(ClientRequest registrationRequest, EventHandler handler) {
        return this.context.getListenerService().startListening(registrationRequest, null, handler);
    }

    protected final boolean stopListening(BaseClientRemoveListenerRequest request, String registrationId) {
        return this.context.getListenerService().stopListening(request, registrationId);
    }

    protected final ClientContext getContext() {
        return this.context;
    }

    protected final HazelcastClientInstanceImpl getClient() {
        return (HazelcastClientInstanceImpl)this.context.getHazelcastInstance();
    }

    protected final void setContext(ClientContext context) {
        this.context = context;
    }

    @Deprecated
    public final Object getId() {
        return this.objectName;
    }

    public final String getName() {
        return this.objectName;
    }

    public String getPartitionKey() {
        return StringPartitioningStrategy.getPartitionKey((String)this.getName());
    }

    public final String getServiceName() {
        return this.serviceName;
    }

    public final void destroy() {
        this.onDestroy();
        ClientDestroyRequest request = new ClientDestroyRequest(this.objectName, this.getServiceName());
        this.context.removeProxy(this);
        try {
            new ClientInvocation(this.getClient(), (ClientRequest)request).invoke().get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected void onInitialize() {
    }

    protected void onDestroy() {
    }

    protected void onShutdown() {
    }

    protected <T> T invoke(ClientRequest req, Object key) {
        try {
            int partitionId = this.context.getPartitionService().getPartitionId(key);
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), req, partitionId).invoke();
            Object result = future.get();
            return this.toObject(result);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected <T> T invokeInterruptibly(ClientRequest req, Object key) throws InterruptedException {
        try {
            int partitionId = this.context.getPartitionService().getPartitionId(key);
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), req, partitionId).invoke();
            Object result = future.get();
            return this.toObject(result);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrowAllowInterrupted((Throwable)e);
        }
    }

    protected <T> T invoke(ClientRequest req) {
        try {
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), req).invoke();
            Object result = future.get();
            return this.toObject(result);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected <T> T invoke(ClientRequest req, Address address) {
        try {
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), req, address).invoke();
            Object result = future.get();
            return this.toObject(result);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected Data toData(Object o) {
        return this.getContext().getSerializationService().toData(o);
    }

    protected <T> T toObject(Object data) {
        return (T)this.getContext().getSerializationService().toObject(data);
    }

    protected void throwExceptionIfNull(Object o) {
        if (o == null) {
            throw new NullPointerException("Object is null");
        }
    }

    private String getInstanceName() {
        ClientContext ctx = this.context;
        if (ctx != null) {
            HazelcastInstance instance = ctx.getHazelcastInstance();
            return instance.getName();
        }
        return "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientProxy that = (ClientProxy)o;
        String instanceName = this.getInstanceName();
        if (!instanceName.equals(that.getInstanceName())) {
            return false;
        }
        if (!this.objectName.equals(that.objectName)) {
            return false;
        }
        return this.serviceName.equals(that.serviceName);
    }

    public int hashCode() {
        String instanceName = this.getInstanceName();
        int result = instanceName.hashCode();
        result = 31 * result + this.serviceName.hashCode();
        result = 31 * result + this.objectName.hashCode();
        return result;
    }
}

