/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.impl.AbstractHazelcastCacheManager;
import com.hazelcast.cache.impl.ICacheInternal;
import com.hazelcast.cache.impl.client.CacheCreateConfigRequest;
import com.hazelcast.cache.impl.client.CacheGetConfigRequest;
import com.hazelcast.cache.impl.client.CacheManagementConfigRequest;
import com.hazelcast.cache.impl.nearcache.NearCacheManager;
import com.hazelcast.client.cache.impl.ClientCacheDistributedObject;
import com.hazelcast.client.cache.impl.ClientCacheProxy;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.instance.AbstractMember;
import com.hazelcast.nio.Address;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.FutureUtil;
import com.hazelcast.util.Preconditions;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.cache.spi.CachingProvider;

public final class HazelcastClientCacheManager
extends AbstractHazelcastCacheManager {
    private final ClientContext clientContext;
    private final ConcurrentMap<String, CacheConfig> configs = new ConcurrentHashMap<String, CacheConfig>();

    public HazelcastClientCacheManager(HazelcastClientCachingProvider cachingProvider, HazelcastInstance hazelcastInstance, URI uri, ClassLoader classLoader, Properties properties) {
        super((CachingProvider)cachingProvider, hazelcastInstance, uri, classLoader, properties);
        ClientCacheDistributedObject setupRef = (ClientCacheDistributedObject)hazelcastInstance.getDistributedObject("hz:impl:cacheService", "setupRef");
        this.clientContext = setupRef.getClientContext();
    }

    public void enableManagement(String cacheName, boolean enabled) {
        this.enableStatisticManagementOnNodes(cacheName, false, enabled);
    }

    public void enableStatistics(String cacheName, boolean enabled) {
        this.enableStatisticManagementOnNodes(cacheName, true, enabled);
    }

    private void enableStatisticManagementOnNodes(String cacheName, boolean statOrMan, boolean enabled) {
        this.checkIfManagerNotClosed();
        Preconditions.checkNotNull((Object)cacheName, (String)"cacheName cannot be null");
        Collection<Member> members = this.clientContext.getClusterService().getMemberList();
        ArrayList<ClientInvocationFuture> futures = new ArrayList<ClientInvocationFuture>();
        HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance();
        for (Member member : members) {
            try {
                Address address = ((AbstractMember)member).getAddress();
                CacheManagementConfigRequest request = new CacheManagementConfigRequest(this.getCacheNameWithPrefix(cacheName), statOrMan, enabled, address);
                ClientInvocation clientInvocation = new ClientInvocation(client, (ClientRequest)request, address);
                ClientInvocationFuture future = clientInvocation.invoke();
                futures.add(future);
            }
            catch (Exception e) {
                ExceptionUtil.sneakyThrow((Throwable)e);
            }
        }
        FutureUtil.waitWithDeadline(futures, (long)60L, (TimeUnit)TimeUnit.SECONDS);
    }

    protected <K, V> CacheConfig<K, V> getCacheConfigLocal(String cacheName) {
        return (CacheConfig)this.configs.get(cacheName);
    }

    protected <K, V> void addCacheConfigIfAbsent(CacheConfig<K, V> cacheConfig) {
        this.configs.putIfAbsent(cacheConfig.getNameWithPrefix(), cacheConfig);
    }

    protected void removeCacheConfigFromLocal(String cacheName) {
        this.configs.remove(cacheName);
    }

    protected <K, V> CacheConfig<K, V> getCacheConfigFromPartition(String cacheName, String simpleCacheName) {
        CacheGetConfigRequest request = new CacheGetConfigRequest(cacheName, simpleCacheName, InMemoryFormat.BINARY);
        HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance();
        try {
            int partitionId = this.clientContext.getPartitionService().getPartitionId(cacheName);
            ClientInvocation clientInvocation = new ClientInvocation(client, (ClientRequest)request, partitionId);
            ClientInvocationFuture future = clientInvocation.invoke();
            return (CacheConfig)this.clientContext.getSerializationService().toObject(future.get());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected <K, V> CacheConfig<K, V> createConfigOnPartition(CacheConfig<K, V> cacheConfig) {
        HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance();
        try {
            int partitionId = this.clientContext.getPartitionService().getPartitionId(cacheConfig.getNameWithPrefix());
            CacheCreateConfigRequest request = new CacheCreateConfigRequest(cacheConfig, false, false, partitionId);
            ClientInvocation clientInvocation = new ClientInvocation(client, (ClientRequest)request, partitionId);
            ClientInvocationFuture future = clientInvocation.invoke();
            return (CacheConfig)this.clientContext.getSerializationService().toObject(future.get());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected <K, V> ICacheInternal<K, V> createCacheProxy(CacheConfig<K, V> cacheConfig) {
        return new ClientCacheProxy<K, V>(cacheConfig, this.clientContext, this);
    }

    protected <K, V> CacheConfig<K, V> findConfig(String cacheName, String simpleCacheName, boolean createAlsoOnOthers, boolean syncCreate) {
        CacheConfig<K, V> config = (CacheConfig<K, V>)this.configs.get(cacheName);
        if (config == null && (config = this.getCacheConfigFromPartition(cacheName, simpleCacheName)) != null) {
            this.createConfig(cacheName, config, createAlsoOnOthers, syncCreate);
        }
        return config;
    }

    protected <K, V> CacheConfig<K, V> createConfig(String cacheName, CacheConfig<K, V> config, boolean createAlsoOnOthers, boolean syncCreate) {
        CacheConfig currentCacheConfig = (CacheConfig)this.configs.get(cacheName);
        HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance();
        try {
            int partitionId = this.clientContext.getPartitionService().getPartitionId(config.getNameWithPrefix());
            CacheCreateConfigRequest request = new CacheCreateConfigRequest(config, createAlsoOnOthers, false, partitionId);
            ClientInvocation clientInvocation = new ClientInvocation(client, (ClientRequest)request, partitionId);
            ClientInvocationFuture future = clientInvocation.invoke();
            if (syncCreate) {
                return (CacheConfig)this.clientContext.getSerializationService().toObject(future.get());
            }
            return currentCacheConfig;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        if (HazelcastClientCacheManager.class.isAssignableFrom(clazz)) {
            return (T)((Object)this);
        }
        throw new IllegalArgumentException();
    }

    protected void postClose() {
        if (this.properties.getProperty("hazelcast.config.location") != null) {
            this.hazelcastInstance.shutdown();
        }
    }

    public NearCacheManager getNearCacheManager() {
        if (this.hazelcastInstance instanceof HazelcastClientInstanceImpl) {
            return ((HazelcastClientInstanceImpl)this.hazelcastInstance).getNearCacheManager();
        }
        if (this.hazelcastInstance instanceof HazelcastClientProxy) {
            HazelcastClientInstanceImpl clientInstance = ((HazelcastClientProxy)this.hazelcastInstance).client;
            if (clientInstance != null) {
                return clientInstance.getNearCacheManager();
            }
            return null;
        }
        return null;
    }
}

