/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.Member;
import com.hazelcast.core.Partition;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.client.GetPartitionsRequest;
import com.hazelcast.partition.client.PartitionsResponse;
import com.hazelcast.util.EmptyStatement;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ClientPartitionServiceImpl
implements ClientPartitionService {
    private static final ILogger LOGGER = Logger.getLogger(ClientPartitionService.class);
    private static final long PERIOD = 10L;
    private static final long INITIAL_DELAY = 10L;
    private static final int PARTITION_WAIT_TIME = 1000;
    private final HazelcastClientInstanceImpl client;
    private final ConcurrentHashMap<Integer, Address> partitions = new ConcurrentHashMap(271, 0.75f, 1);
    private final AtomicBoolean updating = new AtomicBoolean(false);
    private volatile int partitionCount;

    public ClientPartitionServiceImpl(HazelcastClientInstanceImpl client) {
        this.client = client;
    }

    public void start() {
        ClientExecutionService clientExecutionService = this.client.getClientExecutionService();
        clientExecutionService.scheduleWithFixedDelay(new RefreshTask(), 10L, 10L, TimeUnit.SECONDS);
    }

    public void refreshPartitions() {
        ClientExecutionServiceImpl executionService = (ClientExecutionServiceImpl)this.client.getClientExecutionService();
        try {
            executionService.executeInternal(new RefreshTask());
        }
        catch (RejectedExecutionException ignored) {
            EmptyStatement.ignore((Throwable)ignored);
        }
    }

    private void getPartitionsBlocking() {
        while (!this.getPartitions() && this.client.getConnectionManager().isAlive()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean getPartitions() {
        ClientClusterService clusterService = this.client.getClientClusterService();
        Address master = clusterService.getMasterAddress();
        PartitionsResponse response = this.getPartitionsFrom(master);
        if (response != null) {
            this.processPartitionResponse(response);
            return true;
        }
        return false;
    }

    private PartitionsResponse getPartitionsFrom(Address address) {
        try {
            GetPartitionsRequest request = new GetPartitionsRequest();
            ClientInvocationFuture future = new ClientInvocation(this.client, (ClientRequest)request, address).invoke();
            return (PartitionsResponse)this.client.getSerializationService().toObject(future.get());
        }
        catch (Exception e) {
            if (this.client.getLifecycleService().isRunning()) {
                LOGGER.severe("Error while fetching cluster partition table!", (Throwable)e);
            }
            return null;
        }
    }

    private void processPartitionResponse(PartitionsResponse response) {
        Address[] members = response.getMembers();
        int[] ownerIndexes = response.getOwnerIndexes();
        if (this.partitionCount == 0) {
            this.partitionCount = ownerIndexes.length;
        }
        for (int partitionId = 0; partitionId < this.partitionCount; ++partitionId) {
            int ownerIndex = ownerIndexes[partitionId];
            if (ownerIndex <= -1) continue;
            this.partitions.put(partitionId, members[ownerIndex]);
        }
    }

    public void stop() {
        this.partitions.clear();
    }

    @Override
    public Address getPartitionOwner(int partitionId) {
        Address address = this.partitions.get(partitionId);
        if (address == null) {
            this.getPartitionsBlocking();
        }
        return this.partitions.get(partitionId);
    }

    @Override
    public int getPartitionId(Data key) {
        int pc = this.getPartitionCount();
        if (pc <= 0) {
            return 0;
        }
        int hash = key.getPartitionHash();
        return hash == Integer.MIN_VALUE ? 0 : Math.abs(hash) % pc;
    }

    @Override
    public int getPartitionId(Object key) {
        Data data = this.client.getSerializationService().toData(key);
        return this.getPartitionId(data);
    }

    @Override
    public int getPartitionCount() {
        if (this.partitionCount == 0) {
            this.getPartitionsBlocking();
        }
        return this.partitionCount;
    }

    @Override
    public Partition getPartition(int partitionId) {
        return new PartitionImpl(partitionId);
    }

    private class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!ClientPartitionServiceImpl.this.updating.compareAndSet(false, true)) {
                return;
            }
            try {
                ClientPartitionServiceImpl.this.getPartitions();
            }
            catch (HazelcastInstanceNotActiveException ignored) {
                EmptyStatement.ignore((Throwable)ignored);
            }
            finally {
                ClientPartitionServiceImpl.this.updating.set(false);
            }
        }
    }

    private final class PartitionImpl
    implements Partition {
        private final int partitionId;

        private PartitionImpl(int partitionId) {
            this.partitionId = partitionId;
        }

        public int getPartitionId() {
            return this.partitionId;
        }

        public Member getOwner() {
            Address owner = ClientPartitionServiceImpl.this.getPartitionOwner(this.partitionId);
            if (owner != null) {
                return ClientPartitionServiceImpl.this.client.getClientClusterService().getMember(owner);
            }
            return null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PartitionImpl{");
            sb.append("partitionId=").append(this.partitionId);
            sb.append('}');
            return sb.toString();
        }
    }
}

