/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.impl.CacheClearResponse;
import com.hazelcast.cache.impl.CacheEventListenerAdaptor;
import com.hazelcast.cache.impl.CacheProxyUtil;
import com.hazelcast.cache.impl.CacheSyncListenerCompleter;
import com.hazelcast.cache.impl.client.AbstractCacheRequest;
import com.hazelcast.cache.impl.client.CacheAddInvalidationListenerRequest;
import com.hazelcast.cache.impl.client.CacheClearRequest;
import com.hazelcast.cache.impl.client.CacheGetAndRemoveRequest;
import com.hazelcast.cache.impl.client.CacheGetAndReplaceRequest;
import com.hazelcast.cache.impl.client.CacheInvalidationMessage;
import com.hazelcast.cache.impl.client.CachePutIfAbsentRequest;
import com.hazelcast.cache.impl.client.CachePutRequest;
import com.hazelcast.cache.impl.client.CacheRemoveEntryListenerRequest;
import com.hazelcast.cache.impl.client.CacheRemoveInvalidationListenerRequest;
import com.hazelcast.cache.impl.client.CacheRemoveRequest;
import com.hazelcast.cache.impl.client.CacheReplaceRequest;
import com.hazelcast.cache.impl.nearcache.NearCache;
import com.hazelcast.cache.impl.nearcache.NearCacheContext;
import com.hazelcast.cache.impl.nearcache.NearCacheExecutor;
import com.hazelcast.cache.impl.nearcache.NearCacheManager;
import com.hazelcast.client.cache.impl.AbstractClientCacheProxyBase;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.BaseClientRemoveListenerRequest;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.Client;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.executor.CompletedFuture;
import com.hazelcast.util.executor.DelegatingFuture;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.expiry.ExpiryPolicy;

abstract class AbstractClientInternalCacheProxy<K, V>
extends AbstractClientCacheProxyBase<K, V>
implements CacheSyncListenerCompleter {
    private static final long MAX_COMPLETION_LATCH_WAIT_TIME = TimeUnit.MINUTES.toMillis(5L);
    private static final long COMPLETION_LATCH_WAIT_TIME_STEP = TimeUnit.SECONDS.toMillis(1L);
    protected final ILogger logger = Logger.getLogger(this.getClass());
    protected final HazelcastClientCacheManager cacheManager;
    protected final NearCacheManager nearCacheManager;
    protected NearCache<Data, Object> nearCache;
    protected String nearCacheMembershipRegistrationId;
    protected final ConcurrentMap<Member, String> nearCacheInvalidationListeners = new ConcurrentHashMap<Member, String>();
    private boolean cacheOnUpdate;
    private final ConcurrentMap<CacheEntryListenerConfiguration, String> asyncListenerRegistrations;
    private final ConcurrentMap<CacheEntryListenerConfiguration, String> syncListenerRegistrations;
    private final ConcurrentMap<Integer, CountDownLatch> syncLocks;
    private final AtomicInteger completionIdCounter = new AtomicInteger();

    protected AbstractClientInternalCacheProxy(CacheConfig cacheConfig, ClientContext clientContext, HazelcastClientCacheManager cacheManager) {
        super(cacheConfig, clientContext);
        this.cacheManager = cacheManager;
        this.nearCacheManager = clientContext.getNearCacheManager();
        this.asyncListenerRegistrations = new ConcurrentHashMap<CacheEntryListenerConfiguration, String>();
        this.syncListenerRegistrations = new ConcurrentHashMap<CacheEntryListenerConfiguration, String>();
        this.syncLocks = new ConcurrentHashMap<Integer, CountDownLatch>();
        this.initNearCache();
    }

    private void initNearCache() {
        NearCacheConfig nearCacheConfig = this.clientContext.getClientConfig().getNearCacheConfig(this.name);
        if (nearCacheConfig != null) {
            this.cacheOnUpdate = nearCacheConfig.getLocalUpdatePolicy() == NearCacheConfig.LocalUpdatePolicy.CACHE;
            NearCacheContext nearCacheContext = new NearCacheContext(this.clientContext.getSerializationService(), this.createNearCacheExecutor(this.clientContext.getExecutionService()));
            this.nearCache = this.nearCacheManager.getOrCreateNearCache(this.nameWithPrefix, nearCacheConfig, nearCacheContext);
            this.registerInvalidationListener();
        }
    }

    private NearCacheExecutor createNearCacheExecutor(ClientExecutionService clientExecutionService) {
        return new ClientNearCacheExecutor(clientExecutionService);
    }

    @Override
    public void close() {
        if (this.nearCache != null) {
            this.removeInvalidationListener();
            this.nearCacheManager.clearNearCache(this.nearCache.getName());
        }
        super.close();
    }

    @Override
    public void destroy() {
        if (this.nearCache != null) {
            this.removeInvalidationListener();
            this.nearCacheManager.destroyNearCache(this.nearCache.getName());
        }
        super.destroy();
    }

    protected <T> ICompletableFuture<T> invoke(ClientRequest req, Data keyData, boolean completionOperation) {
        Integer completionId = null;
        if (completionOperation) {
            completionId = this.registerCompletionLatch(1);
            if (req instanceof AbstractCacheRequest) {
                ((AbstractCacheRequest)req).setCompletionId(completionId);
            }
        }
        try {
            int partitionId = this.clientContext.getPartitionService().getPartitionId(keyData);
            HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance();
            ClientInvocation clientInvocation = new ClientInvocation(client, req, partitionId);
            ClientInvocationFuture f = clientInvocation.invoke();
            if (completionOperation) {
                this.waitCompletionLatch(completionId);
            }
            return f;
        }
        catch (Throwable e) {
            if (e instanceof IllegalStateException) {
                this.close();
            }
            if (completionOperation) {
                this.deregisterCompletionLatch(completionId);
            }
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
    }

    protected <T> T getSafely(Future<T> future) {
        try {
            return future.get();
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow((Throwable)throwable);
        }
    }

    protected <T> ICompletableFuture<T> removeAsyncInternal(K key, V oldValue, boolean hasOldValue, boolean isGet, boolean withCompletionEvent) {
        ICompletableFuture<T> future;
        this.ensureOpen();
        if (hasOldValue) {
            CacheProxyUtil.validateNotNull(key, oldValue);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, oldValue);
        } else {
            CacheProxyUtil.validateNotNull(key);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key);
        }
        Data keyData = this.toData(key);
        Data oldValueData = oldValue != null ? this.toData(oldValue) : null;
        InMemoryFormat inMemoryFormat = this.cacheConfig.getInMemoryFormat();
        Object request = isGet ? new CacheGetAndRemoveRequest(this.nameWithPrefix, keyData, inMemoryFormat) : new CacheRemoveRequest(this.nameWithPrefix, keyData, oldValueData, inMemoryFormat);
        try {
            future = this.invoke((ClientRequest)request, keyData, withCompletionEvent);
            this.invalidateNearCache(keyData);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        return new DelegatingFuture(future, this.clientContext.getSerializationService());
    }

    protected <T> ICompletableFuture<T> replaceAsyncInternal(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy, boolean hasOldValue, boolean isGet, boolean withCompletionEvent) {
        ICompletableFuture<T> future;
        this.ensureOpen();
        if (hasOldValue) {
            CacheProxyUtil.validateNotNull(key, oldValue, newValue);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, oldValue, newValue);
        } else {
            CacheProxyUtil.validateNotNull(key, newValue);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, newValue);
        }
        Data keyData = this.toData(key);
        Data oldValueData = oldValue != null ? this.toData(oldValue) : null;
        Data newValueData = newValue != null ? this.toData(newValue) : null;
        InMemoryFormat inMemoryFormat = this.cacheConfig.getInMemoryFormat();
        Object request = isGet ? new CacheGetAndReplaceRequest(this.nameWithPrefix, keyData, newValueData, expiryPolicy, inMemoryFormat) : new CacheReplaceRequest(this.nameWithPrefix, keyData, oldValueData, newValueData, expiryPolicy, inMemoryFormat);
        try {
            future = this.invoke((ClientRequest)request, keyData, withCompletionEvent);
            this.invalidateNearCache(keyData);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        return new DelegatingFuture(future, this.clientContext.getSerializationService());
    }

    protected <T> ICompletableFuture<T> putAsyncInternal(K key, V value, ExpiryPolicy expiryPolicy, boolean isGet, boolean withCompletionEvent) {
        ICompletableFuture<T> future;
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key, value);
        CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, value);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        InMemoryFormat inMemoryFormat = this.cacheConfig.getInMemoryFormat();
        CachePutRequest request = new CachePutRequest(this.nameWithPrefix, keyData, valueData, expiryPolicy, isGet, inMemoryFormat);
        try {
            future = this.invoke((ClientRequest)request, keyData, withCompletionEvent);
            if (this.cacheOnUpdate) {
                this.storeInNearCache(keyData, valueData, value);
            } else {
                this.invalidateNearCache(keyData);
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        return future;
    }

    protected ICompletableFuture<Boolean> putIfAbsentAsyncInternal(K key, V value, ExpiryPolicy expiryPolicy, boolean withCompletionEvent) {
        ICompletableFuture future;
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key, value);
        CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, value);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        CachePutIfAbsentRequest request = new CachePutIfAbsentRequest(this.nameWithPrefix, keyData, valueData, expiryPolicy, this.cacheConfig.getInMemoryFormat());
        try {
            future = this.invoke((ClientRequest)request, keyData, withCompletionEvent);
            if (this.cacheOnUpdate) {
                this.storeInNearCache(keyData, valueData, value);
            } else {
                this.invalidateNearCache(keyData);
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        return new DelegatingFuture(future, this.clientContext.getSerializationService());
    }

    protected void removeAllInternal(Set<? extends K> keys, boolean isRemoveAll) {
        HashSet<Data> keysData;
        if (keys != null) {
            keysData = new HashSet<Data>();
            for (K key : keys) {
                keysData.add(this.toData(key));
            }
        } else {
            keysData = null;
        }
        int partitionCount = this.clientContext.getPartitionService().getPartitionCount();
        int completionId = this.registerCompletionLatch(partitionCount);
        CacheClearRequest request = new CacheClearRequest(this.nameWithPrefix, keysData, isRemoveAll, completionId);
        try {
            Map results = (Map)this.invoke((ClientRequest)request);
            int completionCount = 0;
            for (Object result : results.values()) {
                if (result == null || !(result instanceof CacheClearResponse)) continue;
                Object response = ((CacheClearResponse)result).getResponse();
                if (response instanceof Boolean) {
                    ++completionCount;
                }
                if (!(response instanceof Throwable)) continue;
                throw (Throwable)response;
            }
            this.waitCompletionLatch(completionId, partitionCount - completionCount);
        }
        catch (Throwable t) {
            this.deregisterCompletionLatch(completionId);
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)t, CacheException.class);
        }
    }

    protected void clearInternal() {
        CacheClearRequest request = new CacheClearRequest(this.nameWithPrefix, null, false, -1);
        try {
            Map results = (Map)this.invoke((ClientRequest)request);
            for (Object result : results.values()) {
                Object response;
                if (result == null || !(result instanceof CacheClearResponse) || !((response = ((CacheClearResponse)result).getResponse()) instanceof Throwable)) continue;
                throw (Throwable)response;
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)t, CacheException.class);
        }
    }

    protected void storeInNearCache(Data key, Data valueData, V value) {
        if (this.nearCache != null) {
            Object valueToStore = this.nearCache.selectToSave(new Object[]{value, valueData});
            this.nearCache.put((Object)key, valueToStore);
        }
    }

    protected void invalidateNearCache(Data key) {
        if (this.nearCache != null) {
            this.nearCache.invalidate((Object)key);
        }
    }

    protected void addListenerLocally(String regId, CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        if (cacheEntryListenerConfiguration.isSynchronous()) {
            this.syncListenerRegistrations.putIfAbsent(cacheEntryListenerConfiguration, regId);
        } else {
            this.asyncListenerRegistrations.putIfAbsent(cacheEntryListenerConfiguration, regId);
        }
    }

    protected String removeListenerLocally(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        ConcurrentMap<CacheEntryListenerConfiguration, String> regs = cacheEntryListenerConfiguration.isSynchronous() ? this.syncListenerRegistrations : this.asyncListenerRegistrations;
        return (String)regs.remove(cacheEntryListenerConfiguration);
    }

    private void deregisterAllCacheEntryListener(Collection<String> listenerRegistrations) {
        for (String regId : listenerRegistrations) {
            CacheRemoveEntryListenerRequest removeReq = new CacheRemoveEntryListenerRequest(this.nameWithPrefix, regId);
            this.clientContext.getListenerService().stopListening((BaseClientRemoveListenerRequest)removeReq, regId);
        }
    }

    @Override
    protected void closeListeners() {
        this.deregisterAllCacheEntryListener(this.syncListenerRegistrations.values());
        this.deregisterAllCacheEntryListener(this.asyncListenerRegistrations.values());
        this.syncListenerRegistrations.clear();
        this.asyncListenerRegistrations.clear();
        this.notifyAndClearSyncListenerLatches();
    }

    private void notifyAndClearSyncListenerLatches() {
        Collection latches = this.syncLocks.values();
        Iterator iterator = latches.iterator();
        while (iterator.hasNext()) {
            CountDownLatch latch = (CountDownLatch)iterator.next();
            iterator.remove();
            while (latch.getCount() > 0L) {
                latch.countDown();
            }
        }
    }

    public void countDownCompletionLatch(int id) {
        CountDownLatch countDownLatch = (CountDownLatch)this.syncLocks.get(id);
        if (countDownLatch == null) {
            return;
        }
        countDownLatch.countDown();
        if (countDownLatch.getCount() == 0L) {
            this.deregisterCompletionLatch(id);
        }
    }

    protected Integer registerCompletionLatch(int count) {
        if (!this.syncListenerRegistrations.isEmpty()) {
            int id = this.completionIdCounter.incrementAndGet();
            int size = this.syncListenerRegistrations.size();
            CountDownLatch countDownLatch = new CountDownLatch(count * size);
            this.syncLocks.put(id, countDownLatch);
            return id;
        }
        return -1;
    }

    protected void deregisterCompletionLatch(Integer countDownLatchId) {
        this.syncLocks.remove(countDownLatchId);
    }

    protected void waitCompletionLatch(Integer countDownLatchId) {
        CountDownLatch countDownLatch = (CountDownLatch)this.syncLocks.get(countDownLatchId);
        if (countDownLatch != null) {
            this.awaitLatch(countDownLatch);
        }
    }

    protected void waitCompletionLatch(Integer countDownLatchId, int offset) {
        CountDownLatch countDownLatch = (CountDownLatch)this.syncLocks.get(countDownLatchId);
        if (countDownLatch != null) {
            for (int i = 0; i < offset; ++i) {
                countDownLatch.countDown();
            }
            this.awaitLatch(countDownLatch);
        }
    }

    private void awaitLatch(CountDownLatch countDownLatch) {
        try {
            for (long currentTimeoutMs = MAX_COMPLETION_LATCH_WAIT_TIME; currentTimeoutMs > 0L && !countDownLatch.await(COMPLETION_LATCH_WAIT_TIME_STEP, TimeUnit.MILLISECONDS); currentTimeoutMs -= COMPLETION_LATCH_WAIT_TIME_STEP) {
                if (!this.clientContext.isActive()) {
                    throw new HazelcastInstanceNotActiveException();
                }
                if (!this.isClosed()) continue;
                throw new IllegalStateException("Cache (" + this.nameWithPrefix + ") is closed !");
            }
        }
        catch (InterruptedException e) {
            ExceptionUtil.sneakyThrow((Throwable)e);
        }
    }

    protected EventHandler<Object> createHandler(final CacheEventListenerAdaptor adaptor) {
        return new EventHandler<Object>(){

            @Override
            public void handle(Object event) {
                adaptor.handleEvent(event);
            }

            @Override
            public void beforeListenerRegister() {
            }

            @Override
            public void onListenerRegister() {
            }
        };
    }

    protected ICompletableFuture createCompletedFuture(Object value) {
        return new CompletedFuture(this.clientContext.getSerializationService(), value, this.clientContext.getExecutionService().getAsyncExecutor());
    }

    private void registerInvalidationListener() {
        if (this.nearCache != null && this.nearCache.isInvalidateOnChange()) {
            ClientClusterService clusterService = this.clientContext.getClusterService();
            this.nearCacheMembershipRegistrationId = clusterService.addMembershipListener(new NearCacheMembershipListener());
            Collection<MemberImpl> memberList = clusterService.getMemberList();
            for (MemberImpl member : memberList) {
                this.addInvalidationListener(member);
            }
        }
    }

    private void removeInvalidationListener() {
        if (this.nearCache != null && this.nearCache.isInvalidateOnChange()) {
            String registrationId = this.nearCacheMembershipRegistrationId;
            ClientClusterService clusterService = this.clientContext.getClusterService();
            if (registrationId != null) {
                clusterService.removeMembershipListener(registrationId);
            }
            Collection<MemberImpl> memberList = clusterService.getMemberList();
            for (MemberImpl member : memberList) {
                this.removeInvalidationListener(member, true);
            }
        }
    }

    private void addInvalidationListener(MemberImpl member) {
        if (this.nearCacheInvalidationListeners.containsKey(member)) {
            return;
        }
        try {
            CacheAddInvalidationListenerRequest request = new CacheAddInvalidationListenerRequest(this.nameWithPrefix);
            Client client = this.clientContext.getClusterService().getLocalClient();
            NearCacheInvalidationHandler handler = new NearCacheInvalidationHandler(client);
            HazelcastClientInstanceImpl clientInstance = (HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance();
            ClientInvocation invocation = new ClientInvocation(clientInstance, (EventHandler)handler, (ClientRequest)request, member.getAddress());
            ClientInvocationFuture future = invocation.invoke();
            String registrationId = (String)this.clientContext.getSerializationService().toObject(future.get());
            this.clientContext.getListenerService().registerListener(registrationId, request.getCallId());
            this.nearCacheInvalidationListeners.put((Member)member, registrationId);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private void removeInvalidationListener(MemberImpl member, boolean removeFromMemberAlso) {
        String registrationId = (String)this.nearCacheInvalidationListeners.remove(member);
        if (registrationId != null) {
            try {
                if (removeFromMemberAlso) {
                    CacheRemoveInvalidationListenerRequest request = new CacheRemoveInvalidationListenerRequest(this.nameWithPrefix, registrationId);
                    HazelcastClientInstanceImpl clientInstance = (HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance();
                    ClientInvocation invocation = new ClientInvocation(clientInstance, (ClientRequest)request, member.getAddress());
                    ClientInvocationFuture future = invocation.invoke();
                    Boolean result = (Boolean)this.clientContext.getSerializationService().toObject(future.get());
                    if (!result.booleanValue()) {
                        this.logger.warning("Invalidation listener couldn't be removed on member " + member.getAddress());
                    }
                }
                this.clientContext.getListenerService().deRegisterListener(registrationId);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
    }

    private class NearCacheInvalidationHandler
    implements EventHandler<CacheInvalidationMessage> {
        private final Client client;

        private NearCacheInvalidationHandler(Client client) {
            this.client = client;
        }

        @Override
        public void handle(CacheInvalidationMessage message) {
            if (this.client.getUuid().equals(message.getSourceUuid())) {
                return;
            }
            Data key = message.getKey();
            if (key != null) {
                AbstractClientInternalCacheProxy.this.nearCache.invalidate((Object)key);
            } else {
                AbstractClientInternalCacheProxy.this.nearCache.clear();
            }
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
            AbstractClientInternalCacheProxy.this.nearCache.clear();
        }
    }

    private class NearCacheMembershipListener
    implements MembershipListener {
        private NearCacheMembershipListener() {
        }

        public void memberAdded(MembershipEvent event) {
            MemberImpl member = (MemberImpl)event.getMember();
            AbstractClientInternalCacheProxy.this.addInvalidationListener(member);
        }

        public void memberRemoved(MembershipEvent event) {
            MemberImpl member = (MemberImpl)event.getMember();
            AbstractClientInternalCacheProxy.this.removeInvalidationListener(member, false);
        }

        public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
        }
    }

    private static class ClientNearCacheExecutor
    implements NearCacheExecutor {
        private ClientExecutionService clientExecutionService;

        private ClientNearCacheExecutor(ClientExecutionService clientExecutionService) {
            this.clientExecutionService = clientExecutionService;
        }

        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.clientExecutionService.scheduleWithFixedDelay(command, initialDelay, delay, unit);
        }
    }
}

