/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.impl.CacheProxyUtil;
import com.hazelcast.cache.impl.client.CacheDestroyRequest;
import com.hazelcast.cache.impl.client.CacheLoadAllRequest;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ExceptionUtil;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.CacheException;
import javax.cache.configuration.Factory;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CompletionListener;

abstract class AbstractClientCacheProxyBase<K, V> {
    static final int TIMEOUT = 10;
    protected final ClientContext clientContext;
    protected final CacheConfig<K, V> cacheConfig;
    protected final String name;
    protected final String nameWithPrefix;
    private final CopyOnWriteArrayList<Future> loadAllTasks = new CopyOnWriteArrayList();
    private final CacheLoader<K, V> cacheLoader;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final AtomicBoolean isDestroyed = new AtomicBoolean(false);

    protected AbstractClientCacheProxyBase(CacheConfig cacheConfig, ClientContext clientContext) {
        this.name = cacheConfig.getName();
        this.nameWithPrefix = cacheConfig.getNameWithPrefix();
        this.cacheConfig = cacheConfig;
        this.clientContext = clientContext;
        if (cacheConfig.getCacheLoaderFactory() != null) {
            Factory cacheLoaderFactory = cacheConfig.getCacheLoaderFactory();
            this.cacheLoader = (CacheLoader)cacheLoaderFactory.create();
        } else {
            this.cacheLoader = null;
        }
    }

    protected void ensureOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException("Cache operations can not be performed. The cache closed");
        }
    }

    public void close() {
        if (!this.isClosed.compareAndSet(false, true)) {
            return;
        }
        for (Future f : this.loadAllTasks) {
            try {
                f.get(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
        this.loadAllTasks.clear();
        this.closeCacheLoader();
        this.closeListeners();
    }

    public void destroy() {
        this.close();
        if (!this.isDestroyed.compareAndSet(false, true)) {
            return;
        }
        this.isClosed.set(true);
        try {
            int partitionId = this.clientContext.getPartitionService().getPartitionId(this.nameWithPrefix);
            CacheDestroyRequest request = new CacheDestroyRequest(this.nameWithPrefix, partitionId);
            ICompletableFuture future = this.clientContext.getInvocationService().invokeOnKeyOwner((ClientRequest)request, this.nameWithPrefix);
            future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    public boolean isDestroyed() {
        return this.isDestroyed.get();
    }

    protected abstract void closeListeners();

    public String getNameWithPrefix() {
        return this.nameWithPrefix;
    }

    protected <T> T toObject(Object data) {
        return (T)this.clientContext.getSerializationService().toObject(data);
    }

    protected Data toData(Object o) {
        return this.clientContext.getSerializationService().toData(o);
    }

    protected <T> T invoke(ClientRequest req) {
        try {
            ICompletableFuture future = this.clientContext.getInvocationService().invokeOnRandomTarget(req);
            Object result = future.get();
            return this.toObject(result);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected void validateCacheLoader(CompletionListener completionListener) {
        if (this.cacheLoader == null && completionListener != null) {
            completionListener.onCompletion();
        }
    }

    protected void closeCacheLoader() {
        if (this.cacheLoader instanceof Closeable) {
            IOUtil.closeResource((Closeable)((Closeable)this.cacheLoader));
        }
    }

    protected void submitLoadAllTask(CacheLoadAllRequest request, CompletionListener completionListener) {
        LoadAllTask loadAllTask = new LoadAllTask(request, completionListener);
        ClientExecutionService executionService = this.clientContext.getExecutionService();
        final ICompletableFuture<?> future = executionService.submit(loadAllTask);
        this.loadAllTasks.add((Future)future);
        future.andThen(new ExecutionCallback(){

            public void onResponse(Object response) {
                AbstractClientCacheProxyBase.this.loadAllTasks.remove(future);
            }

            public void onFailure(Throwable t) {
                AbstractClientCacheProxyBase.this.loadAllTasks.remove(future);
            }
        });
    }

    private final class LoadAllTask
    implements Runnable {
        private final CacheLoadAllRequest request;
        private final CompletionListener completionListener;

        private LoadAllTask(CacheLoadAllRequest request, CompletionListener completionListener) {
            this.request = request;
            this.completionListener = completionListener;
        }

        @Override
        public void run() {
            block3: {
                try {
                    Map results = (Map)AbstractClientCacheProxyBase.this.invoke((ClientRequest)this.request);
                    CacheProxyUtil.validateResults((Map)results);
                    if (this.completionListener != null) {
                        this.completionListener.onCompletion();
                    }
                }
                catch (Exception e) {
                    if (this.completionListener == null) break block3;
                    this.completionListener.onException(e);
                }
            }
        }
    }
}

