/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.OutOfMemoryHandler;
import com.hazelcast.util.EmptyStatement;

public class ClientOutOfMemoryHandler
extends OutOfMemoryHandler {
    public void onOutOfMemory(OutOfMemoryError oom, HazelcastInstance[] hazelcastInstances) {
        System.err.println(oom);
        for (HazelcastInstance instance : hazelcastInstances) {
            if (!(instance instanceof HazelcastClientInstanceImpl)) continue;
            ClientHelper.cleanResources((HazelcastClientInstanceImpl)instance);
        }
    }

    private static final class ClientHelper {
        private ClientHelper() {
        }

        public static void cleanResources(HazelcastClientInstanceImpl client) {
            ClientHelper.closeSockets(client);
            ClientHelper.tryStopThreads(client);
            ClientHelper.tryShutdown(client);
        }

        private static void closeSockets(HazelcastClientInstanceImpl client) {
            ClientConnectionManager connectionManager = client.getConnectionManager();
            if (connectionManager != null) {
                try {
                    connectionManager.shutdown();
                }
                catch (Throwable ignored) {
                    EmptyStatement.ignore((Throwable)ignored);
                }
            }
        }

        private static void tryShutdown(HazelcastClientInstanceImpl client) {
            if (client == null) {
                return;
            }
            try {
                client.doShutdown();
            }
            catch (Throwable ignored) {
                EmptyStatement.ignore((Throwable)ignored);
            }
        }

        public static void tryStopThreads(HazelcastClientInstanceImpl client) {
            if (client == null) {
                return;
            }
            try {
                client.getThreadGroup().interrupt();
            }
            catch (Throwable ignored) {
                EmptyStatement.ignore((Throwable)ignored);
            }
        }
    }
}

