/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.ClientRequest;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.util.ClientCancellableDelegatingFuture;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberSelector;
import com.hazelcast.core.MultiExecutionCallback;
import com.hazelcast.core.PartitionAware;
import com.hazelcast.executor.RunnableAdapter;
import com.hazelcast.executor.client.IsShutdownRequest;
import com.hazelcast.executor.client.PartitionCallableRequest;
import com.hazelcast.executor.client.TargetCallableRequest;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.monitor.LocalExecutorStats;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.UuidUtil;
import com.hazelcast.util.executor.CompletedFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientExecutorServiceProxy
extends ClientProxy
implements IExecutorService {
    private static final int MIN_TIME_RESOLUTION_OF_CONSECUTIVE_SUBMITS = 10;
    private static final int MAX_CONSECUTIVE_SUBMITS = 100;
    private final String name;
    private final Random random = new Random(-System.currentTimeMillis());
    private final AtomicInteger consecutiveSubmits = new AtomicInteger();
    private volatile long lastSubmitTime;

    public ClientExecutorServiceProxy(String instanceName, String serviceName, String objectId) {
        super(instanceName, serviceName, objectId);
        this.name = objectId;
    }

    public void execute(Runnable command) {
        this.submit(command);
    }

    public void executeOnKeyOwner(Runnable command, Object key) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToKeyOwner((Callable)callable, key);
    }

    public void executeOnMember(Runnable command, Member member) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToMember((Callable)callable, member);
    }

    public void executeOnMembers(Runnable command, Collection<Member> members) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        for (Member member : members) {
            this.submitToMember((Callable)callable, member);
        }
    }

    public void execute(Runnable command, MemberSelector memberSelector) {
        List<Member> members = this.selectMembers(memberSelector);
        int selectedMember = this.random.nextInt(members.size());
        this.executeOnMember(command, members.get(selectedMember));
    }

    public void executeOnMembers(Runnable command, MemberSelector memberSelector) {
        List<Member> members = this.selectMembers(memberSelector);
        this.executeOnMembers(command, members);
    }

    public void executeOnAllMembers(Runnable command) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        Collection<MemberImpl> memberList = this.getContext().getClusterService().getMemberList();
        for (MemberImpl member : memberList) {
            this.submitToMember((Callable)callable, (Member)member);
        }
    }

    public <T> Future<T> submitToMember(Callable<T> task, Member member) {
        Address memberAddress = this.getMemberAddress(member);
        return this.submitToTargetInternal(task, memberAddress, null, false);
    }

    public <T> Map<Member, Future<T>> submitToMembers(Callable<T> task, Collection<Member> members) {
        HashMap<Member, Future<T>> futureMap = new HashMap<Member, Future<T>>(members.size());
        for (Member member : members) {
            Address memberAddress = this.getMemberAddress(member);
            Future<Object> f = this.submitToTargetInternal(task, memberAddress, null, true);
            futureMap.put(member, f);
        }
        return futureMap;
    }

    public <T> Future<T> submit(Callable<T> task, MemberSelector memberSelector) {
        List<Member> members = this.selectMembers(memberSelector);
        int selectedMember = this.random.nextInt(members.size());
        return this.submitToMember(task, members.get(selectedMember));
    }

    public <T> Map<Member, Future<T>> submitToMembers(Callable<T> task, MemberSelector memberSelector) {
        List<Member> members = this.selectMembers(memberSelector);
        return this.submitToMembers(task, members);
    }

    public <T> Map<Member, Future<T>> submitToAllMembers(Callable<T> task) {
        Collection<MemberImpl> memberList = this.getContext().getClusterService().getMemberList();
        HashMap<Member, Future<T>> futureMap = new HashMap<Member, Future<T>>(memberList.size());
        for (MemberImpl m : memberList) {
            Future<Object> f = this.submitToTargetInternal(task, m.getAddress(), null, true);
            futureMap.put((Member)m, f);
        }
        return futureMap;
    }

    public void submitToMember(Runnable command, Member member, ExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToMember((Callable)callable, member, (ExecutionCallback)callback);
    }

    public void submitToMembers(Runnable command, Collection<Member> members, MultiExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        MultiExecutionCallbackWrapper multiExecutionCallbackWrapper = new MultiExecutionCallbackWrapper(members.size(), callback);
        for (Member member : members) {
            ExecutionCallbackWrapper executionCallback = new ExecutionCallbackWrapper(multiExecutionCallbackWrapper, member);
            this.submitToMember((Callable)callable, member, executionCallback);
        }
    }

    public <T> void submitToMember(Callable<T> task, Member member, ExecutionCallback<T> callback) {
        Address memberAddress = this.getMemberAddress(member);
        this.submitToTargetInternal(task, memberAddress, callback);
    }

    public <T> void submitToMembers(Callable<T> task, Collection<Member> members, MultiExecutionCallback callback) {
        MultiExecutionCallbackWrapper multiExecutionCallbackWrapper = new MultiExecutionCallbackWrapper(members.size(), callback);
        for (Member member : members) {
            ExecutionCallbackWrapper executionCallback = new ExecutionCallbackWrapper(multiExecutionCallbackWrapper, member);
            this.submitToMember(task, member, executionCallback);
        }
    }

    public void submit(Runnable task, MemberSelector memberSelector, ExecutionCallback callback) {
        List<Member> members = this.selectMembers(memberSelector);
        int selectedMember = this.random.nextInt(members.size());
        this.submitToMember(task, members.get(selectedMember), callback);
    }

    public void submitToMembers(Runnable task, MemberSelector memberSelector, MultiExecutionCallback callback) {
        List<Member> members = this.selectMembers(memberSelector);
        this.submitToMembers(task, members, callback);
    }

    public <T> void submit(Callable<T> task, MemberSelector memberSelector, ExecutionCallback<T> callback) {
        List<Member> members = this.selectMembers(memberSelector);
        int selectedMember = this.random.nextInt(members.size());
        this.submitToMember(task, members.get(selectedMember), callback);
    }

    public <T> void submitToMembers(Callable<T> task, MemberSelector memberSelector, MultiExecutionCallback callback) {
        List<Member> members = this.selectMembers(memberSelector);
        this.submitToMembers(task, members, callback);
    }

    public void submitToAllMembers(Runnable command, MultiExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToAllMembers((Callable)callable, callback);
    }

    public <T> void submitToAllMembers(Callable<T> task, MultiExecutionCallback callback) {
        Collection<MemberImpl> memberList = this.getContext().getClusterService().getMemberList();
        MultiExecutionCallbackWrapper multiExecutionCallbackWrapper = new MultiExecutionCallbackWrapper(memberList.size(), callback);
        for (Member member : memberList) {
            ExecutionCallbackWrapper executionCallback = new ExecutionCallbackWrapper(multiExecutionCallbackWrapper, member);
            this.submitToMember(task, member, executionCallback);
        }
    }

    public Future<?> submit(Runnable command) {
        Object partitionKey = this.getTaskPartitionKey(command);
        RunnableAdapter callable = this.createRunnableAdapter(command);
        if (partitionKey != null) {
            return this.submitToKeyOwner((Callable)callable, partitionKey);
        }
        return this.submitToRandomInternal((Callable)callable, null, false);
    }

    public <T> Future<T> submit(Runnable command, T result) {
        Object partitionKey = this.getTaskPartitionKey(command);
        RunnableAdapter<T> callable = this.createRunnableAdapter(command);
        if (partitionKey != null) {
            return this.submitToKeyOwnerInternal((Callable<T>)callable, partitionKey, result, false);
        }
        return this.submitToRandomInternal((Callable<T>)callable, result, false);
    }

    public <T> Future<T> submit(Callable<T> task) {
        Object partitionKey = this.getTaskPartitionKey(task);
        if (partitionKey != null) {
            return this.submitToKeyOwner(task, partitionKey);
        }
        return this.submitToRandomInternal(task, null, false);
    }

    public void submit(Runnable command, ExecutionCallback callback) {
        Object partitionKey = this.getTaskPartitionKey(command);
        RunnableAdapter callable = this.createRunnableAdapter(command);
        if (partitionKey != null) {
            this.submitToKeyOwnerInternal((Callable)callable, partitionKey, (ExecutionCallback)callback);
        } else {
            this.submitToRandomInternal((Callable)callable, (ExecutionCallback)callback);
        }
    }

    public <T> void submit(Callable<T> task, ExecutionCallback<T> callback) {
        Object partitionKey = this.getTaskPartitionKey(task);
        if (partitionKey != null) {
            this.submitToKeyOwnerInternal(task, partitionKey, callback);
        } else {
            this.submitToRandomInternal(task, callback);
        }
    }

    public <T> Future<T> submitToKeyOwner(Callable<T> task, Object key) {
        return this.submitToKeyOwnerInternal(task, key, null, false);
    }

    public void submitToKeyOwner(Runnable command, Object key, ExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToKeyOwner((Callable)callable, key, (ExecutionCallback)callback);
    }

    public <T> void submitToKeyOwner(Callable<T> task, Object key, ExecutionCallback<T> callback) {
        this.submitToKeyOwnerInternal(task, key, callback);
    }

    public LocalExecutorStats getLocalExecutorStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public void shutdown() {
        this.destroy();
    }

    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    public boolean isShutdown() {
        try {
            IsShutdownRequest request = new IsShutdownRequest(this.name);
            Boolean result = (Boolean)this.invoke((ClientRequest)request);
            return result;
        }
        catch (DistributedObjectDestroyedException e) {
            return true;
        }
    }

    public boolean isTerminated() {
        return this.isShutdown();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return false;
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(tasks.size());
        ArrayList<Future<T>> result = new ArrayList<Future<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            futures.add(this.submitToRandomInternal(task, null, true));
        }
        ExecutorService asyncExecutor = this.getContext().getExecutionService().getAsyncExecutor();
        for (Future future : futures) {
            Object value;
            try {
                value = future.get();
            }
            catch (ExecutionException e) {
                value = e;
            }
            result.add((Future<T>)new CompletedFuture(this.getContext().getSerializationService(), value, asyncExecutor));
        }
        return result;
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    private Object getTaskPartitionKey(Object task) {
        if (task instanceof PartitionAware) {
            return ((PartitionAware)task).getPartitionKey();
        }
        return null;
    }

    private <T> RunnableAdapter<T> createRunnableAdapter(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        return new RunnableAdapter(command);
    }

    private <T> Future<T> submitToKeyOwnerInternal(Callable<T> task, Object key, T defaultValue, boolean preventSync) {
        this.checkIfNotNull(task);
        String uuid = this.getUUID();
        int partitionId = this.getPartitionId(key);
        PartitionCallableRequest request = new PartitionCallableRequest(this.name, uuid, task, partitionId);
        ICompletableFuture f = this.invokeFuture(request, partitionId);
        return this.checkSync(f, uuid, null, partitionId, preventSync, defaultValue);
    }

    private <T> void submitToKeyOwnerInternal(Callable<T> task, Object key, ExecutionCallback<T> callback) {
        this.checkIfNotNull(task);
        String uuid = this.getUUID();
        int partitionId = this.getPartitionId(key);
        PartitionCallableRequest request = new PartitionCallableRequest(this.name, uuid, task, partitionId);
        ICompletableFuture f = this.invokeFuture(request, partitionId);
        f.andThen(callback);
    }

    private <T> Future<T> submitToRandomInternal(Callable<T> task, T defaultValue, boolean preventSync) {
        this.checkIfNotNull(task);
        String uuid = this.getUUID();
        int partitionId = this.randomPartitionId();
        PartitionCallableRequest request = new PartitionCallableRequest(this.name, uuid, task, partitionId);
        ICompletableFuture f = this.invokeFuture(request, partitionId);
        return this.checkSync(f, uuid, null, partitionId, preventSync, defaultValue);
    }

    private <T> void submitToRandomInternal(Callable<T> task, ExecutionCallback<T> callback) {
        this.checkIfNotNull(task);
        this.checkIfNotNull(task);
        String uuid = this.getUUID();
        int partitionId = this.randomPartitionId();
        PartitionCallableRequest request = new PartitionCallableRequest(this.name, uuid, task, partitionId);
        ICompletableFuture f = this.invokeFuture(request, partitionId);
        f.andThen(callback);
    }

    private <T> Future<T> submitToTargetInternal(Callable<T> task, Address address, T defaultValue, boolean preventSync) {
        this.checkIfNotNull(task);
        String uuid = this.getUUID();
        TargetCallableRequest request = new TargetCallableRequest(this.name, uuid, task, address);
        ICompletableFuture f = this.invokeFuture(request);
        return this.checkSync(f, uuid, address, -1, preventSync, defaultValue);
    }

    private <T> void submitToTargetInternal(Callable<T> task, Address address, ExecutionCallback<T> callback) {
        this.checkIfNotNull(task);
        TargetCallableRequest request = new TargetCallableRequest(this.name, null, task, address);
        ICompletableFuture f = this.invokeFuture(request);
        f.andThen(callback);
    }

    private void checkIfNotNull(Callable task) {
        if (task == null) {
            throw new NullPointerException();
        }
    }

    public String toString() {
        return "IExecutorService{name='" + this.getName() + '\'' + '}';
    }

    private <T> Future<T> checkSync(ICompletableFuture<T> f, String uuid, Address address, int partitionId, boolean preventSync, T defaultValue) {
        boolean sync = false;
        long last = this.lastSubmitTime;
        long now = Clock.currentTimeMillis();
        if (last + 10L < now) {
            this.consecutiveSubmits.set(0);
        } else if (this.consecutiveSubmits.incrementAndGet() % 100 == 0) {
            sync = true;
        }
        this.lastSubmitTime = now;
        if (sync && !preventSync) {
            Object response;
            try {
                response = f.get();
            }
            catch (Exception e) {
                response = e;
            }
            ExecutorService asyncExecutor = this.getContext().getExecutionService().getAsyncExecutor();
            return new CompletedFuture(this.getContext().getSerializationService(), response, asyncExecutor);
        }
        if (defaultValue != null) {
            return new ClientCancellableDelegatingFuture<T>(f, this.getContext(), uuid, address, partitionId, defaultValue);
        }
        return new ClientCancellableDelegatingFuture(f, this.getContext(), uuid, address, partitionId);
    }

    private List<Member> selectMembers(MemberSelector memberSelector) {
        if (memberSelector == null) {
            throw new IllegalArgumentException("memberSelector must not be null");
        }
        ArrayList<Member> selected = new ArrayList<Member>();
        Collection<MemberImpl> members = this.getContext().getClusterService().getMemberList();
        for (MemberImpl member : members) {
            if (!memberSelector.select((Member)member)) continue;
            selected.add((Member)member);
        }
        if (selected.isEmpty()) {
            throw new RejectedExecutionException("No member selected with memberSelector[" + memberSelector + "]");
        }
        return selected;
    }

    private ICompletableFuture invokeFuture(PartitionCallableRequest request, int partitionId) {
        try {
            Address partitionOwner = this.getPartitionOwner(partitionId);
            return this.getContext().getInvocationService().invokeOnTarget((ClientRequest)request, partitionOwner);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private ICompletableFuture invokeFuture(TargetCallableRequest request) {
        try {
            return this.getContext().getInvocationService().invokeOnTarget((ClientRequest)request, request.getTarget());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private String getUUID() {
        return UuidUtil.buildRandomUuidString();
    }

    private Address getMemberAddress(Member member) {
        MemberImpl m = this.getContext().getClusterService().getMember(member.getUuid());
        if (m == null) {
            throw new HazelcastException(member + " is not available!!!");
        }
        return m.getAddress();
    }

    private int getPartitionId(Object key) {
        ClientPartitionService partitionService = this.getContext().getPartitionService();
        return partitionService.getPartitionId(key);
    }

    private int randomPartitionId() {
        ClientPartitionService partitionService = this.getContext().getPartitionService();
        return this.random.nextInt(partitionService.getPartitionCount());
    }

    private Address getPartitionOwner(int partitionId) {
        ClientPartitionService partitionService = this.getContext().getPartitionService();
        return partitionService.getPartitionOwner(partitionId);
    }

    private static final class MultiExecutionCallbackWrapper
    implements MultiExecutionCallback {
        private final AtomicInteger members;
        private final MultiExecutionCallback multiExecutionCallback;
        private final Map<Member, Object> values;

        private MultiExecutionCallbackWrapper(int memberSize, MultiExecutionCallback multiExecutionCallback) {
            this.multiExecutionCallback = multiExecutionCallback;
            this.members = new AtomicInteger(memberSize);
            this.values = new HashMap<Member, Object>(memberSize);
        }

        public void onResponse(Member member, Object value) {
            this.multiExecutionCallback.onResponse(member, value);
            this.values.put(member, value);
            int waitingResponse = this.members.decrementAndGet();
            if (waitingResponse == 0) {
                this.onComplete(this.values);
            }
        }

        public void onComplete(Map<Member, Object> values) {
            this.multiExecutionCallback.onComplete(values);
        }
    }

    private static final class ExecutionCallbackWrapper<T>
    implements ExecutionCallback<T> {
        MultiExecutionCallbackWrapper multiExecutionCallbackWrapper;
        Member member;

        private ExecutionCallbackWrapper(MultiExecutionCallbackWrapper multiExecutionCallback, Member member) {
            this.multiExecutionCallbackWrapper = multiExecutionCallback;
            this.member = member;
        }

        public void onResponse(T response) {
            this.multiExecutionCallbackWrapper.onResponse(this.member, response);
        }

        public void onFailure(Throwable t) {
        }
    }
}

