/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.IOSelector;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class ClientAbstractIOSelector
extends Thread
implements IOSelector {
    private static final int TIMEOUT = 3;
    private static final int WAIT_TIME = 5000;
    protected final ILogger logger;
    protected final Queue<Runnable> selectorQueue = new ConcurrentLinkedQueue<Runnable>();
    protected final int waitTime;
    protected final Selector selector;
    protected boolean live = true;
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);

    protected ClientAbstractIOSelector(ThreadGroup threadGroup, String threadName) {
        super(threadGroup, threadName);
        this.logger = Logger.getLogger((String)this.getClass().getName());
        this.waitTime = 5000;
        Selector selectorTemp = null;
        try {
            selectorTemp = Selector.open();
        }
        catch (IOException e) {
            this.handleSelectorException(e);
        }
        this.selector = selectorTemp;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public void addTask(Runnable runnable) {
        this.selectorQueue.add(runnable);
    }

    public void wakeup() {
        this.selector.wakeup();
    }

    public void shutdown() {
        this.selectorQueue.clear();
        try {
            this.addTask(new Runnable(){

                @Override
                public void run() {
                    ClientAbstractIOSelector.this.live = false;
                    ClientAbstractIOSelector.this.shutdownLatch.countDown();
                }
            });
            this.interrupt();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void awaitShutdown() {
        try {
            this.shutdownLatch.await(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void processSelectionQueue() {
        while (this.live) {
            Runnable runnable = this.selectorQueue.poll();
            if (runnable == null) {
                return;
            }
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public final void run() {
        try {
            block18: while (true) {
                if (!this.live) break;
                this.processSelectionQueue();
                if (!this.live || this.isInterrupted()) {
                    if (this.logger.isFinestEnabled()) {
                        this.logger.finest(this.getName() + " is interrupted!");
                    }
                    this.live = false;
                    return;
                }
                try {
                    selectedKeyCount = this.selector.select(this.waitTime);
                }
                catch (Throwable e) {
                    this.logger.warning(e.toString());
                    continue;
                }
                if (selectedKeyCount == 0) continue;
                setSelectedKeys = this.selector.selectedKeys();
                it = setSelectedKeys.iterator();
                while (true) {
                    if (it.hasNext()) ** break;
                    continue block18;
                    sk = it.next();
                    try {
                        it.remove();
                        this.handleSelectionKey(sk);
                    }
                    catch (Throwable e) {
                        this.handleSelectorException(e);
                    }
                }
                break;
            }
        }
        catch (Throwable e) {
            this.logger.warning("Unhandled exception in " + this.getName(), e);
        }
        finally {
            try {
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest("Closing selector " + this.getName());
                }
                this.selector.close();
            }
            catch (Exception ignored) {}
        }
    }

    protected abstract void handleSelectionKey(SelectionKey var1);

    private void handleSelectorException(Throwable e) {
        String msg = "Selector exception at  " + this.getName() + ", cause= " + e.toString();
        this.logger.warning(msg, e);
    }
}

