/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi;

import com.hazelcast.client.BaseClientRemoveListenerRequest;
import com.hazelcast.client.ClientDestroyRequest;
import com.hazelcast.client.ClientRequest;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.util.ListenerUtil;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import com.hazelcast.util.ExceptionUtil;

public abstract class ClientProxy
implements DistributedObject {
    private final String serviceName;
    private final String objectName;
    private volatile ClientContext context;

    protected ClientProxy(String serviceName, String objectName) {
        this.serviceName = serviceName;
        this.objectName = objectName;
    }

    protected final String listen(ClientRequest registrationRequest, Object partitionKey, EventHandler handler) {
        return ListenerUtil.listen(this.context, registrationRequest, partitionKey, handler);
    }

    protected final String listen(ClientRequest registrationRequest, EventHandler handler) {
        return ListenerUtil.listen(this.context, registrationRequest, null, handler);
    }

    protected final boolean stopListening(BaseClientRemoveListenerRequest request, String registrationId) {
        return ListenerUtil.stopListening(this.context, request, registrationId);
    }

    protected final ClientContext getContext() {
        ClientContext ctx = this.context;
        if (ctx == null) {
            throw new DistributedObjectDestroyedException(this.serviceName, this.objectName);
        }
        return ctx;
    }

    protected final void setContext(ClientContext context) {
        this.context = context;
    }

    @Deprecated
    public final Object getId() {
        return this.objectName;
    }

    public final String getName() {
        return this.objectName;
    }

    public String getPartitionKey() {
        return StringPartitioningStrategy.getPartitionKey((String)this.getName());
    }

    public final String getServiceName() {
        return this.serviceName;
    }

    public final void destroy() {
        this.onDestroy();
        ClientDestroyRequest request = new ClientDestroyRequest(this.objectName, this.getServiceName());
        try {
            this.context.getInvocationService().invokeOnRandomTarget((ClientRequest)request).get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        this.context.removeProxy(this);
        this.context = null;
    }

    protected abstract void onDestroy();

    protected void onShutdown() {
    }

    protected <T> T invoke(ClientRequest req, Object key) {
        try {
            ICompletableFuture future = this.getInvocationService().invokeOnKeyOwner(req, key);
            Object result = future.get();
            return this.toObject(result);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected <T> T invokeInterruptibly(ClientRequest req, Object key) throws InterruptedException {
        try {
            ICompletableFuture future = this.getInvocationService().invokeOnKeyOwner(req, key);
            Object result = future.get();
            return this.toObject(result);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrowAllowInterrupted((Throwable)e);
        }
    }

    private ClientInvocationService getInvocationService() {
        return this.getContext().getInvocationService();
    }

    protected <T> T invoke(ClientRequest req) {
        try {
            ICompletableFuture future = this.getInvocationService().invokeOnRandomTarget(req);
            Object result = future.get();
            return this.toObject(result);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected <T> T invoke(ClientRequest req, Address address) {
        try {
            ICompletableFuture future = this.getInvocationService().invokeOnTarget(req, address);
            Object result = future.get();
            return this.toObject(result);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected Data toData(Object o) {
        return this.getContext().getSerializationService().toData(o);
    }

    protected <T> T toObject(Object data) {
        return (T)this.getContext().getSerializationService().toObject(data);
    }

    protected void throwExceptionIfNull(Object o) {
        if (o == null) {
            throw new NullPointerException("Object is null");
        }
    }

    private String getInstanceName() {
        ClientContext ctx = this.context;
        if (ctx != null) {
            HazelcastInstance instance = ctx.getHazelcastInstance();
            return instance.getName();
        }
        return "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientProxy that = (ClientProxy)o;
        String instanceName = this.getInstanceName();
        if (!instanceName.equals(that.getInstanceName())) {
            return false;
        }
        if (!this.objectName.equals(that.objectName)) {
            return false;
        }
        return this.serviceName.equals(that.serviceName);
    }

    public int hashCode() {
        String instanceName = this.getInstanceName();
        int result = instanceName.hashCode();
        result = 31 * result + this.serviceName.hashCode();
        result = 31 * result + this.objectName.hashCode();
        return result;
    }
}

