/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.util;

import com.hazelcast.client.connection.Addresses;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.util.AddressUtil;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public final class AddressHelper {
    private static final int MAX_PORT_TRIES = 3;
    private static final int INITIAL_FIRST_PORT = 5701;

    private AddressHelper() {
    }

    public static String getScopedHostName(AddressUtil.AddressHolder addressHolder) {
        return addressHolder.getScopeId() != null ? addressHolder.getAddress() + '%' + addressHolder.getScopeId() : addressHolder.getAddress();
    }

    public static Addresses getSocketAddresses(String address) {
        AddressUtil.AddressHolder addressHolder = AddressUtil.getAddressHolder((String)address, (int)-1);
        String scopedAddress = AddressHelper.getScopedHostName(addressHolder);
        int port = addressHolder.getPort();
        int maxPortTryCount = 1;
        if (port == -1) {
            maxPortTryCount = 3;
        }
        return AddressHelper.getPossibleSocketAddresses(port, scopedAddress, maxPortTryCount);
    }

    public static Addresses getPossibleSocketAddresses(int port, String scopedAddress, int portTryCount) {
        LinkedList<Address> addressList;
        block10: {
            int possiblePort;
            InetAddress inetAddress;
            block11: {
                block9: {
                    inetAddress = null;
                    try {
                        inetAddress = InetAddress.getByName(scopedAddress);
                    }
                    catch (UnknownHostException ignored) {
                        Logger.getLogger(AddressHelper.class).finest("Address not available", (Throwable)ignored);
                    }
                    possiblePort = port;
                    if (possiblePort == -1) {
                        possiblePort = 5701;
                    }
                    addressList = new LinkedList<Address>();
                    if (inetAddress != null) break block9;
                    for (int i = 0; i < portTryCount; ++i) {
                        try {
                            addressList.add(new Address(scopedAddress, possiblePort + i));
                            continue;
                        }
                        catch (UnknownHostException ignored) {
                            Logger.getLogger(AddressHelper.class).finest("Address not available", (Throwable)ignored);
                        }
                    }
                    break block10;
                }
                if (!(inetAddress instanceof Inet4Address)) break block11;
                for (int i = 0; i < portTryCount; ++i) {
                    addressList.add(new Address(scopedAddress, inetAddress, possiblePort + i));
                }
                break block10;
            }
            if (!(inetAddress instanceof Inet6Address)) break block10;
            Collection possibleInetAddresses = AddressUtil.getPossibleInetAddressesFor((Inet6Address)((Inet6Address)inetAddress));
            for (Inet6Address inet6Address : possibleInetAddresses) {
                for (int i = 0; i < portTryCount; ++i) {
                    addressList.add(new Address(scopedAddress, (InetAddress)inet6Address, possiblePort + i));
                }
            }
        }
        return AddressHelper.toAddresses(addressList);
    }

    private static Addresses toAddresses(List<Address> addressList) {
        Addresses result = new Addresses();
        if (addressList.size() > 0) {
            result.primary().add(addressList.remove(0));
            result.secondary().addAll(addressList);
        }
        return result;
    }
}

