/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConfigSections;
import com.hazelcast.client.config.YamlClientConfigLocator;
import com.hazelcast.client.config.YamlClientDomConfigProcessor;
import com.hazelcast.config.AbstractYamlConfigBuilder;
import com.hazelcast.config.ConfigLoader;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.yaml.W3cDomUtil;
import com.hazelcast.config.yaml.YamlDomChecker;
import com.hazelcast.internal.yaml.YamlLoader;
import com.hazelcast.internal.yaml.YamlMapping;
import com.hazelcast.internal.yaml.YamlNode;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.util.ExceptionUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.w3c.dom.Node;

public class YamlClientConfigBuilder
extends AbstractYamlConfigBuilder {
    private static final ILogger LOGGER = Logger.getLogger(YamlClientConfigBuilder.class);
    private final InputStream in;

    public YamlClientConfigBuilder(String resource) throws IOException {
        URL url = ConfigLoader.locateConfig((String)resource);
        if (url == null) {
            throw new IllegalArgumentException("Could not load " + resource);
        }
        this.in = url.openStream();
    }

    public YamlClientConfigBuilder(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("File is null!");
        }
        this.in = new FileInputStream(file);
    }

    public YamlClientConfigBuilder(URL url) throws IOException {
        if (url == null) {
            throw new NullPointerException("URL is null!");
        }
        this.in = url.openStream();
    }

    public YamlClientConfigBuilder(InputStream in) {
        this.in = in;
    }

    public YamlClientConfigBuilder() {
        this((YamlClientConfigLocator)null);
    }

    public YamlClientConfigBuilder(YamlClientConfigLocator locator) {
        if (locator == null) {
            locator = new YamlClientConfigLocator();
            locator.locateEverywhere();
        }
        this.in = locator.getIn();
    }

    public ClientConfig build() {
        return this.build(Thread.currentThread().getContextClassLoader());
    }

    public ClientConfig build(ClassLoader classLoader) {
        ClientConfig clientConfig = new ClientConfig();
        this.build(clientConfig, classLoader);
        return clientConfig;
    }

    public void setProperties(Properties properties) {
        this.setPropertiesInternal(properties);
    }

    void build(ClientConfig clientConfig, ClassLoader classLoader) {
        clientConfig.setClassLoader(classLoader);
        try {
            this.parseAndBuildConfig(clientConfig);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        finally {
            IOUtil.closeResource((Closeable)this.in);
        }
    }

    private void parseAndBuildConfig(ClientConfig config) throws Exception {
        YamlMapping yamlRootNode;
        try {
            yamlRootNode = (YamlMapping)YamlLoader.load((InputStream)this.in);
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException("Invalid YAML configuration", (Throwable)ex);
        }
        YamlMapping clientRoot = yamlRootNode.childAsMapping(ClientConfigSections.HAZELCAST_CLIENT.name);
        if (clientRoot == null) {
            throw new InvalidConfigurationException("No mapping with hazelcast-client key is found in the provided configuration");
        }
        YamlDomChecker.check((YamlNode)clientRoot);
        Node w3cRootNode = W3cDomUtil.asW3cNode((YamlNode)clientRoot);
        this.replaceVariables(w3cRootNode);
        this.importDocuments((YamlNode)clientRoot);
        new YamlClientDomConfigProcessor(true, config).buildConfig(w3cRootNode);
    }

    protected String getConfigRoot() {
        return ClientConfigSections.HAZELCAST_CLIENT.name;
    }
}

