/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cp.internal.datastructures.countdownlatch;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CPCountDownLatchAwaitCodec;
import com.hazelcast.client.impl.protocol.codec.CPCountDownLatchCountDownCodec;
import com.hazelcast.client.impl.protocol.codec.CPCountDownLatchGetCountCodec;
import com.hazelcast.client.impl.protocol.codec.CPCountDownLatchGetRoundCodec;
import com.hazelcast.client.impl.protocol.codec.CPCountDownLatchTrySetCountCodec;
import com.hazelcast.client.impl.protocol.codec.CPGroupDestroyCPObjectCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.UuidUtil;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

class RaftCountDownLatchProxy
extends ClientProxy
implements ICountDownLatch {
    private final RaftGroupId groupId;
    private final String objectName;

    RaftCountDownLatchProxy(ClientContext context, RaftGroupId groupId, String proxyName, String objectName) {
        super("hz:raft:countDownLatchService", proxyName, context);
        this.groupId = groupId;
        this.objectName = objectName;
    }

    public boolean await(long timeout, TimeUnit unit) {
        Preconditions.checkNotNull((Object)((Object)unit));
        long timeoutMillis = Math.max(0L, unit.toMillis(timeout));
        ClientMessage request = CPCountDownLatchAwaitCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName, (UUID)UuidUtil.newUnsecureUUID(), (long)timeoutMillis);
        ClientMessage response = (ClientMessage)new ClientInvocation(this.getClient(), request, this.name).invoke().join();
        return CPCountDownLatchAwaitCodec.decodeResponse((ClientMessage)response).response;
    }

    public void countDown() {
        int round = this.getRound();
        UUID invocationUid = UuidUtil.newUnsecureUUID();
        while (true) {
            try {
                this.countDown(round, invocationUid);
                return;
            }
            catch (OperationTimeoutException e) {
                EmptyStatement.ignore((Throwable)e);
                continue;
            }
            break;
        }
    }

    private int getRound() {
        ClientMessage request = CPCountDownLatchGetRoundCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName);
        ClientMessage response = (ClientMessage)new ClientInvocation(this.getClient(), request, this.name).invoke().join();
        return CPCountDownLatchGetRoundCodec.decodeResponse((ClientMessage)response).response;
    }

    private void countDown(int round, UUID invocationUid) {
        ClientMessage request = CPCountDownLatchCountDownCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName, (UUID)invocationUid, (int)round);
        new ClientInvocation(this.getClient(), request, this.name).invoke().join();
    }

    public int getCount() {
        ClientMessage request = CPCountDownLatchGetCountCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName);
        ClientMessage response = (ClientMessage)new ClientInvocation(this.getClient(), request, this.name).invoke().join();
        return CPCountDownLatchGetCountCodec.decodeResponse((ClientMessage)response).response;
    }

    public boolean trySetCount(int count) {
        ClientMessage request = CPCountDownLatchTrySetCountCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName, (int)count);
        ClientMessage response = (ClientMessage)new ClientInvocation(this.getClient(), request, this.name).invoke().join();
        return CPCountDownLatchTrySetCountCodec.decodeResponse((ClientMessage)response).response;
    }

    @Override
    public String getPartitionKey() {
        throw new UnsupportedOperationException();
    }

    public CPGroupId getGroupId() {
        return this.groupId;
    }

    @Override
    public void onDestroy() {
        ClientMessage request = CPGroupDestroyCPObjectCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.getServiceName(), (String)this.objectName);
        new ClientInvocation(this.getClient(), request, this.name).invoke().join();
    }
}

