/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientFailoverConfig;
import com.hazelcast.client.config.ClientFailoverConfigSections;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.config.AbstractDomConfigProcessor;
import com.hazelcast.config.DomConfigHelper;
import com.hazelcast.config.InvalidConfigurationException;
import java.io.IOException;
import org.w3c.dom.Node;

class ClientFailoverDomConfigProcessor
extends AbstractDomConfigProcessor {
    private final ClientFailoverConfig clientFailoverConfig;

    ClientFailoverDomConfigProcessor(boolean domLevel3, ClientFailoverConfig clientFailoverConfig) {
        super(domLevel3);
        this.clientFailoverConfig = clientFailoverConfig;
    }

    public void buildConfig(Node rootNode) {
        for (Node node : DomConfigHelper.childElements((Node)rootNode)) {
            String nodeName = DomConfigHelper.cleanNodeName((Node)node);
            if (this.occurrenceSet.contains(nodeName)) {
                throw new InvalidConfigurationException("Duplicate '" + nodeName + "' definition found in XML configuration");
            }
            this.handleXmlNode(node, nodeName);
            if (ClientFailoverConfigSections.canOccurMultipleTimes(nodeName)) continue;
            this.occurrenceSet.add(nodeName);
        }
    }

    private void handleXmlNode(Node node, String nodeName) {
        if (ClientFailoverConfigSections.CLIENTS.isEqual(nodeName)) {
            this.handleClients(node);
        } else if (ClientFailoverConfigSections.TRY_COUNT.isEqual(nodeName)) {
            this.handleTryCount(node);
        }
    }

    private void handleClients(Node node) {
        for (Node child : DomConfigHelper.childElements((Node)node)) {
            if (!"client".equals(DomConfigHelper.cleanNodeName((Node)child))) continue;
            String clientPath = this.getTextContent(child);
            try {
                ClientConfig config = new XmlClientConfigBuilder(clientPath).build();
                this.clientFailoverConfig.addClientConfig(config);
            }
            catch (IOException e) {
                throw new InvalidConfigurationException("Could not create the config from given path : " + clientPath, (Throwable)e);
            }
        }
    }

    private void handleTryCount(Node node) {
        int tryCount = Integer.parseInt(this.getTextContent(node));
        this.clientFailoverConfig.setTryCount(tryCount);
    }
}

