/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientOutOfMemoryHandler;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientFailoverConfig;
import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.client.impl.clientside.DefaultClientConnectionManagerFactory;
import com.hazelcast.client.impl.clientside.FailoverClientConfigSupport;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.core.DuplicateInstanceNameException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.OutOfMemoryHandler;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.util.EmptyStatement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class HazelcastClient {
    static final ConcurrentMap<String, HazelcastClientProxy> CLIENTS;

    private HazelcastClient() {
    }

    public static HazelcastInstance newHazelcastClient() {
        return HazelcastClient.newHazelcastClientInternal(null, FailoverClientConfigSupport.resolveClientConfig());
    }

    public static HazelcastInstance newHazelcastClient(ClientConfig config) {
        return HazelcastClient.newHazelcastClientInternal(null, FailoverClientConfigSupport.resolveClientConfig(config));
    }

    public static HazelcastInstance newHazelcastFailoverClient(ClientFailoverConfig clientFailoverConfig) {
        return HazelcastClient.newHazelcastClientInternal(null, FailoverClientConfigSupport.resolveClientConfig(clientFailoverConfig));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HazelcastInstance newHazelcastClientInternal(AddressProvider addressProvider, ClientFailoverConfig failoverConfig) {
        HazelcastClientProxy proxy;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(HazelcastClient.class.getClassLoader());
            DefaultClientConnectionManagerFactory factory = new DefaultClientConnectionManagerFactory();
            HazelcastClientInstanceImpl client = new HazelcastClientInstanceImpl(failoverConfig, factory, addressProvider);
            client.start();
            OutOfMemoryErrorDispatcher.registerClient((HazelcastInstance)client);
            proxy = new HazelcastClientProxy(client);
            if (CLIENTS.putIfAbsent(client.getName(), proxy) != null) {
                throw new DuplicateInstanceNameException("HazelcastClientInstance with name '" + client.getName() + "' already exists!");
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        return proxy;
    }

    public static HazelcastInstance getHazelcastClientByName(String instanceName) {
        return (HazelcastInstance)CLIENTS.get(instanceName);
    }

    public static Collection<HazelcastInstance> getAllHazelcastClients() {
        Collection values = CLIENTS.values();
        return Collections.unmodifiableCollection(new HashSet(values));
    }

    public static void shutdownAll() {
        for (HazelcastClientProxy proxy : CLIENTS.values()) {
            HazelcastClientInstanceImpl client = proxy.client;
            if (client == null) continue;
            proxy.client = null;
            try {
                client.shutdown();
            }
            catch (Throwable ignored) {
                EmptyStatement.ignore((Throwable)ignored);
            }
        }
        OutOfMemoryErrorDispatcher.clearClients();
        CLIENTS.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown(HazelcastInstance instance) {
        if (instance instanceof HazelcastClientProxy) {
            HazelcastClientProxy proxy = (HazelcastClientProxy)instance;
            HazelcastClientInstanceImpl client = proxy.client;
            if (client == null) {
                return;
            }
            proxy.client = null;
            CLIENTS.remove(client.getName());
            try {
                client.shutdown();
            }
            catch (Throwable ignored) {
                EmptyStatement.ignore((Throwable)ignored);
            }
            finally {
                OutOfMemoryErrorDispatcher.deregisterClient((HazelcastInstance)client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown(String instanceName) {
        HazelcastClientProxy proxy = (HazelcastClientProxy)CLIENTS.remove(instanceName);
        if (proxy == null) {
            return;
        }
        HazelcastClientInstanceImpl client = proxy.client;
        if (client == null) {
            return;
        }
        proxy.client = null;
        try {
            client.shutdown();
        }
        catch (Throwable ignored) {
            EmptyStatement.ignore((Throwable)ignored);
        }
        finally {
            OutOfMemoryErrorDispatcher.deregisterClient((HazelcastInstance)client);
        }
    }

    public static void setOutOfMemoryHandler(OutOfMemoryHandler outOfMemoryHandler) {
        OutOfMemoryErrorDispatcher.setClientHandler((OutOfMemoryHandler)outOfMemoryHandler);
    }

    static {
        OutOfMemoryErrorDispatcher.setClientHandler((OutOfMemoryHandler)new ClientOutOfMemoryHandler());
        CLIENTS = new ConcurrentHashMap<String, HazelcastClientProxy>(5);
    }
}

